/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.provisioning;

import com.ibm.ws.kernel.boot.cmdline.Utils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

public abstract class AbstractResourceRepository {
    protected abstract File getRootDirectory();

    protected abstract String getDefaultBaseLocation();

    protected abstract List<Resource> getResourcesBySymbolicName(String var1);

    protected abstract void includeBaseLocation(String var1);

    protected abstract boolean isBaseLocationIncluded(String var1);

    protected abstract void warnThatAnIFixWasIgnored(String var1, String var2, int var3, int var4, int var5);

    protected File selectResource(String baseLocation, String symbolicName, VersionRange versionRange) {
        return this.selectResource(baseLocation, symbolicName, versionRange, true, false);
    }

    protected File selectResource(String baseLocation, String symbolicName, VersionRange versionRange, boolean performURICheck) {
        return this.selectResource(baseLocation, symbolicName, versionRange, performURICheck, false);
    }

    protected File selectResource(String baseLocation, String symbolicName, VersionRange versionRange, boolean performURICheck, boolean selectBaseBundle) {
        HashSet<String> baseLocationParts;
        if (baseLocation == null || "".equals(baseLocation)) {
            baseLocation = this.getDefaultBaseLocation();
        }
        if (!baseLocation.contains(",")) {
            File candidateFile;
            if (performURICheck) {
                try {
                    candidateFile = new File(URI.create(baseLocation));
                    if (candidateFile.exists() && candidateFile.isFile() && candidateFile.isAbsolute()) {
                        return this.validateR4Bundle(candidateFile);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if ((candidateFile = new File(this.getRootDirectory(), baseLocation)).exists() && candidateFile.isFile()) {
                return this.validateR4Bundle(candidateFile);
            }
            baseLocationParts = new HashSet();
            baseLocationParts.add(baseLocation);
        } else {
            baseLocationParts = new HashSet<String>(Arrays.asList(baseLocation.split(",")));
        }
        for (String baseLocationPart : baseLocationParts) {
            if (this.isBaseLocationIncluded(baseLocationPart = baseLocationPart.trim())) continue;
            this.includeBaseLocation(baseLocationPart);
        }
        List<Resource> candidateResources = this.getResourcesBySymbolicName(symbolicName);
        if (candidateResources != null) {
            Collections.sort(candidateResources);
            Resource bestMatch = null;
            for (Resource candidateResource : candidateResources) {
                if (!baseLocationParts.contains(candidateResource.getBaseLocation()) || !versionRange.includes(candidateResource.getVersion())) continue;
                if (bestMatch == null) {
                    if (!candidateResource.isFix()) {
                        return candidateResource.getFile();
                    }
                    bestMatch = candidateResource;
                    continue;
                }
                int bestMatchMajor = bestMatch.getVersion().getMajor();
                int bestMatchMinor = bestMatch.getVersion().getMinor();
                int bestMatchMicro = bestMatch.getVersion().getMicro();
                if (bestMatchMajor == candidateResource.getVersion().getMajor() && bestMatchMinor == candidateResource.getVersion().getMinor() && bestMatchMicro == candidateResource.getVersion().getMicro()) {
                    if (candidateResource.isFix()) continue;
                    return selectBaseBundle ? candidateResource.getFile() : bestMatch.getFile();
                }
                this.warnThatAnIFixWasIgnored(bestMatch.getFile().getName(), bestMatch.getSymbolicName(), bestMatchMajor, bestMatchMinor, bestMatchMicro);
                if (!candidateResource.isFix()) {
                    return candidateResource.getFile();
                }
                bestMatch = candidateResource;
            }
            if (bestMatch != null && !bestMatch.isFix()) {
                return bestMatch.getFile();
            }
        }
        return null;
    }

    /*
     * Loose catch block
     */
    private File validateR4Bundle(File candidateFile) {
        block5: {
            JarFile jar;
            block4: {
                File file;
                jar = null;
                try {
                    jar = new JarFile(candidateFile);
                    Manifest man = jar.getManifest();
                    if (man == null || man.getMainAttributes().getValue("Bundle-ManifestVersion") == null) break block4;
                    file = candidateFile;
                }
                catch (IOException iOException) {
                    Utils.tryToClose(jar);
                    break block5;
                    catch (Throwable throwable) {
                        Utils.tryToClose(jar);
                        throw throwable;
                    }
                }
                Utils.tryToClose(jar);
                return file;
            }
            Utils.tryToClose(jar);
        }
        return null;
    }

    protected abstract class Resource
    implements Comparable<Resource> {
        protected Resource() {
        }

        protected abstract File getFile();

        protected abstract String getBaseLocation();

        protected abstract Version getVersion();

        protected abstract boolean isFix();

        protected abstract String getSymbolicName();

        @Override
        public int compareTo(Resource other) {
            Version otherVersion = other.getVersion();
            Version thisVersion = this.getVersion();
            return otherVersion.compareTo(thisVersion);
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (other instanceof Resource && other.getClass() == this.getClass()) {
                return this.compareTo((Resource)other) == 0;
            }
            return false;
        }

        public int hashCode() {
            return this.getVersion().hashCode();
        }
    }
}

