/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.common.adapter;

import com.ibm.wssvt.acme.common.adapter.IServerAdapter;
import com.ibm.wssvt.acme.common.adapter.IServerAdapterEvent;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ServerAdapterEvent
implements Serializable,
IServerAdapterEvent {
    private static final long serialVersionUID = 1978445384864558975L;
    private IServerAdapter adapter;
    private long request;
    private long create;
    private long read;
    private long update;
    private long delete;
    private long find;
    private Map<String, Long> serverRunInfo = new HashMap<String, Long>();
    private Map<String, Long> overallServerRunInfo = new HashMap<String, Long>();

    @Override
    public synchronized void clearAll() {
        this.request = 0L;
        this.create = 0L;
        this.read = 0L;
        this.update = 0L;
        this.delete = 0L;
        this.serverRunInfo.clear();
        this.overallServerRunInfo.clear();
    }

    @Override
    public synchronized long incrumentRequest() {
        return ++this.request;
    }

    @Override
    public synchronized long incrumentCreate() {
        return ++this.create;
    }

    @Override
    public synchronized long incrumentRead() {
        return ++this.read;
    }

    @Override
    public synchronized long incrumentUpdate() {
        return ++this.update;
    }

    @Override
    public synchronized long incrumentDelete() {
        return ++this.delete;
    }

    @Override
    public synchronized long incrumentFind() {
        return ++this.find;
    }

    @Override
    public IServerAdapter getServerAdapter() {
        return this.adapter;
    }

    @Override
    public void setServerAdapter(IServerAdapter adapter) {
        this.adapter = adapter;
    }

    @Override
    public long getCreate() {
        return this.create;
    }

    @Override
    public long getDelete() {
        return this.delete;
    }

    @Override
    public long getFind() {
        return this.find;
    }

    @Override
    public long getRead() {
        return this.read;
    }

    @Override
    public long getUpdate() {
        return this.update;
    }

    @Override
    public long getRequest() {
        return this.request;
    }

    @Override
    public Map<String, Long> getRunServerInfoCount() {
        return this.serverRunInfo;
    }

    @Override
    public long incrumentRunServerCount(String serverName) {
        if (serverName == null || "".equals(serverName.trim())) {
            return 0L;
        }
        Long res = this.serverRunInfo.get(serverName);
        if (res == null) {
            res = 0L;
        }
        res = res + 1L;
        this.serverRunInfo.put(serverName, res);
        return res;
    }

    @Override
    public Map<String, Long> getOverallRunServerInfoCount() {
        return this.overallServerRunInfo;
    }

    @Override
    public long incrumentOverallRunServerCount(String serverName) {
        if (serverName == null || "".equals(serverName.trim())) {
            return 0L;
        }
        Long res = this.overallServerRunInfo.get(serverName);
        if (res == null) {
            res = 0L;
        }
        res = res + 1L;
        this.overallServerRunInfo.put(serverName, res);
        return res;
    }
}

