/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.common.client.ui.gui;

import com.ibm.wssvt.acme.common.bean.StringConfigrable;
import com.ibm.wssvt.acme.common.client.ui.gui.ACMECommonPanels;
import com.ibm.wssvt.acme.common.client.ui.gui.MainFrame;
import com.ibm.wssvt.acme.common.client.ui.gui.model.AdapterConfigurationDecorator;
import com.ibm.wssvt.acme.common.client.ui.gui.model.ExceptionHandlerConfigurationDecorator;
import com.ibm.wssvt.acme.common.client.ui.gui.model.ExecutionUnitConfigurationDecorator;
import com.ibm.wssvt.acme.common.client.ui.gui.model.IAdapterBeansFactoryMap;
import com.ibm.wssvt.acme.common.client.ui.gui.model.ParametarizableCopier;
import com.ibm.wssvt.acme.common.envconfig.AcmeEnvConfigBean;
import com.ibm.wssvt.acme.common.envconfig.AcmeEnvConfigLoader;
import com.ibm.wssvt.acme.common.envconfig.AdapterConfiguration;
import com.ibm.wssvt.acme.common.envconfig.ClientConfiguration;
import com.ibm.wssvt.acme.common.envconfig.EnvConfigStringParameterizable;
import com.ibm.wssvt.acme.common.envconfig.ExceptionHandlerConfiguration;
import com.ibm.wssvt.acme.common.envconfig.ExecutionUnitConfiguration;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class AcmeGUI {
    private static AcmeEnvConfigBean templateDocument = new AcmeEnvConfigBean();
    private static AcmeEnvConfigBean configuredDocument = new AcmeEnvConfigBean();
    private static StringConfigrable templateGlobalParams = new StringConfigrable();
    private static StringConfigrable configuredGlobalParams = new StringConfigrable();
    private static ClientConfiguration templateClientConfig = new ClientConfiguration();
    private static ClientConfiguration configuredClientConfig = new ClientConfiguration();
    private static Vector<AdapterConfigurationDecorator> templateAdaptersDataModel = new Vector();
    private static Vector<AdapterConfigurationDecorator> configuredAdaptersDataModel = new Vector();
    private static Vector<ExecutionUnitConfigurationDecorator> templateExecutionUnitsDataModel = new Vector();
    private static Vector<ExecutionUnitConfigurationDecorator> configuredExecutionUnitsDataModel = new Vector();
    private static Vector<ExceptionHandlerConfigurationDecorator> templateExceptionHandlersDataModel = new Vector();
    private static Vector<ExceptionHandlerConfigurationDecorator> configuredExceptionHandlersDataModel = new Vector();
    private static IAdapterBeansFactoryMap adapterBeansFactoryMap = null;

    public static IAdapterBeansFactoryMap getAdapterBeansFactoryMap() {
        return adapterBeansFactoryMap;
    }

    public static void setAdapterBeansFactoryMap(IAdapterBeansFactoryMap adapterBeansFactoryMap) {
        AcmeGUI.adapterBeansFactoryMap = adapterBeansFactoryMap;
    }

    public static void reset() {
        AcmeGUI.setTemplateGlobalParams(new StringConfigrable());
        AcmeGUI.setConfiguredGlobalParams(new StringConfigrable());
        AcmeGUI.setTemplateClientConfig(new ClientConfiguration());
        AcmeGUI.setConfiguredClientConfig(new ClientConfiguration());
        AcmeGUI.setTemplateAdaptersDataModel(new Vector<AdapterConfigurationDecorator>());
        AcmeGUI.setSelectedAdaptersDataModel(new Vector<AdapterConfigurationDecorator>());
        AcmeGUI.setTemplateExecutionUnitsDataModel(new Vector<ExecutionUnitConfigurationDecorator>());
        AcmeGUI.setConfiguredExecutionUnitsDataModel(new Vector<ExecutionUnitConfigurationDecorator>());
        AcmeGUI.setTemplateExceptionHandlersDataModel(new Vector<ExceptionHandlerConfigurationDecorator>());
        AcmeGUI.setConfiguredExceptionHandlersDataModel(new Vector<ExceptionHandlerConfigurationDecorator>());
        AcmeGUI.setConfiguredDocument(new AcmeEnvConfigBean());
    }

    public static void launchApp(final List<JPanel> panels, IAdapterBeansFactoryMap adapterBeansFactoryMap) {
        if (adapterBeansFactoryMap == null) {
            throw new IllegalArgumentException("The object adapterBeansFactoryMap is null");
        }
        AcmeGUI.setAdapterBeansFactoryMap(adapterBeansFactoryMap);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (panels == null) {
                    ArrayList<JPanel> acmeCommonOnlyPanels = new ArrayList<JPanel>();
                    acmeCommonOnlyPanels.add(ACMECommonPanels.STARTUP_PANEL.getPanel());
                    acmeCommonOnlyPanels.add(ACMECommonPanels.CLIENT_CONFIG_PANEL.getPanel());
                    acmeCommonOnlyPanels.add(ACMECommonPanels.ADAPTERS_PANEL.getPanel());
                    acmeCommonOnlyPanels.add(ACMECommonPanels.EXECUTION_UNITS_PANEL.getPanel());
                    acmeCommonOnlyPanels.add(ACMECommonPanels.EXCEPTION_HANDLERS_PANEL.getPanel());
                    acmeCommonOnlyPanels.add(ACMECommonPanels.GLOBAL_PARAMS_PANEL.getPanel());
                    acmeCommonOnlyPanels.add(ACMECommonPanels.ACTIONS_PANEL.getPanel());
                    MainFrame mainFrame = new MainFrame(acmeCommonOnlyPanels);
                    mainFrame.setDefaultCloseOperation(3);
                    mainFrame.setVisible(true);
                } else {
                    MainFrame mainFrame = new MainFrame(panels);
                    mainFrame.setDefaultCloseOperation(3);
                    mainFrame.setVisible(true);
                }
            }
        });
    }

    private static boolean loadXML(String fileName, boolean config) {
        try {
            AcmeEnvConfigLoader.init(fileName);
            AcmeGUI.setTemplateDocument(AcmeEnvConfigLoader.getInstance().getConfigBean());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        AcmeGUI.reset();
        AcmeGUI.getTemplateGlobalParams().setConfiguration(AcmeGUI.getTemplateDocument().getGlobalConfigurationParams());
        AcmeGUI.getConfiguredGlobalParams().setConfiguration(ParametarizableCopier.getCopy(AcmeGUI.getTemplateGlobalParams().getConfiguration(), new EnvConfigStringParameterizable()));
        AcmeGUI.getTemplateClientConfig().setId(AcmeGUI.getTemplateDocument().getClientConfiguration().getId());
        AcmeGUI.getTemplateClientConfig().setRunTime(AcmeGUI.getTemplateDocument().getClientConfiguration().getRunTime());
        AcmeGUI.getTemplateClientConfig().setThreadCount(AcmeGUI.getTemplateDocument().getClientConfiguration().getThreadCount());
        AcmeGUI.getTemplateClientConfig().setThreadExecDelay(AcmeGUI.getTemplateDocument().getClientConfiguration().getThreadExecDelay());
        AcmeGUI.getTemplateClientConfig().setConfiguration(AcmeGUI.getTemplateDocument().getClientConfiguration().getConfiguration());
        AcmeGUI.getConfiguredClientConfig().setId(AcmeGUI.getTemplateClientConfig().getId());
        AcmeGUI.getConfiguredClientConfig().setRunTime(AcmeGUI.getTemplateClientConfig().getRunTime());
        AcmeGUI.getConfiguredClientConfig().setThreadCount(AcmeGUI.getTemplateClientConfig().getThreadCount());
        AcmeGUI.getConfiguredClientConfig().setThreadExecDelay(AcmeGUI.getTemplateClientConfig().getThreadExecDelay());
        AcmeGUI.getConfiguredClientConfig().setConfiguration(AcmeGUI.getTemplateClientConfig().getConfiguration());
        for (AdapterConfiguration ac : AcmeGUI.getTemplateDocument().getAdaptersConfigurationList()) {
            AdapterConfigurationDecorator ace = new AdapterConfigurationDecorator(ac);
            AcmeGUI.getTemplateAdaptersDataModel().add(ace);
            if (!config) continue;
            AcmeGUI.getSelectedAdaptersDataModel().add(ace.clone());
        }
        for (ExecutionUnitConfiguration euConfig : AcmeGUI.getTemplateDocument().getExecutionUnitConfigurationList()) {
            ExecutionUnitConfigurationDecorator euce = new ExecutionUnitConfigurationDecorator(euConfig);
            AcmeGUI.getTemplateExecutionUnitsDataModel().add(euce);
            if (!config) continue;
            AcmeGUI.getConfiguredExecutionUnitsDataModel().add(euce.clone());
        }
        for (ExceptionHandlerConfiguration eh : AcmeGUI.getTemplateDocument().getExceptionHandlerConfigurationList()) {
            ExceptionHandlerConfigurationDecorator ehce = new ExceptionHandlerConfigurationDecorator(eh);
            AcmeGUI.getTemplateExceptionHandlersDataModel().add(ehce);
            if (!config) continue;
            AcmeGUI.getConfiguredExceptionHandlersDataModel().add(ehce.clone());
        }
        return true;
    }

    public static boolean loadUserFile(String fileName, boolean config) {
        return AcmeGUI.loadXML(fileName, config);
    }

    public static boolean loadTemplate() {
        URL url = AcmeGUI.class.getClassLoader().getResource("ACMEClientGUITemplate.xml");
        if (url == null) {
            System.out.println("Unable to find the Template!!");
            return false;
        }
        System.out.println("loading the template: " + url);
        return AcmeGUI.loadXML(url.toString(), false);
    }

    public static void setTemplateGlobalParams(StringConfigrable templateGlobalParams) {
        AcmeGUI.templateGlobalParams = templateGlobalParams;
    }

    public static StringConfigrable getTemplateGlobalParams() {
        return templateGlobalParams;
    }

    public static void setConfiguredGlobalParams(StringConfigrable updatedGlobalParams) {
        configuredGlobalParams = updatedGlobalParams;
    }

    public static StringConfigrable getConfiguredGlobalParams() {
        return configuredGlobalParams;
    }

    public static void setTemplateClientConfig(ClientConfiguration templateClientConfig) {
        AcmeGUI.templateClientConfig = templateClientConfig;
    }

    public static ClientConfiguration getTemplateClientConfig() {
        return templateClientConfig;
    }

    public static void setConfiguredClientConfig(ClientConfiguration updatedClientConfig) {
        configuredClientConfig = updatedClientConfig;
    }

    public static ClientConfiguration getConfiguredClientConfig() {
        return configuredClientConfig;
    }

    public static void setTemplateAdaptersDataModel(Vector<AdapterConfigurationDecorator> templateAdaptersDataModel) {
        AcmeGUI.templateAdaptersDataModel = templateAdaptersDataModel;
    }

    public static Vector<AdapterConfigurationDecorator> getTemplateAdaptersDataModel() {
        return templateAdaptersDataModel;
    }

    public static void setSelectedAdaptersDataModel(Vector<AdapterConfigurationDecorator> selectedAdaptersDataModel) {
        configuredAdaptersDataModel = selectedAdaptersDataModel;
    }

    public static Vector<AdapterConfigurationDecorator> getSelectedAdaptersDataModel() {
        return configuredAdaptersDataModel;
    }

    public static void setTemplateExecutionUnitsDataModel(Vector<ExecutionUnitConfigurationDecorator> templateExecutionUnitsDataModel) {
        AcmeGUI.templateExecutionUnitsDataModel = templateExecutionUnitsDataModel;
    }

    public static Vector<ExecutionUnitConfigurationDecorator> getTemplateExecutionUnitsDataModel() {
        return templateExecutionUnitsDataModel;
    }

    public static void setConfiguredExecutionUnitsDataModel(Vector<ExecutionUnitConfigurationDecorator> configuredExecutionUnitsDataModel) {
        AcmeGUI.configuredExecutionUnitsDataModel = configuredExecutionUnitsDataModel;
    }

    public static Vector<ExecutionUnitConfigurationDecorator> getConfiguredExecutionUnitsDataModel() {
        return configuredExecutionUnitsDataModel;
    }

    public static void setTemplateExceptionHandlersDataModel(Vector<ExceptionHandlerConfigurationDecorator> templateExceptionHandlersDataModel) {
        AcmeGUI.templateExceptionHandlersDataModel = templateExceptionHandlersDataModel;
    }

    public static Vector<ExceptionHandlerConfigurationDecorator> getTemplateExceptionHandlersDataModel() {
        return templateExceptionHandlersDataModel;
    }

    public static void setConfiguredExceptionHandlersDataModel(Vector<ExceptionHandlerConfigurationDecorator> configuredExceptionHandlersDataModel) {
        AcmeGUI.configuredExceptionHandlersDataModel = configuredExceptionHandlersDataModel;
    }

    public static Vector<ExceptionHandlerConfigurationDecorator> getConfiguredExceptionHandlersDataModel() {
        return configuredExceptionHandlersDataModel;
    }

    public static void setTemplateDocument(AcmeEnvConfigBean templateDocument) {
        AcmeGUI.templateDocument = templateDocument;
    }

    public static AcmeEnvConfigBean getTemplateDocument() {
        return templateDocument;
    }

    public static void setConfiguredDocument(AcmeEnvConfigBean configuredDocument) {
        AcmeGUI.configuredDocument = configuredDocument;
    }

    public static AcmeEnvConfigBean getConfiguredDocument() {
        return configuredDocument;
    }
}

