/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.common.executionunit;

import com.ibm.wssvt.acme.common.adapter.IServerAdapter;
import com.ibm.wssvt.acme.common.bean.IBeansFactory;
import com.ibm.wssvt.acme.common.bean.Parameterizable;
import com.ibm.wssvt.acme.common.executionunit.ExecutionUnitEvent;
import com.ibm.wssvt.acme.common.executionunit.IExecutionUnit;
import com.ibm.wssvt.acme.common.executionunit.IExecutionUnitEvent;
import com.ibm.wssvt.acme.common.executionunit.IExecutionUnitEventListener;
import com.ibm.wssvt.acme.common.util.ClientContext;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractExecutionUnit
implements IExecutionUnit {
    private static final long serialVersionUID = 8688712524892475458L;
    private String description;
    private IServerAdapter adapter;
    private IBeansFactory beansFactory;
    private Parameterizable<String, String> euConfig = null;
    private List<IExecutionUnitEventListener> listeners = new ArrayList<IExecutionUnitEventListener>();
    private IExecutionUnitEvent executionUnitEvent = new ExecutionUnitEvent();
    private ClientContext clientContext;

    public AbstractExecutionUnit() {
        this.executionUnitEvent.setExecutionUnit(this);
    }

    @Override
    public synchronized void addEventListener(IExecutionUnitEventListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public synchronized boolean removeEventListener(IExecutionUnitEventListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public IServerAdapter getServerAdapter() {
        return this.adapter;
    }

    @Override
    public void setServerAdapter(IServerAdapter adapter) {
        this.adapter = adapter;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public synchronized void fireToListeners() {
        for (IExecutionUnitEventListener listener : this.listeners) {
            listener.processExecutionUnitEvent(this.executionUnitEvent);
        }
        this.executionUnitEvent.clearAll();
    }

    @Override
    public synchronized void clearListeners() {
        this.listeners.clear();
    }

    public IExecutionUnitEvent getExecutionUnitEvent() {
        return this.executionUnitEvent;
    }

    public void setExecutionUnitEvent(IExecutionUnitEvent executionUnitEvent) {
        this.executionUnitEvent = executionUnitEvent;
    }

    @Override
    public synchronized void clearEvents() {
        this.executionUnitEvent.clearAll();
    }

    @Override
    public Parameterizable<String, String> getConfiguration() {
        return this.euConfig;
    }

    @Override
    public void setConfiguration(Parameterizable<String, String> config) {
        this.euConfig = config;
    }

    @Override
    public ClientContext getClientContext() {
        return this.clientContext;
    }

    @Override
    public void setClientContext(ClientContext clientContext) {
        this.clientContext = clientContext;
    }

    @Override
    public IBeansFactory getBeansFactory() {
        return this.beansFactory;
    }

    @Override
    public void setBeansFactory(IBeansFactory beansFactory) {
        this.beansFactory = beansFactory;
    }
}

