/*
 * Decompiled with CFR 0.152.
 */
package wlp.lib.extract;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.jar.Attributes;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import wlp.lib.extract.ExtractProgress;
import wlp.lib.extract.SelfExtract;
import wlp.lib.extract.SelfExtractor;

public class SelfExtractUtils {
    private static final int LINE_WRAP_COLUMNS = 72;
    public static final String DOWNLOAD_URL = "download.url";
    public static final String DOWNLOAD_TARGET = "download.target";
    public static final String DOWNLOAD_TARGET_FILE = "download.target.file";
    public static final String DOWNLOAD_CONTENT_SIZE = "download.content.size";

    static final File getSelf() {
        File s;
        block3: {
            URL url;
            s = null;
            ProtectionDomain pd = SelfExtract.class.getProtectionDomain();
            CodeSource cs = pd.getCodeSource();
            if (cs != null && (url = cs.getLocation()) != null) {
                try {
                    s = new File(new URI(url.toString()));
                }
                catch (URISyntaxException ex) {
                    if (!url.getProtocol().equals("file")) break block3;
                    s = new File(url.getPath());
                }
            }
        }
        return s;
    }

    static final ZipEntry getLicenseFile(ZipFile zipFile, String prefix) {
        if (!prefix.endsWith("_")) {
            prefix = prefix + "_";
        }
        Locale locale = Locale.getDefault();
        String lang = locale.getLanguage();
        String country = locale.getCountry();
        ZipEntry zipEntry = null;
        String[] suffixes = new String[]{lang + '_' + country, lang, "en"};
        for (int i = 0; i < suffixes.length && (zipEntry = zipFile.getEntry(prefix + suffixes[i])) == null; ++i) {
        }
        return zipEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Exception showLicenseFile(InputStream in) {
        ArrayList lines = new ArrayList();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(in, "UTF-16"));
            while ((line = reader.readLine()) != null) {
                SelfExtractUtils.wordWrap(line, lines);
            }
            for (int i = 0; i < lines.size(); ++i) {
                System.out.println(lines.get(i));
            }
            System.out.flush();
            System.out.println();
            Exception i = null;
            SelfExtractUtils.tryToClose(reader);
            return i;
        }
        catch (Exception e) {
            Exception exception = e;
            return exception;
        }
        finally {
            SelfExtractUtils.tryToClose(reader);
        }
    }

    static List wordWrap(String line, List lines) {
        if (lines == null) {
            lines = new ArrayList<String>();
        }
        if (line.length() == 0) {
            lines.add("");
            return lines;
        }
        int begin = 0;
        while (begin < line.length()) {
            int tryEnd;
            int end;
            if (begin + 72 >= line.length()) {
                lines.add(line.substring(begin));
                break;
            }
            for (end = tryEnd = Math.min(line.length(), begin + 72); end > begin && !Character.isWhitespace(line.charAt(end - 1)); --end) {
            }
            while (end > begin && Character.isWhitespace(line.charAt(end - 1))) {
                --end;
            }
            if (end == begin) {
                for (end = tryEnd; end < line.length() && !Character.isWhitespace(line.charAt(end)); ++end) {
                }
            }
            lines.add(line.substring(begin, end));
            for (begin = end; begin < line.length() && Character.isWhitespace(line.charAt(begin)); ++begin) {
            }
        }
        return lines;
    }

    static final Exception makeExecutable(List scripts, ExtractProgress ep) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("chmod");
        cmd.add("+x");
        cmd.addAll(scripts);
        ep.commandRun(cmd);
        try {
            Process p = Runtime.getRuntime().exec(cmd.toArray(new String[cmd.size()]));
            Thread stdout = SelfExtractUtils.copyAsync(p.getInputStream(), System.out);
            Thread stderr = SelfExtractUtils.copyAsync(p.getErrorStream(), System.err);
            stdout.join();
            stderr.join();
            p.waitFor();
        }
        catch (Exception e) {
            return e;
        }
        return null;
    }

    private static Thread copyAsync(final InputStream in, final OutputStream out) {
        Thread thread = new Thread(){

            public void run() {
                byte[] buf = new byte[4096];
                try {
                    int read;
                    while ((read = in.read(buf)) != -1) {
                        out.write(buf, 0, read);
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        };
        thread.start();
        return thread;
    }

    static final void tryToClose(ZipFile f) {
        if (f != null) {
            try {
                f.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static final void tryToClose(Reader c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static final void tryToClose(InputStream c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static final void tryToClose(OutputStream c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static List getEmptyDirectories(Attributes attribs) {
        String value;
        if (attribs != null && (value = attribs.getValue("Empty-Dirs")) != null) {
            return Arrays.asList(value.split(","));
        }
        return Arrays.asList("usr/shared/apps", "usr/shared/config", "usr/shared/resources", "templates/servers/defaultServer/apps", "templates/servers/defaultServer/dropins");
    }

    static void delete(File outputDir, boolean keepDir) {
        File[] files;
        if (outputDir.isDirectory() && (files = outputDir.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                SelfExtractUtils.delete(files[i], false);
            }
        }
        if (!keepDir) {
            outputDir.delete();
        }
    }

    static int tryGetContentLengthOfURL(URL url) {
        try {
            return url.openConnection().getContentLength();
        }
        catch (Exception e) {
            return -1;
        }
    }

    static List convertDependenciesListToMapsList(SelfExtractor.ExternalDependencies deps) {
        List depsList = deps.getDependencies();
        ArrayList depsMapsList = new ArrayList();
        for (int i = 0; i < depsList.size(); ++i) {
            SelfExtractor.ExternalDependency thisDep = (SelfExtractor.ExternalDependency)depsList.get(i);
            HashMap<String, Object> depMap = new HashMap<String, Object>();
            depMap.put(DOWNLOAD_URL, thisDep.getSourceUrl());
            depMap.put(DOWNLOAD_TARGET, thisDep.getTargetPath());
            depsMapsList.add(depMap);
        }
        return depsMapsList;
    }

    static boolean trackedMkdirs(File dir, List allDirectories) {
        if (dir.exists()) {
            return false;
        }
        File potentialNewDirRoot = dir.getParentFile();
        File lastPotentialRoot = dir;
        while (!potentialNewDirRoot.exists()) {
            lastPotentialRoot = potentialNewDirRoot;
            potentialNewDirRoot = potentialNewDirRoot.getParentFile();
        }
        allDirectories.add(lastPotentialRoot);
        return dir.mkdirs();
    }

    static void rollbackExtract(List filesAndDirectories) {
        for (int i = 0; i < filesAndDirectories.size(); ++i) {
            File target = (File)filesAndDirectories.get(i);
            if (!target.exists()) continue;
            SelfExtractUtils.delete(target, false);
        }
    }
}

