/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.business.nonbusinessimpl;

import com.ibm.wssvt.acme.annuity.common.business.IAnnuityService;
import com.ibm.wssvt.acme.annuity.common.business.nonbusinessimpl.AnnuityExceptionReturnService;
import com.ibm.wssvt.acme.annuity.common.business.nonbusinessimpl.AnnuityMemoryManagementService;
import com.ibm.wssvt.acme.annuity.common.business.nonbusinessimpl.AnnuityQuickReturnService;
import com.ibm.wssvt.acme.common.bean.Configrable;
import com.ibm.wssvt.acme.common.exception.InvalidConfigurationException;

public class AnnuitySpecialImplFactory {
    public IAnnuityService getSpecialAnnuityService(Configrable<String, String> configrable) throws InvalidConfigurationException {
        String specialService = (String)configrable.getConfiguration().getParameterValue((Object)"specialServiceName");
        if ("ExceptionReturnService".equalsIgnoreCase(specialService)) {
            return new AnnuityExceptionReturnService();
        }
        if ("MemoryManagementService".equalsIgnoreCase(specialService)) {
            return new AnnuityMemoryManagementService();
        }
        if ("QuickReturnService".equalsIgnoreCase(specialService)) {
            return new AnnuityQuickReturnService();
        }
        if (specialService != null && specialService.endsWith(".class")) {
            try {
                IAnnuityService service = (IAnnuityService)Thread.currentThread().getContextClassLoader().loadClass(specialService).newInstance();
                return service;
            }
            catch (Exception e) {
                throw new InvalidConfigurationException("Failed to load the specialServiceName value of: " + specialService + "The error is: " + e.getMessage(), (Throwable)e);
            }
        }
        throw new InvalidConfigurationException("Annuity Special Service name is NOT Valid.  Received value:  " + specialService);
    }
}

