/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.executionunit;

import com.ibm.wssvt.acme.annuity.common.bean.IPayor;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.AbastractAnnuityExecutionUnit;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.AsynchMethodHelper;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.BasicExecutionUnitLibrarry;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.ExecutionUnitVerificationHelper;
import com.ibm.wssvt.acme.annuity.common.exception.EntityAlreadyExistsException;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.common.adapter.ServerAdapterCommunicationException;
import com.ibm.wssvt.acme.common.executionunit.ExecutionUnitVerificationException;
import com.ibm.wssvt.acme.common.executionunit.IExecutionUnit;
import com.ibm.wssvt.acme.common.executionunit.InvalidExecutionUnitParameterException;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.rmi.RemoteException;

public class CRUDPayorEU
extends AbastractAnnuityExecutionUnit {
    private static final long serialVersionUID = -8980124038714550844L;
    private AcmeLogger logger;

    public void execute() {
        this.setScenarioVariables();
        this.logger.fine("Creating Payor");
        IPayor payor = null;
        try {
            payor = this.createPayor();
        }
        catch (Exception e) {
            this.logger.warning("Failed to create Payor. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.fine("Verifying Create Payor");
        try {
            this.verifyPayorValue(payor);
        }
        catch (Exception e) {
            this.logger.info("Create Payor verification failed.  Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
        this.logger.fine("Updating Payor");
        IPayor updated = null;
        try {
            updated = this.updatePayor(payor);
        }
        catch (Exception e) {
            this.logger.warning("Failed to update Payor. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.fine("Verifying Update Payor");
        try {
            this.verifyPayorValue(updated);
        }
        catch (Exception e) {
            this.logger.info("Update Payor verification failed. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
        this.logger.fine("Deleting Payor");
        try {
            this.deletePayor(updated);
        }
        catch (Exception e) {
            this.logger.info("Failed to delete Payor. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.fine("Verifying Delete Payor");
        try {
            this.verifyDelete(updated);
        }
        catch (Exception e) {
            this.logger.info("Delete Payor verification failed.  Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
    }

    private void setScenarioVariables() {
        this.logger = this.getLogger(((Object)((Object)this)).getClass().getName());
    }

    private IPayor createPayor() throws EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        IPayor payor = BasicExecutionUnitLibrarry.getPayor(this.getAnnuityBeansFactory());
        payor.setConfiguration(this.getConfiguration());
        payor = this.getServerAdapter().createPayor(payor);
        return payor;
    }

    private IPayor updatePayor(IPayor before) throws EntityNotFoundException, ServerAdapterCommunicationException, InvalidArgumentException, ServerInternalErrorException, RemoteException {
        IPayor after = BasicExecutionUnitLibrarry.getPayor(this.getAnnuityBeansFactory());
        after.setId(before.getId());
        after.setConfiguration(this.getConfiguration());
        after = this.getServerAdapter().findPayorById(after);
        after.setName(after.getName() + "-updated");
        after.setConfiguration(this.getConfiguration());
        after = this.getServerAdapter().updatePayor(after);
        return after;
    }

    private void deletePayor(IPayor payor) throws EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        IPayor removed = BasicExecutionUnitLibrarry.getPayor(this.getAnnuityBeansFactory());
        removed.setId(payor.getId());
        removed.setConfiguration(this.getConfiguration());
        this.getServerAdapter().deletePayor(removed);
    }

    private void verifyPayorValue(IPayor payor) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        IPayor results = this.getAnnuityBeansFactory().createPayor();
        results.setId(payor.getId());
        results.setConfiguration(this.getConfiguration());
        results = this.getServerAdapter().findPayorById(results);
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, payor, results, "Payor from client is not equal to DB value", "Payor Create mismacth was found.");
    }

    private void verifyDelete(IPayor payor) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException, InvalidExecutionUnitParameterException, InterruptedException {
        AsynchMethodHelper.verifyPayerDelete(payor, this, this.logger);
    }
}

