/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.executionunit;

import com.ibm.wssvt.acme.annuity.common.bean.IAnnuity;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.AbastractAnnuityExecutionUnit;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.BasicExecutionUnitLibrarry;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.ExecutionUnitVerificationHelper;
import com.ibm.wssvt.acme.annuity.common.util.AnnuityType;
import com.ibm.wssvt.acme.common.executionunit.ExecutionUnitVerificationException;
import com.ibm.wssvt.acme.common.executionunit.IExecutionUnit;
import com.ibm.wssvt.acme.common.executionunit.ISingleRunExecutionUnit;
import com.ibm.wssvt.acme.common.executionunit.ISingleThreadedExecutionUnit;
import com.ibm.wssvt.acme.common.log.AcmeLogger;

public class CreateAnnuitiesWithProvidedIdRangeEU
extends AbastractAnnuityExecutionUnit
implements ISingleThreadedExecutionUnit,
ISingleRunExecutionUnit {
    private static final long serialVersionUID = 5751982103363852382L;
    private static final String START_ID = "startId";
    private static final String END_ID = "endId";
    private static final String ANNUITY_TYPE = "annuityType";
    private static AnnuityType annuityType;

    public void execute() {
        try {
            AcmeLogger logger = this.getLogger(((Object)((Object)this)).getClass().getName());
            int startId = this.getParameterValueInt(START_ID);
            int endId = this.getParameterValueInt(END_ID);
            annuityType = this.getParameterValueEnum(AnnuityType.class, ANNUITY_TYPE);
            for (int i = startId; i < endId; ++i) {
                IAnnuity annuity = BasicExecutionUnitLibrarry.getAnnuity(this.getAnnuityBeansFactory(), annuityType);
                annuity.setId("" + i);
                annuity.setConfiguration(this.getConfiguration());
                logger.fine("Create Annuity ID=" + (String)annuity.getId());
                IAnnuity results = this.getServerAdapter().createAnnuity(annuity);
                this.verifySuccess(results, "" + i);
            }
        }
        catch (Exception e) {
            this.getExecutionUnitEvent().addException(e);
        }
    }

    private void verifySuccess(IAnnuity annuity, String id) throws ExecutionUnitVerificationException {
        ExecutionUnitVerificationHelper.assertValidId((IExecutionUnit)this, annuity, "Failed to find Annuity", null);
        ExecutionUnitVerificationHelper.assertEquals((IExecutionUnit)this, (Comparable)annuity.getId(), (Comparable)((Object)id), "Failed to find Annuity", null);
    }
}

