/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.executionunit;

import com.ibm.wssvt.acme.annuity.common.bean.IAnnuity;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.AbastractAnnuityExecutionUnit;
import com.ibm.wssvt.acme.common.executionunit.ExecutionUnitVerificationException;

public class FindAnnuityByIdFromProvidedRangeEU
extends AbastractAnnuityExecutionUnit {
    private static final long serialVersionUID = 5751982103363852382L;
    private static final String START_ID = "startId";
    private static final String END_ID = "endId";

    public void execute() {
        try {
            int startId = this.getParameterValueInt(START_ID);
            int endId = this.getParameterValueInt(END_ID);
            int id = (int)Math.round(Math.random() * (double)(endId - startId) + (double)startId);
            IAnnuity annuity = this.getAnnuityBeansFactory().createAnnuity();
            annuity.setId("" + id);
            annuity.setConfiguration(this.getConfiguration());
            IAnnuity results = this.getServerAdapter().findAnnuityById(annuity);
            this.verifySuccess(results, "" + id);
        }
        catch (Exception e) {
            this.getExecutionUnitEvent().addException(e);
        }
    }

    private void verifySuccess(IAnnuity annuity, String id) throws ExecutionUnitVerificationException {
        if (annuity == null) {
            throw new ExecutionUnitVerificationException("The FindAnnuityByIdEU failed to find an annuity.  retrned null value.");
        }
        if (!((String)annuity.getId()).equals(id)) {
            throw new ExecutionUnitVerificationException("The FindAnnuityByIdEU returned a different object with with different id!expected id: " + id + " but was: " + (String)annuity.getId());
        }
    }
}

