/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.executionunit;

import com.ibm.wssvt.acme.annuity.common.bean.IAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.bean.IEquityAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IFixedAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IPayor;
import com.ibm.wssvt.acme.annuity.common.bean.IPayout;
import com.ibm.wssvt.acme.annuity.common.bean.IRider;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.AbastractAnnuityExecutionUnit;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.BasicExecutionUnitLibrarry;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.ExecutionUnitVerificationHelper;
import com.ibm.wssvt.acme.annuity.common.exception.EntityAlreadyExistsException;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.annuity.common.util.AnnuityType;
import com.ibm.wssvt.acme.annuity.common.util.ServerExceptionMapper;
import com.ibm.wssvt.acme.annuity.common.util.ServerExceptionType;
import com.ibm.wssvt.acme.common.adapter.ServerAdapterCommunicationException;
import com.ibm.wssvt.acme.common.executionunit.ExecutionUnitVerificationException;
import com.ibm.wssvt.acme.common.executionunit.IExecutionUnit;
import com.ibm.wssvt.acme.common.executionunit.InvalidExecutionUnitParameterException;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;

public class UpdateExistingAnnuityPayorPayoutRiderEU
extends AbastractAnnuityExecutionUnit {
    private static final long serialVersionUID = -8978758038714550844L;
    private static final String START_HOLDER_ID = "startHolderId";
    private static final String END_HOLDER_ID = "endHolderId";
    private static final String MAX_THRESHOLD = "maximumThreshold";
    private static final String ENABLE_VERIFY_KEY = "enableVerify";
    private int startHolderId;
    private int endHolderId;
    private int holderRange;
    private int maximumThreshold;
    private boolean enableVerify = true;
    private AcmeLogger logger;

    public void execute() {
        int threshold = 0;
        try {
            this.setScenarioVariables();
        }
        catch (Exception e) {
            this.logger.warning("Invalid scenario parameters for scenario description:" + this.getDescription() + "  Error is: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        String randomHolderId = "" + (this.startHolderId + this.getRandomInteger(0, this.holderRange));
        this.logger.fine("Got the random holder ID --- " + randomHolderId);
        this.logger.fine("Find the holder from existing database");
        IAnnuityHolder holder = null;
        try {
            holder = this.findAnnuityHolderById(randomHolderId);
            if (holder == null) {
                throw new ExecutionUnitVerificationException("Expected to find an Annuity Holder for id: " + randomHolderId + " but found null");
            }
            if (!((String)holder.getId()).equals(randomHolderId)) {
                throw new ExecutionUnitVerificationException("Found an Annuity Holder for id: " + randomHolderId + " but the object id is different! - found id: " + (String)holder.getId());
            }
        }
        catch (Exception e) {
            this.logger.warning("Failed to find holder. ID - " + randomHolderId + " Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.fine("Getting list of Annuity from AnnuityHolder");
        List<IAnnuity> annuities = null;
        try {
            annuities = this.getAnnuities(holder);
            if (this.logger.getLogger().isLoggable(Level.FINE)) {
                String annIds = "";
                for (IAnnuity ann : annuities) {
                    annIds = annIds + (String)ann.getId() + " : ";
                }
                this.logger.fine("Got the the annuity IDs here --- " + annIds);
            }
        }
        catch (Exception e) {
            this.logger.warning("Failed to get list of annuities. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.fine("Annuity size is " + annuities.size());
        for (IAnnuity annuity : annuities) {
            ServerExceptionType exType;
            AnnuityType annuityType = this.getAnnuityType(annuity);
            this.logger.fine("Updating Annuity with Rider");
            while (threshold <= this.maximumThreshold) {
                try {
                    annuity = this.addRidersToAnnuity(annuity);
                    break;
                }
                catch (Exception e) {
                    exType = ServerExceptionMapper.getExceptionType(e);
                    if (ServerExceptionType.OPTIMISTIC_LOCKING_EXCEPTION.equals((Object)exType)) {
                        this.logger.info("OPTIMISTIC LOCKING EXCEPTION encountered while updating annuity id: " + (String)annuity.getId() + ".  Trying again to a max of: " + this.maximumThreshold + " times. This is the: " + (threshold + 1) + " attempt.");
                        ++threshold;
                        annuity.setConfiguration(this.getConfiguration());
                        try {
                            annuity = this.getServerAdapter().findAnnuityById(annuity);
                            continue;
                        }
                        catch (Exception ex) {
                            this.getExecutionUnitEvent().addException(e);
                            return;
                        }
                    }
                    this.logger.warning("Failed to update annuity with rider. Error: " + e);
                    this.getExecutionUnitEvent().addException(e);
                    return;
                }
            }
            threshold = 0;
            if (this.enableVerify) {
                this.logger.fine("Verifying Annuity with Rider");
                try {
                    this.verifyAnnuityValues(annuity, annuityType);
                }
                catch (Exception e) {
                    this.logger.warning("Failed to verify update annuity with rider. Error: " + e);
                    this.getExecutionUnitEvent().addException(e);
                }
            }
            while (threshold <= this.maximumThreshold) {
                try {
                    annuity = this.removeRiderFromAnnuity(annuity);
                    break;
                }
                catch (Exception e) {
                    exType = ServerExceptionMapper.getExceptionType(e);
                    if (ServerExceptionType.OPTIMISTIC_LOCKING_EXCEPTION.equals((Object)exType)) {
                        this.logger.info("OPTIMISTIC LOCKING EXCEPTION encountered while updating annuity id: " + (String)annuity.getId() + ".  Trying again to a max of: " + this.maximumThreshold + " times. This is the: " + (threshold + 1) + " attempt.");
                        ++threshold;
                        annuity.setConfiguration(this.getConfiguration());
                        try {
                            annuity = this.getServerAdapter().findAnnuityById(annuity);
                            continue;
                        }
                        catch (Exception ex) {
                            this.getExecutionUnitEvent().addException(e);
                            return;
                        }
                    }
                    this.logger.warning("Failed to update annuity with rider. Error: " + e);
                    this.getExecutionUnitEvent().addException(e);
                    return;
                }
            }
            threshold = 0;
            if (this.enableVerify) {
                this.logger.fine("Verifying Annuity with Rider");
                try {
                    this.verifyAnnuityValues(annuity, annuityType);
                }
                catch (Exception e) {
                    this.logger.warning("Failed to verify update annuity. Error: " + e);
                    this.getExecutionUnitEvent().addException(e);
                }
            }
            while (threshold <= this.maximumThreshold) {
                try {
                    annuity = this.updateAnnuityRiderRule(annuity);
                    break;
                }
                catch (Exception e) {
                    exType = ServerExceptionMapper.getExceptionType(e);
                    if (ServerExceptionType.OPTIMISTIC_LOCKING_EXCEPTION.equals((Object)exType)) {
                        this.logger.info("OPTIMISTIC LOCKING EXCEPTION encountered while updating annuity id: " + (String)annuity.getId() + ".  Trying again to a max of: " + this.maximumThreshold + " times. This is the: " + (threshold + 1) + " attempt.");
                        ++threshold;
                        annuity.setConfiguration(this.getConfiguration());
                        try {
                            annuity = this.getServerAdapter().findAnnuityById(annuity);
                            continue;
                        }
                        catch (Exception ex) {
                            this.getExecutionUnitEvent().addException(e);
                            return;
                        }
                    }
                    this.logger.warning("Failed to update annuity. Error: " + e);
                    this.getExecutionUnitEvent().addException(e);
                    return;
                }
            }
            threshold = 0;
            if (this.enableVerify) {
                this.logger.fine("Verifying Annuity with Rider");
                try {
                    this.verifyAnnuityValues(annuity, annuityType);
                }
                catch (Exception e) {
                    this.logger.warning("Failed to verify update annuity. Error: " + e);
                    this.getExecutionUnitEvent().addException(e);
                }
            }
            while (threshold <= this.maximumThreshold) {
                try {
                    annuity = this.addPayoutsToAnnuity(annuity);
                    break;
                }
                catch (Exception e) {
                    exType = ServerExceptionMapper.getExceptionType(e);
                    if (ServerExceptionType.OPTIMISTIC_LOCKING_EXCEPTION.equals((Object)exType)) {
                        this.logger.info("OPTIMISTIC LOCKING EXCEPTION encountered while updating annuity id: " + (String)annuity.getId() + ".  Trying again to a max of: " + this.maximumThreshold + " times. This is the: " + (threshold + 1) + " attempt.");
                        ++threshold;
                        annuity.setConfiguration(this.getConfiguration());
                        try {
                            annuity = this.getServerAdapter().findAnnuityById(annuity);
                            continue;
                        }
                        catch (Exception ex) {
                            this.getExecutionUnitEvent().addException(e);
                            return;
                        }
                    }
                    this.logger.warning("Failed to update annuity. Error: " + e);
                    this.getExecutionUnitEvent().addException(e);
                    return;
                }
            }
            threshold = 0;
            if (this.enableVerify) {
                this.logger.fine("Verifying Annuity with Rider");
                try {
                    this.verifyAnnuityValues(annuity, annuityType);
                }
                catch (Exception e) {
                    this.logger.warning("Failed to verify update annuity. Error: " + e);
                    this.getExecutionUnitEvent().addException(e);
                }
            }
            while (threshold <= this.maximumThreshold) {
                try {
                    annuity = this.removeAnnuityPayout(annuity);
                    break;
                }
                catch (Exception e) {
                    exType = ServerExceptionMapper.getExceptionType(e);
                    if (ServerExceptionType.OPTIMISTIC_LOCKING_EXCEPTION.equals((Object)exType)) {
                        this.logger.info("OPTIMISTIC LOCKING EXCEPTION encountered while updating annuity id: " + (String)annuity.getId() + ".  Trying again to a max of: " + this.maximumThreshold + " times. This is the: " + (threshold + 1) + " attempt.");
                        ++threshold;
                        annuity.setConfiguration(this.getConfiguration());
                        try {
                            annuity = this.getServerAdapter().findAnnuityById(annuity);
                            continue;
                        }
                        catch (Exception ex) {
                            this.getExecutionUnitEvent().addException(e);
                            return;
                        }
                    }
                    this.logger.warning("Failed to update annuity. Error: " + e);
                    this.getExecutionUnitEvent().addException(e);
                    return;
                }
            }
            threshold = 0;
            if (this.enableVerify) {
                this.logger.fine("Verifying Annuity with Rider");
                try {
                    this.verifyAnnuityValues(annuity, annuityType);
                }
                catch (Exception e) {
                    this.logger.warning("Failed to verify update annuity. Error: " + e);
                    this.getExecutionUnitEvent().addException(e);
                }
            }
            while (threshold <= this.maximumThreshold) {
                try {
                    annuity = this.updateAnnuityPayout(annuity);
                    break;
                }
                catch (Exception e) {
                    exType = ServerExceptionMapper.getExceptionType(e);
                    if (ServerExceptionType.OPTIMISTIC_LOCKING_EXCEPTION.equals((Object)exType)) {
                        this.logger.info("OPTIMISTIC LOCKING EXCEPTION encountered while updating annuity id: " + (String)annuity.getId() + ".  Trying again to a max of: " + this.maximumThreshold + " times. This is the: " + (threshold + 1) + " attempt.");
                        ++threshold;
                        annuity.setConfiguration(this.getConfiguration());
                        try {
                            annuity = this.getServerAdapter().findAnnuityById(annuity);
                            continue;
                        }
                        catch (Exception ex) {
                            this.getExecutionUnitEvent().addException(e);
                            return;
                        }
                    }
                    this.logger.warning("Failed to update annuity. Error: " + e);
                    this.getExecutionUnitEvent().addException(e);
                    return;
                }
            }
            threshold = 0;
            if (this.enableVerify) {
                this.logger.fine("Verifying Annuity with Rider");
                try {
                    this.verifyAnnuityValues(annuity, annuityType);
                }
                catch (Exception e) {
                    this.logger.warning("Failed to verify update annuity. Error: " + e);
                    this.getExecutionUnitEvent().addException(e);
                }
            }
            while (threshold <= this.maximumThreshold) {
                try {
                    annuity = this.addPayorToAnnuity(annuity);
                    break;
                }
                catch (Exception e) {
                    exType = ServerExceptionMapper.getExceptionType(e);
                    if (ServerExceptionType.OPTIMISTIC_LOCKING_EXCEPTION.equals((Object)exType)) {
                        this.logger.info("OPTIMISTIC LOCKING EXCEPTION encountered while updating annuity id: " + (String)annuity.getId() + ".  Trying again to a max of: " + this.maximumThreshold + " times. This is the: " + (threshold + 1) + " attempt.");
                        ++threshold;
                        annuity.setConfiguration(this.getConfiguration());
                        try {
                            annuity = this.getServerAdapter().findAnnuityById(annuity);
                            continue;
                        }
                        catch (Exception ex) {
                            this.getExecutionUnitEvent().addException(e);
                            return;
                        }
                    }
                    this.logger.warning("Failed to update annuity. Error: " + e);
                    this.getExecutionUnitEvent().addException(e);
                    return;
                }
            }
            threshold = 0;
            if (this.enableVerify) {
                this.logger.fine("Verifying Annuity with Rider");
                try {
                    this.verifyAnnuityValues(annuity, annuityType);
                }
                catch (Exception e) {
                    this.logger.warning("Failed to verify update annuity. Error: " + e);
                    this.getExecutionUnitEvent().addException(e);
                }
            }
            while (threshold <= this.maximumThreshold) {
                try {
                    annuity = this.removePayorFromAnnuity(annuity);
                    break;
                }
                catch (Exception e) {
                    exType = ServerExceptionMapper.getExceptionType(e);
                    if (ServerExceptionType.OPTIMISTIC_LOCKING_EXCEPTION.equals((Object)exType)) {
                        this.logger.info("OPTIMISTIC LOCKING EXCEPTION encountered while updating annuity id: " + (String)annuity.getId() + ".  Trying again to a max of: " + this.maximumThreshold + " times. This is the: " + (threshold + 1) + " attempt.");
                        ++threshold;
                        annuity.setConfiguration(this.getConfiguration());
                        try {
                            annuity = this.getServerAdapter().findAnnuityById(annuity);
                            continue;
                        }
                        catch (Exception ex) {
                            this.getExecutionUnitEvent().addException(e);
                            return;
                        }
                    }
                    this.logger.warning("Failed to update annuity. Error: " + e);
                    this.getExecutionUnitEvent().addException(e);
                    return;
                }
            }
            threshold = 0;
            if (this.enableVerify) {
                this.logger.fine("Verifying Annuity with Rider");
                try {
                    this.verifyAnnuityValues(annuity, annuityType);
                }
                catch (Exception e) {
                    this.logger.warning("Failed to verify update annuity. Error: " + e);
                    this.getExecutionUnitEvent().addException(e);
                }
            }
            while (threshold <= this.maximumThreshold) {
                try {
                    annuity = this.updateAnnuityPayor(annuity);
                    break;
                }
                catch (Exception e) {
                    exType = ServerExceptionMapper.getExceptionType(e);
                    if (ServerExceptionType.OPTIMISTIC_LOCKING_EXCEPTION.equals((Object)exType)) {
                        this.logger.info("OPTIMISTIC LOCKING EXCEPTION encountered while updating annuity id: " + (String)annuity.getId() + ".  Trying again to a max of: " + this.maximumThreshold + " times. This is the: " + (threshold + 1) + " attempt.");
                        ++threshold;
                        annuity.setConfiguration(this.getConfiguration());
                        try {
                            annuity = this.getServerAdapter().findAnnuityById(annuity);
                            continue;
                        }
                        catch (Exception ex) {
                            this.getExecutionUnitEvent().addException(e);
                            return;
                        }
                    }
                    this.logger.warning("Failed to update annuity. Error: " + e);
                    this.getExecutionUnitEvent().addException(e);
                    return;
                }
            }
            threshold = 0;
            if (this.enableVerify) {
                this.logger.fine("Verifying Annuity with Rider");
                try {
                    this.verifyAnnuityValues(annuity, annuityType);
                }
                catch (Exception e) {
                    this.logger.warning("Failed to verify update annuity. Error: " + e);
                    this.getExecutionUnitEvent().addException(e);
                }
            }
            this.logger.fine("Updating Annuity by itself");
            for (threshold = 0; threshold <= this.maximumThreshold; ++threshold) {
                try {
                    annuity = this.updateAnnuityAlone(annuity);
                    break;
                }
                catch (Exception e) {
                    exType = ServerExceptionMapper.getExceptionType(e);
                    if (ServerExceptionType.OPTIMISTIC_LOCKING_EXCEPTION.equals((Object)exType)) {
                        this.logger.info("OPTIMISTIC LOCKING EXCEPTION encountered while updating annuity id: " + (String)annuity.getId() + ".  Trying again to a max of: " + this.maximumThreshold + " times. This is the: " + (threshold + 1) + " attempt.");
                        annuity.setConfiguration(this.getConfiguration());
                        try {
                            annuity = this.getServerAdapter().findAnnuityById(annuity);
                            continue;
                        }
                        catch (Exception ex) {
                            this.getExecutionUnitEvent().addException(e);
                            return;
                        }
                    }
                    this.logger.warning("Failed to update annuity by itself. Error: " + e);
                    this.getExecutionUnitEvent().addException(e);
                    return;
                }
            }
            threshold = 0;
            if (!this.enableVerify) continue;
            this.logger.fine("Verifying Annuity with Rider");
            try {
                this.verifyAnnuityValues(annuity, annuityType);
            }
            catch (Exception e) {
                this.logger.warning("Failed to verify update annuity. Error: " + e);
                this.getExecutionUnitEvent().addException(e);
            }
        }
    }

    private IAnnuityHolder findAnnuityHolderById(String randomHolderId) throws ServerAdapterCommunicationException, EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException, RemoteException {
        IAnnuityHolder holder = this.getAnnuityBeansFactory().createAnnuityHolder();
        holder.setId(randomHolderId);
        holder.setConfiguration(this.getConfiguration());
        holder = this.getServerAdapter().findHolderById(holder);
        return holder;
    }

    private void setScenarioVariables() throws InvalidExecutionUnitParameterException {
        this.logger = this.getLogger(((Object)((Object)this)).getClass().getName());
        this.startHolderId = this.getParameterValueInt(START_HOLDER_ID);
        this.endHolderId = this.getParameterValueInt(END_HOLDER_ID);
        if (this.startHolderId <= 0) {
            throw new InvalidExecutionUnitParameterException("startHolderId is less or equal to 0.  Invalid value for scenario with description: " + this.getDescription() + ".  Value must be one or more.");
        }
        if (this.endHolderId <= 0) {
            throw new InvalidExecutionUnitParameterException("endHolderId is less or equal to 0.  Invalid value for scenario with description: " + this.getDescription() + ".  Value must be one or more.");
        }
        this.holderRange = this.endHolderId - this.startHolderId;
        try {
            this.maximumThreshold = this.getParameterValueInt(MAX_THRESHOLD);
        }
        catch (Exception e) {
            this.logger.fine("maximumThreshold parameter not specified, using default");
            this.maximumThreshold = 2;
        }
        try {
            this.enableVerify = this.getParameterValueBoolean(ENABLE_VERIFY_KEY);
        }
        catch (Exception e) {
            this.logger.warning("enableVerify parameter is not set, using default true.");
            this.enableVerify = true;
        }
    }

    private List<IAnnuity> getAnnuities(IAnnuityHolder holder) throws ServerAdapterCommunicationException, InvalidArgumentException, ServerInternalErrorException, RemoteException {
        holder.setConfiguration(this.getConfiguration());
        List<IAnnuity> annuities = this.getServerAdapter().findHolderAnnuities(holder);
        return annuities;
    }

    private IAnnuity addRidersToAnnuity(IAnnuity annuity) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        IRider rider1 = BasicExecutionUnitLibrarry.getRider(this.getAnnuityBeansFactory());
        IRider rider2 = BasicExecutionUnitLibrarry.getRider(this.getAnnuityBeansFactory());
        annuity.getRiders().add(rider1);
        annuity.getRiders().add(rider2);
        annuity.setConfiguration(this.getConfiguration());
        annuity = this.getServerAdapter().updateAnnuity(annuity);
        return annuity;
    }

    private IAnnuity removeRiderFromAnnuity(IAnnuity annuity) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        annuity.setConfiguration(this.getConfiguration());
        annuity = this.getServerAdapter().findAnnuityById(annuity);
        if (annuity.getRiders() == null || annuity.getRiders().size() < 1) {
            throw new ExecutionUnitVerificationException("Attempting to remove a rider from annuity, but riders is either null or has 0 elements");
        }
        IRider removed = annuity.getRiders().get(0);
        annuity.getRiders().remove(0);
        annuity.setConfiguration(this.getConfiguration());
        annuity = this.getServerAdapter().updateAnnuity(annuity);
        removed.setConfiguration(this.getConfiguration());
        this.getServerAdapter().deleteRider(removed);
        return annuity;
    }

    private IAnnuity updateAnnuityRiderRule(IAnnuity annuity) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        annuity.setConfiguration(this.getConfiguration());
        annuity = this.getServerAdapter().findAnnuityById(annuity);
        IRider rider = annuity.getRiders().get(0);
        rider.setRule(this.getUpdatedString(rider.getRule()));
        annuity.setConfiguration(this.getConfiguration());
        annuity = this.getServerAdapter().updateAnnuity(annuity);
        return annuity;
    }

    private IAnnuity addPayoutsToAnnuity(IAnnuity annuity) throws EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, EntityNotFoundException, RemoteException {
        annuity.setConfiguration(this.getConfiguration());
        annuity = this.getServerAdapter().findAnnuityById(annuity);
        IPayout payout1 = BasicExecutionUnitLibrarry.getPayout(this.getAnnuityBeansFactory());
        payout1.setAnnuity(annuity);
        payout1.setTaxableAmount(new BigDecimal(this.getRandomInteger(100, 1000)));
        payout1.setConfiguration(this.getConfiguration());
        payout1 = this.getServerAdapter().createPayout(payout1);
        IPayout payout2 = BasicExecutionUnitLibrarry.getPayout(this.getAnnuityBeansFactory());
        payout2.setAnnuity(annuity);
        payout2.setTaxableAmount(new BigDecimal(this.getRandomInteger(100, 1000)));
        payout2.setConfiguration(this.getConfiguration());
        payout2 = this.getServerAdapter().createPayout(payout2);
        annuity.getPayouts().add(payout1);
        annuity.getPayouts().add(payout2);
        annuity.setConfiguration(this.getConfiguration());
        annuity = this.getServerAdapter().updateAnnuity(annuity);
        return annuity;
    }

    private IAnnuity removeAnnuityPayout(IAnnuity annuity) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        annuity.setConfiguration(this.getConfiguration());
        annuity = this.getServerAdapter().findAnnuityById(annuity);
        if (annuity.getPayouts() == null || annuity.getPayouts().size() < 1) {
            throw new ExecutionUnitVerificationException("Attempting to remove a payout from annuity, but payouts is either null or has 0 elements");
        }
        IPayout payout = annuity.getPayouts().get(0);
        annuity.getPayouts().remove(0);
        annuity.setConfiguration(this.getConfiguration());
        annuity = this.getServerAdapter().updateAnnuity(annuity);
        payout.setConfiguration(this.getConfiguration());
        this.getServerAdapter().deletePayout(payout);
        return annuity;
    }

    private IAnnuity updateAnnuityPayout(IAnnuity annuity) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, EntityAlreadyExistsException, RemoteException {
        annuity.setConfiguration(this.getConfiguration());
        annuity = this.getServerAdapter().findAnnuityById(annuity);
        if (annuity.getPayouts() == null || annuity.getPayouts().size() < 1) {
            throw new ExecutionUnitVerificationException("Attempting to update a payout from annuity, but payouts is either null or has 0 elements");
        }
        Calendar newEndDate = Calendar.getInstance();
        newEndDate.add(2, 11);
        IPayout payout = annuity.getPayouts().get(0);
        payout.setEndDate(newEndDate);
        payout.setTaxableAmount(new BigDecimal(this.getRandomInteger(10000, 100000)));
        payout.setAnnuity(annuity);
        payout.setConfiguration(this.getConfiguration());
        payout = this.getServerAdapter().updatePayout(payout);
        annuity.setConfiguration(this.getConfiguration());
        annuity = this.getServerAdapter().updateAnnuity(annuity);
        return annuity;
    }

    private IAnnuity addPayorToAnnuity(IAnnuity annuity) throws EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, EntityNotFoundException, RemoteException {
        IPayor payor1 = BasicExecutionUnitLibrarry.getPayor(this.getAnnuityBeansFactory());
        payor1.setConfiguration(this.getConfiguration());
        payor1 = this.getServerAdapter().createPayor(payor1);
        IPayor payor2 = BasicExecutionUnitLibrarry.getPayor(this.getAnnuityBeansFactory());
        payor2.setConfiguration(this.getConfiguration());
        payor2 = this.getServerAdapter().createPayor(payor2);
        annuity.getPayors().add(payor2);
        annuity.setConfiguration(this.getConfiguration());
        annuity = this.getServerAdapter().updateAnnuity(annuity);
        return annuity;
    }

    private IAnnuity removePayorFromAnnuity(IAnnuity annuity) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        annuity.setConfiguration(this.getConfiguration());
        annuity = this.getServerAdapter().findAnnuityById(annuity);
        if (annuity.getPayors() == null || annuity.getPayors().size() < 1) {
            throw new ExecutionUnitVerificationException("Attempting to remove a payor from annuity, but payors is either null or has 0 elements");
        }
        IPayor payor = annuity.getPayors().get(0);
        annuity.getPayors().remove(0);
        annuity.setConfiguration(this.getConfiguration());
        annuity = this.getServerAdapter().updateAnnuity(annuity);
        payor.setConfiguration(this.getConfiguration());
        this.getServerAdapter().deletePayor(payor);
        annuity.setConfiguration(this.getConfiguration());
        annuity = this.getServerAdapter().updateAnnuity(annuity);
        return annuity;
    }

    private IAnnuity updateAnnuityPayor(IAnnuity annuity) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        annuity.setConfiguration(this.getConfiguration());
        annuity = this.getServerAdapter().findAnnuityById(annuity);
        if (annuity.getPayors() == null || annuity.getPayors().size() < 1) {
            throw new ExecutionUnitVerificationException("Attempting to update a payor from annuity, but payors is either null or has 0 elements");
        }
        IPayor payor = annuity.getPayors().get(0);
        payor.setName(this.getUpdatedString(payor.getName()));
        payor.setConfiguration(this.getConfiguration());
        payor = this.getServerAdapter().updatePayor(payor);
        annuity.setConfiguration(this.getConfiguration());
        annuity = this.getServerAdapter().updateAnnuity(annuity);
        return annuity;
    }

    private IAnnuity updateAnnuityAlone(IAnnuity annuity) throws EntityNotFoundException, EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        if (annuity instanceof IEquityAnnuity) {
            return this.updateEquityAnnuity((IEquityAnnuity)annuity);
        }
        if (annuity instanceof IFixedAnnuity) {
            return this.updateFixedAnnuity((IFixedAnnuity)annuity);
        }
        return this.updateBasicAnnuity(annuity);
    }

    private IAnnuity updateBasicAnnuity(IAnnuity annuity) throws EntityNotFoundException, EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        annuity.setAmount(new Double(111111.0));
        annuity.setLastPaidAmt(new Double(1111.0));
        annuity.setConfiguration(this.getConfiguration());
        annuity = this.getServerAdapter().updateAnnuity(annuity);
        return annuity;
    }

    private IEquityAnnuity updateEquityAnnuity(IEquityAnnuity annuity) throws EntityNotFoundException, EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        annuity.setAmount(new Double(111111.0));
        annuity.setLastPaidAmt(new Double(1111.0));
        annuity.setFundNames(this.getUpdatedString(annuity.getFundNames()));
        annuity.setIndexRate(new Double(0.88));
        annuity.setConfiguration(this.getConfiguration());
        annuity = (IEquityAnnuity)this.getServerAdapter().updateAnnuity(annuity);
        return annuity;
    }

    private IFixedAnnuity updateFixedAnnuity(IFixedAnnuity annuity) throws EntityNotFoundException, EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        annuity.setAmount(new Double(111111.0));
        annuity.setLastPaidAmt(new Double(1111.0));
        annuity.setRate(new Double(0.88));
        annuity.setConfiguration(this.getConfiguration());
        annuity = (IFixedAnnuity)this.getServerAdapter().updateAnnuity(annuity);
        return annuity;
    }

    private void verifyAnnuityValues(IAnnuity annuity, AnnuityType annuityType) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        int i;
        IAnnuity results = null;
        if (AnnuityType.BASIC.equals((Object)annuityType)) {
            results = this.getAnnuityBeansFactory().createAnnuity();
        }
        if (AnnuityType.EQUITY.equals((Object)annuityType)) {
            results = this.getAnnuityBeansFactory().createAnnEquity();
        }
        if (AnnuityType.FIXED.equals((Object)annuityType)) {
            results = this.getAnnuityBeansFactory().createAnnFixed();
        }
        results.setId(annuity.getId());
        results.setConfiguration(this.getConfiguration());
        results = this.getServerAdapter().findAnnuityById(results);
        if (annuity instanceof IFixedAnnuity) {
            ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, (IFixedAnnuity)annuity, (IFixedAnnuity)results, "Fixed Annuity from Client is not equal to DB value", "Mismacth was found.");
        } else if (annuity instanceof IEquityAnnuity) {
            ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, (IEquityAnnuity)annuity, (IEquityAnnuity)results, "Equity Annuity from Client is not equal to DB value", "Mismacth was found.");
        } else {
            ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, annuity, results, "Basic Annuity from Client is not equal to DB value", "Mismacth was found.");
        }
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, annuity.getPayouts(), results.getPayouts(), "Annuity payouts from Client is not equal to DB value", "Mismacth was found in number of payouts");
        boolean found = false;
        if (annuity.getPayouts() != null) {
            IPayout clientPayout = null;
            for (i = 0; i < annuity.getPayouts().size(); ++i) {
                found = false;
                clientPayout = annuity.getPayouts().get(i);
                for (IPayout resultPayout : results.getPayouts()) {
                    if (!((String)clientPayout.getId()).equals(resultPayout.getId())) continue;
                    found = true;
                    ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, clientPayout, resultPayout, "Annuity Payout from Client is not equal to DB value at location: " + i, "Mismacth was found");
                }
                if (found || clientPayout == null) continue;
                throw new ExecutionUnitVerificationException("Annuity Payout from client is not equal to DB.  Found Payout with id: " + (String)clientPayout.getId() + " on the client side, but not in the database for annuity id:" + (String)annuity.getId());
            }
        }
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, annuity.getRiders(), results.getRiders(), "Annuity rider from Client is not equal to DB value", "Mismacth was found in number of rider");
        if (annuity.getRiders() != null) {
            IRider clientRider = null;
            for (i = 0; i < annuity.getRiders().size(); ++i) {
                found = false;
                clientRider = annuity.getRiders().get(i);
                for (IRider resultRider : results.getRiders()) {
                    if (!((String)clientRider.getId()).equals(resultRider.getId())) continue;
                    found = true;
                    ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, clientRider, resultRider, "Annuity rider from Client is not equal to DB value at location: " + i, "Mismacth was found");
                }
                if (found || clientRider == null) continue;
                throw new ExecutionUnitVerificationException("Annuity rider from client is not equal to DB.  Found rider with id: " + (String)clientRider.getId() + " on the client side, but not in the database for annuity id:" + (String)annuity.getId());
            }
        }
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, annuity.getPayors(), results.getPayors(), "Annuity Payor from Client is not equal to DB value", "Mismacth was found.");
        if (annuity.getPayors() != null) {
            IPayor clientPayor = null;
            for (i = 0; i < annuity.getPayors().size(); ++i) {
                found = false;
                clientPayor = annuity.getPayors().get(i);
                for (IPayor resultPayor : results.getPayors()) {
                    if (!((String)clientPayor.getId()).equals(resultPayor.getId())) continue;
                    found = true;
                    ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, annuity.getPayors().get(i), resultPayor, "Annuity payor from Client is not equal to DB value at location: " + i, "Mismacth was found");
                }
                if (found || clientPayor == null) continue;
                throw new ExecutionUnitVerificationException("Annuity payor from client is not equal to DB.  Found payor with id: " + (String)clientPayor.getId() + " on the client side, but not in the database for annuity id:" + (String)annuity.getId());
            }
        }
    }

    private String getUpdatedString(String st) {
        String newName = "";
        String first = "";
        String last = "";
        if (st.indexOf("**") < 0) {
            newName = st + "**0";
        } else {
            StringTokenizer parser = new StringTokenizer(st, "**");
            first = parser.nextToken();
            last = parser.nextToken();
            newName = first + "**" + (Integer.valueOf(last) + 1);
        }
        return newName;
    }

    private AnnuityType getAnnuityType(IAnnuity annuity) {
        if (annuity instanceof IEquityAnnuity) {
            return AnnuityType.EQUITY;
        }
        if (annuity instanceof IFixedAnnuity) {
            return AnnuityType.FIXED;
        }
        return AnnuityType.BASIC;
    }
}

