/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.executionunit.policy;

import com.ibm.wssvt.acme.annuity.common.bean.IBeneficiary;
import com.ibm.wssvt.acme.annuity.common.bean.jpa.JPABeansFactory;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.BasicExecutionUnitLibrarry;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.ExecutionUnitVerificationHelper;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.policy.AbastractPolicyExecutionUnit;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.common.adapter.ServerAdapterCommunicationException;
import com.ibm.wssvt.acme.common.executionunit.ExecutionUnitVerificationException;
import com.ibm.wssvt.acme.common.executionunit.IExecutionUnit;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.rmi.RemoteException;

public class CreateBeneficiaryEU
extends AbastractPolicyExecutionUnit {
    private static final long serialVersionUID = -8814364386358328406L;
    private AcmeLogger logger;

    public void execute() {
        try {
            this.setScenarioVariables();
            IBeneficiary beneficiary = BasicExecutionUnitLibrarry.getBeneficiary(this.getAnnuityBeansFactory());
            beneficiary.setConfiguration(this.getConfiguration());
            this.logger.info("creating beneficiary");
            this.logger.info("Beneficiary details : id, name = " + (String)beneficiary.getId() + "," + beneficiary.getFirstName() + " " + beneficiary.getLastName());
            IBeneficiary result = this.getServerAdapter().createBeneficiary(beneficiary);
            this.logger.info("Beneficiary's name is: " + result.getFirstName() + " " + result.getLastName());
            this.verifyBeneficiaryValues(beneficiary);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getExecutionUnitEvent().addException(e);
        }
    }

    private void setScenarioVariables() {
        this.logger = this.getLogger(((Object)((Object)this)).getClass().getName());
    }

    private void verifyBeneficiaryValues(IBeneficiary original) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        IBeneficiary results = ((JPABeansFactory)this.getAnnuityBeansFactory()).createBeneficiary();
        results.setId(original.getId());
        results.setConfiguration(this.getConfiguration());
        results = this.getServerAdapter().findBeneficiaryById(results);
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, original, results, "Beneficiary from client is not equal to DB value", "Mismatch was found.");
    }
}

