/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.executionunit.stackunit;

import com.ibm.wssvt.acme.annuity.common.bean.IContact;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.AbstractAnnuityStackableExecutionUnit;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.BasicExecutionUnitLibrarry;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.common.executionunit.ExecutionUnitVerificationException;
import com.ibm.wssvt.acme.common.executionunit.InvalidExecutionUnitParameterException;
import com.ibm.wssvt.acme.common.log.AcmeLogger;

public class DeleteContactEU
extends AbstractAnnuityStackableExecutionUnit {
    private static final long serialVersionUID = 5751982103363852382L;
    boolean enableVerify = true;
    AcmeLogger logger;

    public void execute() {
        this.logger = this.getLogger(((Object)((Object)this)).getClass().getName());
        try {
            this.setEUParams();
            IContact contact = BasicExecutionUnitLibrarry.getContact(this.getAnnuityBeansFactory());
            contact.setConfiguration(this.getConfiguration());
            String contactId = (String)this.getStackMap().get("contactId");
            if (contactId == null || contactId.trim().length() == 0) {
                throw new InvalidExecutionUnitParameterException("This EU expects to find the attribute contactId in the stack but found null or empty.  found: " + contactId + ".  Make sure that you use this EU in a correct order.");
            }
            contact.setId(contactId);
            this.logger.fine("ready to delete contact: " + contact);
            this.getServerAdapter().deleteContact(contact);
            this.logger.fine("deleted Contact ");
            if (this.enableVerify) {
                contact.setConfiguration(this.getConfiguration());
                try {
                    this.getServerAdapter().findContactById(contact);
                    throw new ExecutionUnitVerificationException("Deleted the contact and expected an EntityNotFoundException on a subsequent read, but did not get the exception");
                }
                catch (EntityNotFoundException entityNotFoundException) {
                    // empty catch block
                }
            }
            this.getStackMap().remove("contactId");
        }
        catch (Exception e) {
            this.getExecutionUnitEvent().addException(e);
        }
    }

    private void setEUParams() {
        try {
            this.enableVerify = this.getParameterValueBoolean("enableVerify");
        }
        catch (InvalidExecutionUnitParameterException e) {
            this.enableVerify = true;
        }
    }
}

