/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.jaxws.beanconverter.jaxws2pojojaxrpc;

import com.ibm.wssvt.acme.annuity.common.bean.AnnuityHolderCategory;
import com.ibm.wssvt.acme.annuity.common.bean.ContactType;
import com.ibm.wssvt.acme.annuity.common.bean.IAddress;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityBeansFactory;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityObject;
import com.ibm.wssvt.acme.annuity.common.bean.IContact;
import com.ibm.wssvt.acme.annuity.common.bean.IEquityAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IPayor;
import com.ibm.wssvt.acme.annuity.common.bean.IPayout;
import com.ibm.wssvt.acme.annuity.common.bean.IRider;
import com.ibm.wssvt.acme.annuity.common.bean.RiderType;
import com.ibm.wssvt.acme.annuity.common.bean.java.JavaBeansFactory;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2pojojaxrpcimpl.Address;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2pojojaxrpcimpl.Annuity;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2pojojaxrpcimpl.AnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2pojojaxrpcimpl.AnnuityPersistebleObject;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2pojojaxrpcimpl.ArrayOfEntry;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2pojojaxrpcimpl.Contact;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2pojojaxrpcimpl.Entry;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2pojojaxrpcimpl.EquityAnnuity;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2pojojaxrpcimpl.FixedAnnuity;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2pojojaxrpcimpl.Payor;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2pojojaxrpcimpl.Payout;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2pojojaxrpcimpl.Rider;
import com.ibm.wssvt.acme.common.bean.Configrable;
import com.ibm.wssvt.acme.common.bean.Parameterizable;
import java.util.Calendar;
import java.util.Date;

public class JAXWS2PojoJAXRPCClientBeanToJavaBean {
    private static IAnnuityBeansFactory beansFactory = new JavaBeansFactory();

    public static IAddress getAddress(Address in) {
        if (in == null) {
            return null;
        }
        IAddress out = beansFactory.createAddress();
        out.setCity(in.getCity());
        out.setCountry(in.getCountry());
        out.setLine1(in.getLine1());
        out.setLine2(in.getLine2());
        out.setState(in.getState());
        out.setZipCode(in.getZipCode());
        return out;
    }

    public static IContact getContact(Contact in) {
        if (in == null) {
            return null;
        }
        IContact out = beansFactory.createContact();
        out.setEmail(in.getEmail());
        out.setPhone(in.getPhone());
        out.setAddress(JAXWS2PojoJAXRPCClientBeanToJavaBean.getAddress(in.getAddress()));
        if (in.getContactType() != null) {
            out.setContactType(ContactType.valueOf(in.getContactType().toString()));
        }
        JAXWS2PojoJAXRPCClientBeanToJavaBean.setConfigrableAtts(in, out);
        JAXWS2PojoJAXRPCClientBeanToJavaBean.setAnnuityObjectAtts(in, out);
        return out;
    }

    public static IAnnuityHolder getAnnuityHolder(AnnuityHolder in) {
        if (in == null) {
            return null;
        }
        IAnnuityHolder out = beansFactory.createAnnuityHolder();
        if (in.getCategory() != null) {
            out.setCategory(AnnuityHolderCategory.valueOf(in.getCategory().toString()));
        }
        out.setContact(JAXWS2PojoJAXRPCClientBeanToJavaBean.getContact(in.getContact()));
        if (in.getDateOfBirth() != null) {
            out.setDateOfBirth(in.getDateOfBirth().toGregorianCalendar().getTime());
        }
        out.setFirstName(in.getFirstName());
        out.setLastName(in.getLastName());
        out.setGovernmentId(in.getGovernmentId());
        if (in.getPicture() == null) {
            out.setPicture(null);
        } else {
            Byte[] picArray = new Byte[in.getPicture().length];
            for (int i = 0; i < in.getPicture().length; ++i) {
                picArray[i] = in.getPicture()[i];
            }
            out.setPicture(picArray);
        }
        if (in.getTimeOfBirth() != null) {
            out.setTimeOfBirth(in.getTimeOfBirth().toGregorianCalendar().getTime());
        }
        JAXWS2PojoJAXRPCClientBeanToJavaBean.setAnnuityObjectAtts(in, out);
        JAXWS2PojoJAXRPCClientBeanToJavaBean.setConfigrableAtts(in, out);
        return out;
    }

    public static IAnnuity getAnnuity(Annuity in) {
        IAnnuity out;
        if (in == null) {
            return null;
        }
        if (in instanceof FixedAnnuity) {
            out = beansFactory.createAnnFixed();
            out.setRate(((FixedAnnuity)in).getRate());
        } else if (in instanceof EquityAnnuity) {
            out = beansFactory.createAnnEquity();
            ((IEquityAnnuity)out).setFundNames(((EquityAnnuity)in).getFundNames());
            ((IEquityAnnuity)out).setIndexRate(((EquityAnnuity)in).getIndexRate());
        } else {
            out = beansFactory.createAnnuity();
        }
        out.setAccountNumber(in.getAccountNumber());
        out.setAmount(in.getAmount());
        out.setAnnuityHolderId(in.getAnnuityHolderId());
        out.setLastPaidAmt(in.getLastPaidAmt());
        if (in.getPayors() != null) {
            for (Payor payor : in.getPayors().getPayor()) {
                IPayor outp = JAXWS2PojoJAXRPCClientBeanToJavaBean.getPayor(payor);
                out.getPayors().add(outp);
            }
        }
        if (in.getRiders() != null) {
            for (Rider rider : in.getRiders().getRider()) {
                IRider outr = JAXWS2PojoJAXRPCClientBeanToJavaBean.getRider(rider);
                out.getRiders().add(outr);
            }
        }
        if (in.getPayouts() != null) {
            for (Payout payout : in.getPayouts().getPayout()) {
                IPayout p = JAXWS2PojoJAXRPCClientBeanToJavaBean.getPayoutWithNoAnnuity(payout);
                p.setAnnuity(out);
                out.getPayouts().add(p);
            }
        }
        JAXWS2PojoJAXRPCClientBeanToJavaBean.setAnnuityObjectAtts(in, out);
        JAXWS2PojoJAXRPCClientBeanToJavaBean.setConfigrableAtts(in, out);
        return out;
    }

    public static IPayout getPayoutWithNoAnnuity(Payout in) {
        if (in == null) {
            return null;
        }
        IPayout out = beansFactory.createPayout();
        out.setTaxableAmount(in.getTaxableAmount());
        if (in.getEndDate() != null) {
            out.setEndDate(in.getEndDate().toGregorianCalendar());
        }
        if (in.getStartDate() != null) {
            out.setStartDate(in.getStartDate().toGregorianCalendar());
        }
        JAXWS2PojoJAXRPCClientBeanToJavaBean.setAnnuityObjectAtts(in, out);
        JAXWS2PojoJAXRPCClientBeanToJavaBean.setConfigrableAtts(in, out);
        return out;
    }

    public static IPayout getPayout(Payout in) {
        if (in == null) {
            return null;
        }
        IPayout out = JAXWS2PojoJAXRPCClientBeanToJavaBean.getPayoutWithNoAnnuity(in);
        out.setAnnuity(JAXWS2PojoJAXRPCClientBeanToJavaBean.getAnnuity(in.getAnnuity()));
        return out;
    }

    public static IRider getRider(Rider in) {
        if (in == null) {
            return null;
        }
        IRider out = beansFactory.createRider();
        out.setRule(in.getRule());
        if (in.getEffectiveDate() != null) {
            out.setEffectiveDate(in.getEffectiveDate().toGregorianCalendar().getTime());
        }
        if (in.getType() != null) {
            out.setType(RiderType.valueOf(in.getType().toString()));
        }
        JAXWS2PojoJAXRPCClientBeanToJavaBean.setAnnuityObjectAtts(in, out);
        JAXWS2PojoJAXRPCClientBeanToJavaBean.setConfigrableAtts(in, out);
        return out;
    }

    public static IPayor getPayor(Payor in) {
        if (in == null) {
            return null;
        }
        IPayor out = beansFactory.createPayor();
        out.setName(in.getName());
        JAXWS2PojoJAXRPCClientBeanToJavaBean.setAnnuityObjectAtts(in, out);
        JAXWS2PojoJAXRPCClientBeanToJavaBean.setConfigrableAtts(in, out);
        return out;
    }

    public static void dateToCalendar(Date in, Calendar out) {
        if (in == null) {
            out = null;
        } else {
            out.setTime(in);
        }
    }

    public static void setAnnuityObjectAtts(AnnuityPersistebleObject in, IAnnuityObject out) {
        out.setId(in.getId());
        out.setVersion(in.getVersion());
        if (in.getLastUpdateDate() != null) {
            out.setLastUpdateDate(in.getLastUpdateDate().toGregorianCalendar().getTime());
        }
    }

    public static void setConfigrableAtts(AnnuityPersistebleObject in, Configrable<String, String> out) {
        if (in.getConfig() == null || in.getConfig().getParams() == null) {
            return;
        }
        Parameterizable sp = beansFactory.createParameterizable();
        ArrayOfEntry aoe = in.getConfig().getParams();
        if (aoe == null) {
            return;
        }
        for (Entry entry : aoe.getEntry()) {
            sp.addParameter((Object)entry.getKey(), (Object)entry.getValue());
        }
        out.setConfiguration(sp);
    }
}

