/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.servicelookup.jaxrpc2pojojaxws;

import com.ibm.wssvt.acme.annuity.common.bean.IAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.bean.IContact;
import com.ibm.wssvt.acme.annuity.common.bean.IPayor;
import com.ibm.wssvt.acme.annuity.common.bean.IPayout;
import com.ibm.wssvt.acme.annuity.common.bean.IRider;
import com.ibm.wssvt.acme.annuity.common.business.IAnnuityService;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.bean.jaxrpc2pojojaxws.AnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.bean.jaxrpc2pojojaxws.AnnuityValueObject;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.bean.jaxrpc2pojojaxws.Contact;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.bean.jaxrpc2pojojaxws.Payor;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.bean.jaxrpc2pojojaxws.PayoutValueObject;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.bean.jaxrpc2pojojaxws.Rider;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.beanconverter.jaxrpc2pojojaxws.JAXRPC2PojoJAXWSClientBeanToJavaBean;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.beanconverter.jaxrpc2pojojaxws.JavaBeanToJAXRPC2PojoJAXWSClientBean;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.jaxrpc2pojojaxwsimpl.AnnuityMgmtSvcPojoJAXWS;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.jaxrpc2pojojaxwsimpl.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.jaxrpc2pojojaxwsimpl.ServerPersistenceModuleException;
import com.ibm.wssvt.acme.annuity.common.exception.EntityAlreadyExistsException;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerBusinessModuleException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.common.exception.ExceptionFormatter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class AnnuityJAXRPCToPojoJAXWSServiceProxy
implements IAnnuityService {
    private AnnuityMgmtSvcPojoJAXWS webService;

    public AnnuityJAXRPCToPojoJAXWSServiceProxy(AnnuityMgmtSvcPojoJAXWS webServiceInterface) {
        this.webService = webServiceInterface;
    }

    private void processCommonExceptions(Exception e) throws com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException, ServerInternalErrorException {
        if (e instanceof InvalidArgumentException) {
            throw new com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException(e);
        }
        if (e instanceof com.ibm.wssvt.acme.annuity.common.client.jaxrpc.jaxrpc2pojojaxwsimpl.ServerBusinessModuleException) {
            throw new ServerBusinessModuleException(e);
        }
        if (e instanceof ServerPersistenceModuleException) {
            throw new com.ibm.wssvt.acme.annuity.common.exception.ServerPersistenceModuleException(e);
        }
        if (e instanceof RemoteException) {
            throw new ServerInternalErrorException("Remote Exception was thrown.  Error is: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
        e.printStackTrace();
        throw new RuntimeException("Unexpected error. Erros is: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
    }

    @Override
    public IAnnuity createAnnuity(IAnnuity ann) throws ServerInternalErrorException, EntityAlreadyExistsException, com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException {
        AnnuityValueObject result = null;
        try {
            AnnuityValueObject annuityValueObject = new AnnuityValueObject();
            annuityValueObject.setAnnuity(JavaBeanToJAXRPC2PojoJAXWSClientBean.getAnnuity(ann));
            result = this.webService.createAnnuity(annuityValueObject);
            annuityValueObject.getAnnuityData();
        }
        catch (com.ibm.wssvt.acme.annuity.common.client.jaxrpc.jaxrpc2pojojaxwsimpl.EntityAlreadyExistsException e) {
            throw new EntityAlreadyExistsException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JAXRPC2PojoJAXWSClientBeanToJavaBean.getAnnuity(result.getAnnuityData());
    }

    @Override
    public IAnnuityHolder createAnnuityHolder(IAnnuityHolder annHolder) throws ServerInternalErrorException, EntityAlreadyExistsException, com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException {
        AnnuityHolder result = null;
        try {
            result = this.webService.createAnnuityHolder(JavaBeanToJAXRPC2PojoJAXWSClientBean.getAnnuityHolder(annHolder));
        }
        catch (com.ibm.wssvt.acme.annuity.common.client.jaxrpc.jaxrpc2pojojaxwsimpl.EntityAlreadyExistsException e) {
            throw new EntityAlreadyExistsException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JAXRPC2PojoJAXWSClientBeanToJavaBean.getAnnuityHolder(result);
    }

    @Override
    public IContact createContact(IContact contact) throws ServerInternalErrorException, EntityAlreadyExistsException, com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException {
        Contact result = null;
        try {
            result = this.webService.createContact(JavaBeanToJAXRPC2PojoJAXWSClientBean.getContact(contact));
        }
        catch (com.ibm.wssvt.acme.annuity.common.client.jaxrpc.jaxrpc2pojojaxwsimpl.EntityAlreadyExistsException e) {
            throw new EntityAlreadyExistsException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JAXRPC2PojoJAXWSClientBeanToJavaBean.getContact(result);
    }

    @Override
    public IPayor createPayor(IPayor payor) throws ServerInternalErrorException, EntityAlreadyExistsException, com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException {
        Payor result = null;
        try {
            result = this.webService.createPayor(JavaBeanToJAXRPC2PojoJAXWSClientBean.getPayor(payor));
        }
        catch (com.ibm.wssvt.acme.annuity.common.client.jaxrpc.jaxrpc2pojojaxwsimpl.EntityAlreadyExistsException e) {
            throw new EntityAlreadyExistsException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JAXRPC2PojoJAXWSClientBeanToJavaBean.getPayor(result);
    }

    @Override
    public IPayout createPayout(IPayout payout) throws ServerInternalErrorException, EntityAlreadyExistsException, com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException {
        PayoutValueObject result = null;
        try {
            PayoutValueObject payoutValueObject = new PayoutValueObject();
            payoutValueObject.setPayout(JavaBeanToJAXRPC2PojoJAXWSClientBean.getPayout(payout));
            result = this.webService.createPayout(payoutValueObject);
            payoutValueObject.getPayoutData();
        }
        catch (com.ibm.wssvt.acme.annuity.common.client.jaxrpc.jaxrpc2pojojaxwsimpl.EntityAlreadyExistsException e) {
            throw new EntityAlreadyExistsException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JAXRPC2PojoJAXWSClientBeanToJavaBean.getPayout(result.getPayoutData());
    }

    @Override
    public void deleteAnnuity(IAnnuity annuity) throws ServerInternalErrorException, com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException {
        try {
            AnnuityValueObject annuityValueObject = new AnnuityValueObject();
            annuityValueObject.setAnnuity(JavaBeanToJAXRPC2PojoJAXWSClientBean.getAnnuity(annuity));
            this.webService.deleteAnnuity(annuityValueObject);
            annuityValueObject.getAnnuityData();
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
    }

    @Override
    public void deleteAnnuityHolder(IAnnuityHolder annHolder) throws ServerInternalErrorException, com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException {
        try {
            this.webService.deleteAnnuityHolder(JavaBeanToJAXRPC2PojoJAXWSClientBean.getAnnuityHolder(annHolder));
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
    }

    @Override
    public void deleteContact(IContact contact) throws ServerInternalErrorException, com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException {
        try {
            this.webService.deleteContact(JavaBeanToJAXRPC2PojoJAXWSClientBean.getContact(contact));
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
    }

    @Override
    public void deletePayor(IPayor payor) throws ServerInternalErrorException, com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException {
        try {
            this.webService.deletePayor(JavaBeanToJAXRPC2PojoJAXWSClientBean.getPayor(payor));
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
    }

    @Override
    public void deletePayout(IPayout payout) throws ServerInternalErrorException, com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException {
        try {
            PayoutValueObject payoutValueObject = new PayoutValueObject();
            payoutValueObject.setPayout(JavaBeanToJAXRPC2PojoJAXWSClientBean.getPayout(payout));
            this.webService.deletePayout(payoutValueObject);
            payoutValueObject.getPayoutData();
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
    }

    @Override
    public void deleteRider(IRider rider) throws ServerInternalErrorException, com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException {
        try {
            this.webService.deleteRider(JavaBeanToJAXRPC2PojoJAXWSClientBean.getRider(rider));
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
    }

    @Override
    public IAnnuity findAnnuityById(IAnnuity annuity) throws EntityNotFoundException, ServerInternalErrorException, com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException {
        AnnuityValueObject result = null;
        try {
            AnnuityValueObject annuityValueObject = new AnnuityValueObject();
            annuityValueObject.setAnnuity(JavaBeanToJAXRPC2PojoJAXWSClientBean.getAnnuity(annuity));
            result = this.webService.findAnnuityById(annuityValueObject);
            annuityValueObject.getAnnuityData();
        }
        catch (com.ibm.wssvt.acme.annuity.common.client.jaxrpc.jaxrpc2pojojaxwsimpl.EntityNotFoundException e) {
            throw new EntityNotFoundException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JAXRPC2PojoJAXWSClientBeanToJavaBean.getAnnuity(result.getAnnuityData());
    }

    @Override
    public IAnnuityHolder findAnnuityHolder(IAnnuity annuity) throws EntityNotFoundException, ServerInternalErrorException, com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException {
        AnnuityHolder result = null;
        try {
            AnnuityValueObject annuityValueObject = new AnnuityValueObject();
            annuityValueObject.setAnnuity(JavaBeanToJAXRPC2PojoJAXWSClientBean.getAnnuity(annuity));
            result = this.webService.findAnnuityHolder(annuityValueObject);
            annuityValueObject.getAnnuityData();
        }
        catch (com.ibm.wssvt.acme.annuity.common.client.jaxrpc.jaxrpc2pojojaxwsimpl.EntityNotFoundException e) {
            throw new EntityNotFoundException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JAXRPC2PojoJAXWSClientBeanToJavaBean.getAnnuityHolder(result);
    }

    @Override
    public IContact findContactById(IContact contact) throws EntityNotFoundException, ServerInternalErrorException, com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException {
        Contact result = null;
        try {
            result = this.webService.findContactById(JavaBeanToJAXRPC2PojoJAXWSClientBean.getContact(contact));
        }
        catch (com.ibm.wssvt.acme.annuity.common.client.jaxrpc.jaxrpc2pojojaxwsimpl.EntityNotFoundException e) {
            throw new EntityNotFoundException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JAXRPC2PojoJAXWSClientBeanToJavaBean.getContact(result);
    }

    @Override
    public List<IAnnuity> findHolderAnnuities(IAnnuityHolder annuityHolder) throws ServerInternalErrorException, com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException {
        AnnuityValueObject[] result = null;
        try {
            result = this.webService.findHolderAnnuities(JavaBeanToJAXRPC2PojoJAXWSClientBean.getAnnuityHolder(annuityHolder));
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return this.getAnnuityListFromAnnuityVOList(result);
    }

    @Override
    public IAnnuityHolder findHolderById(IAnnuityHolder annuityHolder) throws EntityNotFoundException, ServerInternalErrorException, com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException {
        AnnuityHolder result = null;
        try {
            result = this.webService.findHolderById(JavaBeanToJAXRPC2PojoJAXWSClientBean.getAnnuityHolder(annuityHolder));
        }
        catch (com.ibm.wssvt.acme.annuity.common.client.jaxrpc.jaxrpc2pojojaxwsimpl.EntityNotFoundException e) {
            throw new EntityNotFoundException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JAXRPC2PojoJAXWSClientBeanToJavaBean.getAnnuityHolder(result);
    }

    @Override
    public List<IAnnuity> findPayorAnnuities(IPayor payor) throws ServerInternalErrorException, com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException {
        AnnuityValueObject[] result = null;
        try {
            result = this.webService.findPayorAnnuities(JavaBeanToJAXRPC2PojoJAXWSClientBean.getPayor(payor));
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return this.getAnnuityListFromAnnuityVOList(result);
    }

    @Override
    public IPayor findPayorById(IPayor payor) throws EntityNotFoundException, ServerInternalErrorException, com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException {
        Payor result = null;
        try {
            result = this.webService.findPayorById(JavaBeanToJAXRPC2PojoJAXWSClientBean.getPayor(payor));
        }
        catch (com.ibm.wssvt.acme.annuity.common.client.jaxrpc.jaxrpc2pojojaxwsimpl.EntityNotFoundException e) {
            throw new EntityNotFoundException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JAXRPC2PojoJAXWSClientBeanToJavaBean.getPayor(result);
    }

    @Override
    public IPayout findPayoutById(IPayout payout) throws EntityNotFoundException, ServerInternalErrorException, com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException {
        PayoutValueObject result = null;
        try {
            PayoutValueObject payoutValueObject = new PayoutValueObject();
            payoutValueObject.setPayout(JavaBeanToJAXRPC2PojoJAXWSClientBean.getPayout(payout));
            result = this.webService.findPayoutById(payoutValueObject);
            payoutValueObject.getPayoutData();
        }
        catch (com.ibm.wssvt.acme.annuity.common.client.jaxrpc.jaxrpc2pojojaxwsimpl.EntityNotFoundException e) {
            throw new EntityNotFoundException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JAXRPC2PojoJAXWSClientBeanToJavaBean.getPayout(result.getPayout());
    }

    @Override
    public IRider findRiderById(IRider rider) throws EntityNotFoundException, ServerInternalErrorException, com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException {
        Rider result = null;
        try {
            result = this.webService.findRiderById(JavaBeanToJAXRPC2PojoJAXWSClientBean.getRider(rider));
        }
        catch (com.ibm.wssvt.acme.annuity.common.client.jaxrpc.jaxrpc2pojojaxwsimpl.EntityNotFoundException e) {
            throw new EntityNotFoundException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JAXRPC2PojoJAXWSClientBeanToJavaBean.getRider(result);
    }

    @Override
    public IAnnuity updateAnnuity(IAnnuity ann) throws ServerInternalErrorException, com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException {
        AnnuityValueObject result = null;
        try {
            AnnuityValueObject annuityValueObject = new AnnuityValueObject();
            annuityValueObject.setAnnuity(JavaBeanToJAXRPC2PojoJAXWSClientBean.getAnnuity(ann));
            result = this.webService.updateAnnuity(annuityValueObject);
            annuityValueObject.getAnnuityData();
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JAXRPC2PojoJAXWSClientBeanToJavaBean.getAnnuity(result.getAnnuityData());
    }

    @Override
    public IAnnuityHolder updateAnnuityHolder(IAnnuityHolder annHolder) throws ServerInternalErrorException, com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException {
        AnnuityHolder result = null;
        try {
            result = this.webService.updateAnnuityHolder(JavaBeanToJAXRPC2PojoJAXWSClientBean.getAnnuityHolder(annHolder));
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JAXRPC2PojoJAXWSClientBeanToJavaBean.getAnnuityHolder(result);
    }

    @Override
    public IContact updateContact(IContact contact) throws ServerInternalErrorException, com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException {
        Contact result = null;
        try {
            result = this.webService.updateContact(JavaBeanToJAXRPC2PojoJAXWSClientBean.getContact(contact));
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JAXRPC2PojoJAXWSClientBeanToJavaBean.getContact(result);
    }

    @Override
    public IPayor updatePayor(IPayor payor) throws ServerInternalErrorException, com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException {
        Payor result = null;
        try {
            result = this.webService.updatePayor(JavaBeanToJAXRPC2PojoJAXWSClientBean.getPayor(payor));
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JAXRPC2PojoJAXWSClientBeanToJavaBean.getPayor(result);
    }

    @Override
    public IPayout updatePayout(IPayout payout) throws ServerInternalErrorException, com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException {
        PayoutValueObject result = null;
        try {
            PayoutValueObject payoutValueObject = new PayoutValueObject();
            payoutValueObject.setPayout(JavaBeanToJAXRPC2PojoJAXWSClientBean.getPayout(payout));
            result = this.webService.updatePayout(payoutValueObject);
            payoutValueObject.getPayoutData();
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JAXRPC2PojoJAXWSClientBeanToJavaBean.getPayout(result.getPayoutData());
    }

    private List<IAnnuity> getAnnuityListFromAnnuityVOList(AnnuityValueObject[] result) {
        if (result == null) {
            return null;
        }
        ArrayList<IAnnuity> list = new ArrayList<IAnnuity>();
        for (int i = 0; i < result.length; ++i) {
            AnnuityValueObject o = result[i];
            list.add(JAXRPC2PojoJAXWSClientBeanToJavaBean.getAnnuity(o.getAnnuityData()));
        }
        return list;
    }
}

