/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.servicelookup.jaxws2ejb3jaxrpc;

import com.ibm.wssvt.acme.annuity.common.bean.IAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.bean.IContact;
import com.ibm.wssvt.acme.annuity.common.bean.IPayor;
import com.ibm.wssvt.acme.annuity.common.bean.IPayout;
import com.ibm.wssvt.acme.annuity.common.bean.IRider;
import com.ibm.wssvt.acme.annuity.common.business.IAnnuityService;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.beanconverter.jaxws2ejb3jaxrpc.JAXWS2Ejb3JAXRPCClientBeanToJavaBean;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.beanconverter.jaxws2ejb3jaxrpc.JavaBeanToJAXWS2Ejb3JAXRPCClientBean;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.AnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.AnnuityMgmtSvcEJB3JAXRPCSEI;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.AnnuityValueObject;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.ArrayOfTns2NillableAnnuityValueObject;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.Contact;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.CreateAnnuityHolderResponse;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.CreateAnnuityResponse;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.CreateContactResponse;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.CreatePayorResponse;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.CreatePayoutResponse;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.DeleteAnnuityHolderResponse;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.DeleteAnnuityResponse;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.DeleteContactResponse;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.DeletePayorResponse;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.DeletePayoutResponse;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.DeleteRiderResponse;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.EntityAlreadyExistsException_Exception;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.EntityNotFoundException_Exception;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.FindAnnuityByIdResponse;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.FindAnnuityHolderResponse;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.FindContactByIdResponse;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.FindHolderAnnuitiesResponse;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.FindHolderByIdResponse;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.FindPayorAnnuitiesResponse;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.FindPayorByIdResponse;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.FindPayoutByIdResponse;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.FindRiderByIdResponse;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.InvalidArgumentException_Exception;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.Payor;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.PayoutValueObject;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.Rider;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.ServerBusinessModuleException_Exception;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.ServerPersistenceModuleException_Exception;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.UpdateAnnuityHolderResponse;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.UpdateAnnuityResponse;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.UpdateContactResponse;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.UpdatePayorResponse;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.UpdatePayoutResponse;
import com.ibm.wssvt.acme.annuity.common.exception.EntityAlreadyExistsException;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerBusinessModuleException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerPersistenceModuleException;
import com.ibm.wssvt.acme.common.bean.Configrable;
import com.ibm.wssvt.acme.common.exception.ExceptionFormatter;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import javax.xml.ws.Response;

public class AnnuityJAXWSToEjb3JAXRPCServiceProxyAsync
implements IAnnuityService {
    private AnnuityMgmtSvcEJB3JAXRPCSEI webService;
    private AcmeLogger logger;

    public AnnuityJAXWSToEjb3JAXRPCServiceProxyAsync(AnnuityMgmtSvcEJB3JAXRPCSEI webServiceInterface, AcmeLogger logger) {
        this.webService = webServiceInterface;
        this.logger = logger;
    }

    @Override
    public IAnnuity createAnnuity(IAnnuity annuity) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        AnnuityValueObject result = null;
        try {
            AnnuityValueObject annuityValueObject = this.getAnnuityValueObject(annuity);
            Response<CreateAnnuityResponse> response = this.webService.createAnnuityAsync(annuityValueObject);
            this.waitAndCheckForValidResponse(response, annuity);
            result = ((CreateAnnuityResponse)response.get()).getCreateAnnuityReturn();
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.processEntityAlreadyExistsException(cause);
            this.processCommonException(cause);
        }
        return result == null ? null : JAXWS2Ejb3JAXRPCClientBeanToJavaBean.getAnnuity(result.getAnnuityData());
    }

    @Override
    public IAnnuity findAnnuityById(IAnnuity annuity) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        AnnuityValueObject result = null;
        try {
            AnnuityValueObject annuityValueObject = this.getAnnuityValueObject(annuity);
            Response<FindAnnuityByIdResponse> response = this.webService.findAnnuityByIdAsync(annuityValueObject);
            this.waitAndCheckForValidResponse(response, annuity);
            result = ((FindAnnuityByIdResponse)response.get()).getFindAnnuityByIdReturn();
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.processEntityNotFoundException(cause);
            this.processCommonException(cause);
        }
        return result == null ? null : JAXWS2Ejb3JAXRPCClientBeanToJavaBean.getAnnuity(result.getAnnuityData());
    }

    @Override
    public IAnnuityHolder findAnnuityHolder(IAnnuity annuity) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        AnnuityHolder result = null;
        try {
            AnnuityValueObject annuityValueObject = this.getAnnuityValueObject(annuity);
            Response<FindAnnuityHolderResponse> response = this.webService.findAnnuityHolderAsync(annuityValueObject);
            this.waitAndCheckForValidResponse(response, annuity);
            result = ((FindAnnuityHolderResponse)response.get()).getFindAnnuityHolderReturn();
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.processEntityNotFoundException(cause);
            this.processCommonException(cause);
        }
        return JAXWS2Ejb3JAXRPCClientBeanToJavaBean.getAnnuityHolder(result);
    }

    @Override
    public IContact findContactById(IContact contact) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        Contact result = null;
        try {
            Response<FindContactByIdResponse> response = this.webService.findContactByIdAsync(JavaBeanToJAXWS2Ejb3JAXRPCClientBean.getContact(contact));
            this.waitAndCheckForValidResponse(response, contact);
            result = ((FindContactByIdResponse)response.get()).getFindContactByIdReturn();
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.processEntityNotFoundException(cause);
            this.processCommonException(cause);
        }
        return JAXWS2Ejb3JAXRPCClientBeanToJavaBean.getContact(result);
    }

    @Override
    public List<IAnnuity> findHolderAnnuities(IAnnuityHolder annuityHolder) throws ServerInternalErrorException, InvalidArgumentException {
        ArrayList<IAnnuity> returnData = new ArrayList<IAnnuity>();
        try {
            Response<FindHolderAnnuitiesResponse> response = this.webService.findHolderAnnuitiesAsync(JavaBeanToJAXWS2Ejb3JAXRPCClientBean.getAnnuityHolder(annuityHolder));
            this.waitAndCheckForValidResponse(response, annuityHolder);
            ArrayOfTns2NillableAnnuityValueObject result = ((FindHolderAnnuitiesResponse)response.get()).getFindHolderAnnuitiesReturn();
            if (result == null || result.getAnnuityValueObject() == null) {
                return null;
            }
            for (AnnuityValueObject object : result.getAnnuityValueObject()) {
                returnData.add(JAXWS2Ejb3JAXRPCClientBeanToJavaBean.getAnnuity(object.getAnnuityData()));
            }
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.processCommonException(cause);
        }
        return returnData;
    }

    @Override
    public IAnnuityHolder findHolderById(IAnnuityHolder annuityHolder) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        AnnuityHolder result = null;
        try {
            Response<FindHolderByIdResponse> response = this.webService.findHolderByIdAsync(JavaBeanToJAXWS2Ejb3JAXRPCClientBean.getAnnuityHolder(annuityHolder));
            this.waitAndCheckForValidResponse(response, annuityHolder);
            result = ((FindHolderByIdResponse)response.get()).getFindHolderByIdReturn();
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.processEntityNotFoundException(cause);
            this.processCommonException(cause);
        }
        return JAXWS2Ejb3JAXRPCClientBeanToJavaBean.getAnnuityHolder(result);
    }

    @Override
    public List<IAnnuity> findPayorAnnuities(IPayor payor) throws ServerInternalErrorException, InvalidArgumentException {
        ArrayList<IAnnuity> returnData = new ArrayList<IAnnuity>();
        try {
            Response<FindPayorAnnuitiesResponse> response = this.webService.findPayorAnnuitiesAsync(JavaBeanToJAXWS2Ejb3JAXRPCClientBean.getPayor(payor));
            this.waitAndCheckForValidResponse(response, payor);
            ArrayOfTns2NillableAnnuityValueObject result = ((FindPayorAnnuitiesResponse)response.get()).getFindPayorAnnuitiesReturn();
            if (result == null || result.getAnnuityValueObject() == null) {
                return null;
            }
            for (AnnuityValueObject object : result.getAnnuityValueObject()) {
                returnData.add(JAXWS2Ejb3JAXRPCClientBeanToJavaBean.getAnnuity(object.getAnnuityData()));
            }
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.processCommonException(cause);
        }
        return returnData;
    }

    @Override
    public IPayor findPayorById(IPayor payor) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        Payor result = null;
        try {
            Response<FindPayorByIdResponse> response = this.webService.findPayorByIdAsync(JavaBeanToJAXWS2Ejb3JAXRPCClientBean.getPayor(payor));
            this.waitAndCheckForValidResponse(response, payor);
            result = ((FindPayorByIdResponse)response.get()).getFindPayorByIdReturn();
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.processEntityNotFoundException(cause);
            this.processCommonException(cause);
        }
        return JAXWS2Ejb3JAXRPCClientBeanToJavaBean.getPayor(result);
    }

    @Override
    public IPayout findPayoutById(IPayout payout) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        PayoutValueObject result = null;
        try {
            PayoutValueObject in = new PayoutValueObject();
            in.setPayout(JavaBeanToJAXWS2Ejb3JAXRPCClientBean.getPayout(payout));
            Response<FindPayoutByIdResponse> response = this.webService.findPayoutByIdAsync(in);
            this.waitAndCheckForValidResponse(response, payout);
            result = ((FindPayoutByIdResponse)response.get()).getFindPayoutByIdReturn();
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.processEntityNotFoundException(cause);
            this.processCommonException(cause);
        }
        return result == null ? null : JAXWS2Ejb3JAXRPCClientBeanToJavaBean.getPayout(result.getPayout());
    }

    @Override
    public IRider findRiderById(IRider rider) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        Rider result = null;
        try {
            Response<FindRiderByIdResponse> response = this.webService.findRiderByIdAsync(JavaBeanToJAXWS2Ejb3JAXRPCClientBean.getRider(rider));
            this.waitAndCheckForValidResponse(response, rider);
            result = ((FindRiderByIdResponse)response.get()).getFindRiderByIdReturn();
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.processEntityNotFoundException(cause);
            this.processCommonException(cause);
        }
        return JAXWS2Ejb3JAXRPCClientBeanToJavaBean.getRider(result);
    }

    @Override
    public IAnnuityHolder createAnnuityHolder(IAnnuityHolder annHolder) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        AnnuityHolder result = null;
        try {
            Response<CreateAnnuityHolderResponse> response = this.webService.createAnnuityHolderAsync(JavaBeanToJAXWS2Ejb3JAXRPCClientBean.getAnnuityHolder(annHolder));
            this.waitAndCheckForValidResponse(response, annHolder);
            result = ((CreateAnnuityHolderResponse)response.get()).getCreateAnnuityHolderReturn();
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.processEntityAlreadyExistsException(cause);
            this.processCommonException(cause);
        }
        return JAXWS2Ejb3JAXRPCClientBeanToJavaBean.getAnnuityHolder(result);
    }

    @Override
    public IContact createContact(IContact contact) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        Contact result = null;
        try {
            Response<CreateContactResponse> response = this.webService.createContactAsync(JavaBeanToJAXWS2Ejb3JAXRPCClientBean.getContact(contact));
            this.waitAndCheckForValidResponse(response, contact);
            result = ((CreateContactResponse)response.get()).getCreateContactReturn();
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.processEntityAlreadyExistsException(cause);
            this.processCommonException(cause);
        }
        return JAXWS2Ejb3JAXRPCClientBeanToJavaBean.getContact(result);
    }

    @Override
    public IPayor createPayor(IPayor payor) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        Payor result = null;
        try {
            Response<CreatePayorResponse> response = this.webService.createPayorAsync(JavaBeanToJAXWS2Ejb3JAXRPCClientBean.getPayor(payor));
            this.waitAndCheckForValidResponse(response, payor);
            result = ((CreatePayorResponse)response.get()).getCreatePayorReturn();
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.processEntityAlreadyExistsException(cause);
            this.processCommonException(cause);
        }
        return JAXWS2Ejb3JAXRPCClientBeanToJavaBean.getPayor(result);
    }

    @Override
    public IPayout createPayout(IPayout payout) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        PayoutValueObject result = null;
        try {
            PayoutValueObject in = new PayoutValueObject();
            in.setPayout(JavaBeanToJAXWS2Ejb3JAXRPCClientBean.getPayout(payout));
            Response<CreatePayoutResponse> response = this.webService.createPayoutAsync(in);
            this.waitAndCheckForValidResponse(response, payout);
            result = ((CreatePayoutResponse)response.get()).getCreatePayoutReturn();
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.processEntityAlreadyExistsException(cause);
            this.processCommonException(cause);
        }
        return result == null ? null : JAXWS2Ejb3JAXRPCClientBeanToJavaBean.getPayout(result.getPayoutData());
    }

    @Override
    public void deleteAnnuity(IAnnuity annuity) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            AnnuityValueObject annuityValueObject = this.getAnnuityValueObject(annuity);
            Response<DeleteAnnuityResponse> response = this.webService.deleteAnnuityAsync(annuityValueObject);
            this.waitAndCheckForValidResponse(response, annuity);
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.processCommonException(cause);
        }
    }

    @Override
    public void deleteAnnuityHolder(IAnnuityHolder annHolder) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            Response<DeleteAnnuityHolderResponse> response = this.webService.deleteAnnuityHolderAsync(JavaBeanToJAXWS2Ejb3JAXRPCClientBean.getAnnuityHolder(annHolder));
            this.waitAndCheckForValidResponse(response, annHolder);
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.processCommonException(cause);
        }
    }

    @Override
    public void deleteContact(IContact contact) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            Response<DeleteContactResponse> response = this.webService.deleteContactAsync(JavaBeanToJAXWS2Ejb3JAXRPCClientBean.getContact(contact));
            this.waitAndCheckForValidResponse(response, contact);
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.processCommonException(cause);
        }
    }

    @Override
    public void deletePayor(IPayor payor) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            Response<DeletePayorResponse> response = this.webService.deletePayorAsync(JavaBeanToJAXWS2Ejb3JAXRPCClientBean.getPayor(payor));
            this.waitAndCheckForValidResponse(response, payor);
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.processCommonException(cause);
        }
    }

    @Override
    public void deletePayout(IPayout payout) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            PayoutValueObject in = new PayoutValueObject();
            in.setPayout(JavaBeanToJAXWS2Ejb3JAXRPCClientBean.getPayout(payout));
            Response<DeletePayoutResponse> response = this.webService.deletePayoutAsync(in);
            this.waitAndCheckForValidResponse(response, payout);
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.processCommonException(cause);
        }
    }

    @Override
    public void deleteRider(IRider rider) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            Response<DeleteRiderResponse> response = this.webService.deleteRiderAsync(JavaBeanToJAXWS2Ejb3JAXRPCClientBean.getRider(rider));
            this.waitAndCheckForValidResponse(response, rider);
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.processCommonException(cause);
        }
    }

    @Override
    public IAnnuity updateAnnuity(IAnnuity annuity) throws ServerInternalErrorException, InvalidArgumentException {
        AnnuityValueObject result = null;
        try {
            AnnuityValueObject annuityValueObject = this.getAnnuityValueObject(annuity);
            Response<UpdateAnnuityResponse> response = this.webService.updateAnnuityAsync(annuityValueObject);
            this.waitAndCheckForValidResponse(response, annuity);
            result = ((UpdateAnnuityResponse)response.get()).getUpdateAnnuityReturn();
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.processCommonException(cause);
        }
        return result == null ? null : JAXWS2Ejb3JAXRPCClientBeanToJavaBean.getAnnuity(result.getAnnuityData());
    }

    @Override
    public IAnnuityHolder updateAnnuityHolder(IAnnuityHolder annHolder) throws ServerInternalErrorException, InvalidArgumentException {
        AnnuityHolder result = null;
        try {
            Response<UpdateAnnuityHolderResponse> response = this.webService.updateAnnuityHolderAsync(JavaBeanToJAXWS2Ejb3JAXRPCClientBean.getAnnuityHolder(annHolder));
            this.waitAndCheckForValidResponse(response, annHolder);
            result = ((UpdateAnnuityHolderResponse)response.get()).getUpdateAnnuityHolderReturn();
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.processCommonException(cause);
        }
        return JAXWS2Ejb3JAXRPCClientBeanToJavaBean.getAnnuityHolder(result);
    }

    @Override
    public IContact updateContact(IContact contact) throws ServerInternalErrorException, InvalidArgumentException {
        Contact result = null;
        try {
            Response<UpdateContactResponse> response = this.webService.updateContactAsync(JavaBeanToJAXWS2Ejb3JAXRPCClientBean.getContact(contact));
            this.waitAndCheckForValidResponse(response, contact);
            result = ((UpdateContactResponse)response.get()).getUpdateContactReturn();
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.processCommonException(cause);
        }
        return JAXWS2Ejb3JAXRPCClientBeanToJavaBean.getContact(result);
    }

    @Override
    public IPayor updatePayor(IPayor payor) throws ServerInternalErrorException, InvalidArgumentException {
        Payor result = null;
        try {
            Response<UpdatePayorResponse> response = this.webService.updatePayorAsync(JavaBeanToJAXWS2Ejb3JAXRPCClientBean.getPayor(payor));
            this.waitAndCheckForValidResponse(response, payor);
            result = ((UpdatePayorResponse)response.get()).getUpdatePayorReturn();
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.processCommonException(cause);
        }
        return JAXWS2Ejb3JAXRPCClientBeanToJavaBean.getPayor(result);
    }

    @Override
    public IPayout updatePayout(IPayout payout) throws ServerInternalErrorException, InvalidArgumentException {
        PayoutValueObject result = null;
        try {
            PayoutValueObject in = new PayoutValueObject();
            in.setPayout(JavaBeanToJAXWS2Ejb3JAXRPCClientBean.getPayout(payout));
            Response<UpdatePayoutResponse> response = this.webService.updatePayoutAsync(in);
            this.waitAndCheckForValidResponse(response, payout);
            result = ((UpdatePayoutResponse)response.get()).getUpdatePayoutReturn();
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.processCommonException(cause);
        }
        return result == null ? null : JAXWS2Ejb3JAXRPCClientBeanToJavaBean.getPayout(result.getPayoutData());
    }

    private void waitForResponse(Response resp, Configrable<String, String> configrable) throws InterruptedException {
        long waitCount;
        long waitTime;
        try {
            waitTime = Long.parseLong((String)configrable.getConfiguration().getParameterValue((Object)"waitTime"));
            waitCount = Long.parseLong((String)configrable.getConfiguration().getParameterValue((Object)"waitCount"));
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid Configuration.  WaitTime or WaitCount are not valid values.current values are: waitTime:" + (String)configrable.getConfiguration().getParameterValue((Object)"waitTime") + " and waitCount: " + (String)configrable.getConfiguration().getParameterValue((Object)"waitCount"));
        }
        for (long cntr = 0L; cntr <= waitCount; ++cntr) {
            if (resp.isDone()) {
                return;
            }
            this.logger.fine("waiting for response ... wait count: " + cntr);
            Thread.sleep(waitTime);
        }
    }

    private void waitAndCheckForValidResponse(Response response, Configrable<String, String> configrable) throws ServerInternalErrorException, InterruptedException, ExecutionException {
        this.waitForResponse(response, configrable);
        if (response.isDone()) {
            if (response.get() == null) {
                throw new ServerInternalErrorException("The server responded with a null object.  Expected either an error or a non-null object.");
            }
        } else {
            throw new ServerInternalErrorException("The server did not respond in in the expected time.wait values are: waitTime:" + (String)configrable.getConfiguration().getParameterValue((Object)"waitTime") + " and waitCount: " + (String)configrable.getConfiguration().getParameterValue((Object)"waitCount") + " was waiting for Response class: " + response.getClass().getName());
        }
    }

    private void processEntityNotFoundException(Throwable e) throws EntityNotFoundException {
        if (e instanceof EntityNotFoundException_Exception) {
            throw new EntityNotFoundException(e);
        }
    }

    private void processEntityAlreadyExistsException(Throwable e) throws EntityAlreadyExistsException {
        if (e instanceof EntityAlreadyExistsException_Exception) {
            throw new EntityAlreadyExistsException(e);
        }
    }

    private void processInterruptedException(InterruptedException e) {
        this.logger.log(Level.WARNING, "Got an unexpected InterruptedException while waiting for a response object");
        throw new RuntimeException("Got an unexpected InterruptedException while waiting for a response object. error " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
    }

    private void processCommonException(Throwable e) throws ServerInternalErrorException, InvalidArgumentException {
        if (e instanceof InvalidArgumentException_Exception) {
            throw new InvalidArgumentException(e);
        }
        if (e instanceof ServerBusinessModuleException_Exception) {
            throw new ServerBusinessModuleException(e);
        }
        if (e instanceof ServerPersistenceModuleException_Exception) {
            throw new ServerPersistenceModuleException(e);
        }
        this.logger.log(Level.INFO, "unable to detect the type of the exception.  Returning a RuntimeException.  Error is: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        e.printStackTrace();
        throw new RuntimeException("Unexpected error. Erros is: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
    }

    private AnnuityValueObject getAnnuityValueObject(IAnnuity annuity) {
        if (annuity == null) {
            return null;
        }
        AnnuityValueObject out = new AnnuityValueObject();
        out.setAnnuity(JavaBeanToJAXWS2Ejb3JAXRPCClientBean.getAnnuity(annuity));
        return out;
    }
}

