/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.executionunit;

import com.ibm.wssvt.acme.annuity.common.bean.IAnnuity;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.AbastractAnnuityExecutionUnit;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.common.executionunit.ExecutionUnitVerificationException;

public class FindAnnuityByIdEU
extends AbastractAnnuityExecutionUnit {
    private static final long serialVersionUID = 5751982103363852382L;
    private static final String ID = "id";

    public void execute() {
        try {
            IAnnuity results;
            String id = (String)this.getConfiguration().getParameterValue((Object)ID);
            IAnnuity annuity = this.getAnnuityBeansFactory().createAnnuity();
            annuity.setId(id);
            annuity.setConfiguration(this.getConfiguration());
            try {
                results = this.getServerAdapter().findAnnuityById(annuity);
            }
            catch (EntityNotFoundException e) {
                throw new ExecutionUnitVerificationException("The FindAnnuityByIdEU failed to find an annuity with provided id: " + id + " e: " + (Object)((Object)e));
            }
            this.verifySuccess(results);
        }
        catch (Exception e) {
            this.getExecutionUnitEvent().addException(e);
        }
    }

    private void verifySuccess(IAnnuity annuity) throws ExecutionUnitVerificationException {
        if (annuity == null) {
            throw new ExecutionUnitVerificationException("The FindAnnuityByIdEU failed to find an annuity.  retrned null value.");
        }
        if (!((String)annuity.getId()).equals(this.getConfiguration().getParameterValue((Object)ID))) {
            throw new ExecutionUnitVerificationException("The FindAnnuityByIdEU returned a different object with with different id!expected id: " + (String)this.getConfiguration().getParameterValue((Object)ID) + " but was: " + (String)annuity.getId());
        }
    }
}

