/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.executionunit;

import com.ibm.wssvt.acme.annuity.common.bean.AnnuityHolderCategory;
import com.ibm.wssvt.acme.annuity.common.bean.ContactType;
import com.ibm.wssvt.acme.annuity.common.bean.IAddress;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.bean.IContact;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.AbastractAnnuityExecutionUnit;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.BasicExecutionUnitLibrarry;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.ExecutionUnitVerificationHelper;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.common.adapter.ServerAdapterCommunicationException;
import com.ibm.wssvt.acme.common.executionunit.ExecutionUnitVerificationException;
import com.ibm.wssvt.acme.common.executionunit.IExecutionUnit;
import com.ibm.wssvt.acme.common.executionunit.ISingleRunExecutionUnit;
import com.ibm.wssvt.acme.common.executionunit.ISingleThreadedExecutionUnit;
import com.ibm.wssvt.acme.common.executionunit.InvalidExecutionUnitParameterException;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.rmi.RemoteException;
import java.util.Date;

public class PopulateDatabaseWithHolderEU
extends AbastractAnnuityExecutionUnit
implements ISingleThreadedExecutionUnit,
ISingleRunExecutionUnit {
    private static final long serialVersionUID = -5421478878181609584L;
    private int startId;
    private boolean useCharPrefixID = true;
    private int numberOfHolderEntries;
    boolean enableVerify = true;
    boolean randomizeSelection = true;
    private AcmeLogger logger = null;

    public void execute() {
        this.logger = this.getLogger(((Object)((Object)this)).getClass().getName());
        try {
            this.setAndVerifyScenarioParams();
        }
        catch (Exception e) {
            this.logger.warning("Invalid scenario parameters for scenario description:" + this.getDescription() + "  Error is: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.info("Starting id=" + this.startId + " Count=" + this.numberOfHolderEntries);
        IAnnuityHolder annuityHolder = null;
        IContact contact = null;
        Long startTime = System.currentTimeMillis();
        for (int i = this.startId; i < this.startId + this.numberOfHolderEntries; ++i) {
            String id = "" + i;
            if (i % 10 == 0 && i != this.startId) {
                this.logger.info("10 holders+children created in:" + (System.currentTimeMillis() - startTime) + " ms. " + 1000000L / (System.currentTimeMillis() - startTime) + " Holders/sec." + (i - this.startId) + " holders created.");
                startTime = System.currentTimeMillis();
            }
            try {
                contact = this.getContact(id);
                contact.setConfiguration(this.getConfiguration());
                contact = this.getServerAdapter().createContact(contact);
            }
            catch (Exception e) {
                this.logger.warning("Failed to create contact. Error is: " + e);
                this.getExecutionUnitEvent().addException(e);
                return;
            }
            try {
                if (this.enableVerify) {
                    this.verifyContact(contact);
                }
            }
            catch (Exception e) {
                this.logger.warning("Failed to verify create contact. Error is: " + e);
                this.getExecutionUnitEvent().addException(e);
            }
            try {
                annuityHolder = this.getAnnuityHolder(id);
                annuityHolder.setContact(contact);
                annuityHolder.setConfiguration(this.getConfiguration());
                this.logger.fine("ID:" + id + " Saving annuityHolder");
                annuityHolder = this.getServerAdapter().createAnnuityHolder(annuityHolder);
            }
            catch (Exception e) {
                this.logger.warning("Failed to create AnnuityHolder. Error is: " + e);
                this.getExecutionUnitEvent().addException(e);
                return;
            }
            try {
                if (!this.enableVerify) continue;
                this.verifyHolder(annuityHolder);
                continue;
            }
            catch (Exception e) {
                this.logger.warning("Failed to verify create AnnuityHolder. Error is: " + e);
                this.getExecutionUnitEvent().addException(e);
            }
        }
    }

    private void setAndVerifyScenarioParams() throws InvalidExecutionUnitParameterException {
        String START_ID_KEY = "startId";
        String NUMBER_OF_HOLDER_ENTRIES_KEY = "numberOfHolders";
        String ENABLE_VERIFY_KEY = "enableVerify";
        String RANDOMIZE_SELECTION_KEY = "randomizeSelection";
        String USE_ID_CHAR_PREFIX = "useIdCharPrefix";
        this.startId = this.getParameterValueInt("startId");
        this.numberOfHolderEntries = this.getParameterValueInt("numberOfHolders");
        if (this.startId <= 0) {
            throw new InvalidExecutionUnitParameterException("startId is less or equal to 0.  Invalid value for scenario with description: " + this.getDescription() + ".  Value must be one or more.");
        }
        if (this.numberOfHolderEntries <= 0) {
            throw new InvalidExecutionUnitParameterException("numberOfHolders is less or equal to 0.  Invalid value for scenario with description: " + this.getDescription() + ".  Value must be one or more.");
        }
        try {
            this.useCharPrefixID = this.getParameterValueBoolean("useIdCharPrefix");
        }
        catch (InvalidExecutionUnitParameterException e) {
            this.logger.warning("the attribute: useIdCharPrefix is missing for scenario: " + this.getDescription() + ".  Setting the default to true.");
            this.useCharPrefixID = true;
        }
        try {
            this.enableVerify = this.getParameterValueBoolean("enableVerify");
        }
        catch (InvalidExecutionUnitParameterException e) {
            this.logger.warning("the attribute: enableVerify is missing for scenario: " + this.getDescription() + ".  Setting the default to true.");
            this.enableVerify = true;
        }
        try {
            this.randomizeSelection = this.getParameterValueBoolean("randomizeSelection");
        }
        catch (InvalidExecutionUnitParameterException e) {
            this.logger.warning("the attribute: randomizeSelection is missing for scenario: " + this.getDescription() + ".  Setting the default to true.");
            this.randomizeSelection = true;
        }
    }

    private void verifyHolder(IAnnuityHolder annuityHolder) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        IAnnuityHolder Holdresult = this.getAnnuityBeansFactory().createAnnuityHolder();
        Holdresult.setId(annuityHolder.getId());
        Holdresult.setConfiguration(this.getConfiguration());
        Holdresult = this.getServerAdapter().findHolderById(Holdresult);
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, annuityHolder, Holdresult, "Annuity Holder from Client is not equal to DB value", "Mismatch was found.");
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, annuityHolder.getContact(), Holdresult.getContact(), "Annuity Holder Contact from Client is not equal to DB value", "Mismatch was found.");
    }

    private void verifyContact(IContact contact) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        IContact conresult = this.getAnnuityBeansFactory().createContact();
        conresult.setId(contact.getId());
        conresult.setConfiguration(this.getConfiguration());
        conresult = this.getServerAdapter().findContactById(conresult);
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, contact, conresult, "Contact from Client is not equal to DB value", "Mismatch was found.");
    }

    private IContact getContact(String sContactId) {
        IContact contact = BasicExecutionUnitLibrarry.getContact(this.getAnnuityBeansFactory());
        if (this.useCharPrefixID) {
            contact.setId("C" + sContactId);
        } else {
            contact.setId(sContactId);
        }
        contact.setEmail(sContactId + "@domain.com");
        contact.setPhone(sContactId + "-" + sContactId + "-" + sContactId);
        contact.setContactType(this.getRandomEnum(ContactType.class));
        IAddress address = BasicExecutionUnitLibrarry.getAddress(this.getAnnuityBeansFactory());
        address.setLine1(sContactId + " Main Street");
        address.setLine2("APT # " + sContactId);
        address.setCity("Austin");
        address.setState("Texas");
        address.setZipCode("78758");
        address.setCountry("USA");
        contact.setAddress(address);
        return contact;
    }

    private IAnnuityHolder getAnnuityHolder(String sHolderId) {
        IAnnuityHolder annuityHolder = BasicExecutionUnitLibrarry.getAnnuityHolder(this.getAnnuityBeansFactory());
        annuityHolder.setId(sHolderId);
        annuityHolder.setDateOfBirth(new Date());
        annuityHolder.setFirstName(sHolderId + " FirstName");
        annuityHolder.setLastName(sHolderId + " LastName");
        annuityHolder.setGovernmentId(sHolderId + "-111-22-3333");
        annuityHolder.setLastUpdateDate(new Date());
        annuityHolder.setTimeOfBirth(new Date());
        annuityHolder.setCategory(this.getRandomEnum(AnnuityHolderCategory.class));
        return annuityHolder;
    }
}

