/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.executionunit;

import com.ibm.wssvt.acme.annuity.common.client.executionunit.AbastractAnnuityExecutionUnit;
import com.ibm.wssvt.acme.common.executionunit.InvalidExecutionUnitParameterException;
import com.ibm.wssvt.acme.common.log.AcmeLogger;

public class ReturnExceptionEU
extends AbastractAnnuityExecutionUnit {
    private static final long serialVersionUID = 5751982103363852382L;

    public void execute() {
        try {
            AcmeLogger logger = this.getLogger(((Object)((Object)this)).getClass().getName());
            String className = (String)this.getConfiguration().getParameterValue((Object)"exceptionClassName");
            logger.fine("exceptionClassName is: " + className);
            if (className == null) {
                throw new InvalidExecutionUnitParameterException("The exceptionClassName param was null " + logger.getAllLogs());
            }
            if (className.trim().length() == 0) {
                throw new InvalidExecutionUnitParameterException("The exceptionClassName param was empty " + logger.getAllLogs());
            }
            logger.fine("className is: " + className);
            Class<?> exClass = null;
            try {
                logger.fine("ready to load the class");
                exClass = Thread.currentThread().getContextClassLoader().loadClass(className);
                logger.fine("class loaded");
            }
            catch (ClassNotFoundException e) {
                String msg = "Failed to load the class: " + className + ".  Error: " + e.getMessage() + logger.getAllLogs();
                logger.info(msg);
                throw new InvalidExecutionUnitParameterException(msg, (Throwable)e);
            }
            Exception exception = null;
            try {
                logger.info("ready to get newInstance");
                exception = (Exception)exClass.newInstance();
                logger.info("got newInstance");
            }
            catch (IllegalAccessException e) {
                String msg = "Failed to create a new instance from the class: " + className + ".  Error: " + e.getMessage() + logger.getAllLogs();
                logger.info(msg);
                throw new InvalidExecutionUnitParameterException(msg, (Throwable)e);
            }
            catch (InstantiationException e) {
                String msg = "Failed to create a new instance from the class: " + className + ".  Error: " + e.getMessage() + logger.getAllLogs();
                logger.info(msg);
                throw new InvalidExecutionUnitParameterException(msg, (Throwable)e);
            }
            logger.fine("now throwing the exception: " + exception + " This is not an error, as this EU is designed to return the exception!");
            throw exception;
        }
        catch (Exception e) {
            this.getExecutionUnitEvent().addException(e);
            return;
        }
    }
}

