/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.executionunit;

import com.ibm.wssvt.acme.annuity.common.bean.IAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.bean.IEquityAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IFixedAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IPayor;
import com.ibm.wssvt.acme.annuity.common.bean.IPayout;
import com.ibm.wssvt.acme.annuity.common.bean.IRider;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.AbastractAnnuityExecutionUnit;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.BasicExecutionUnitLibrarry;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.ExecutionUnitVerificationHelper;
import com.ibm.wssvt.acme.annuity.common.exception.EntityAlreadyExistsException;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.annuity.common.util.ServerExceptionMapper;
import com.ibm.wssvt.acme.annuity.common.util.ServerExceptionType;
import com.ibm.wssvt.acme.common.adapter.ServerAdapterCommunicationException;
import com.ibm.wssvt.acme.common.executionunit.ExecutionUnitVerificationException;
import com.ibm.wssvt.acme.common.executionunit.IExecutionUnit;
import com.ibm.wssvt.acme.common.executionunit.InvalidExecutionUnitParameterException;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;

public class UpdateAnnuityWithAllChildrenEU
extends AbastractAnnuityExecutionUnit {
    private static final long serialVersionUID = -8978758038714550844L;
    private static final String START_HOLDER_ID = "startHolderId";
    private static final String END_HOLDER_ID = "endHolderId";
    private static final String MAX_THRESHOLD = "maximumThreshold";
    private static final String ENABLE_VERIFY_KEY = "enableVerify";
    private int startHolderId;
    private int endHolderId;
    private int holderRange;
    private int maximumThreshold;
    private boolean enableVerify = true;
    private int retryThinkTime = 5000;
    private AcmeLogger logger;

    public void execute() {
        int threshold = 0;
        try {
            this.setScenarioVariables();
        }
        catch (Exception e) {
            this.logger.warning("Invalid scenario parameters for scenario description:" + this.getDescription() + "  Error is: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        String randomHolderId = "" + (this.startHolderId + this.getRandomInteger(0, this.holderRange));
        this.logger.fine("Got the random holder ID --- " + randomHolderId);
        this.logger.fine("Find the holder from existing database");
        IAnnuityHolder holder = null;
        try {
            holder = this.findAnnuityHolderById(randomHolderId);
            if (holder == null) {
                throw new ExecutionUnitVerificationException("Expected to find an Annuity Holder for id: " + randomHolderId + " but found null");
            }
            if (!((String)holder.getId()).equals(randomHolderId)) {
                throw new ExecutionUnitVerificationException("Found an Annuity Holder for id: " + randomHolderId + " but the object id is different! - found id: " + (String)holder.getId());
            }
        }
        catch (Exception e) {
            this.logger.warning("Failed to find holder. ID - " + randomHolderId + " Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.fine("Getting list of Annuity from AnnuityHolder");
        List<IAnnuity> annuities = null;
        try {
            annuities = this.getAnnuities(holder);
            if (this.logger.getLogger().isLoggable(Level.FINE)) {
                String annIds = "";
                for (IAnnuity ann : annuities) {
                    annIds = annIds + (String)ann.getId() + " : ";
                }
                this.logger.fine("Got the the annuity IDs here --- " + annIds);
            }
        }
        catch (Exception e) {
            this.logger.warning("Failed to get list of annuities. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        IAnnuity resultAnnuity = null;
        this.logger.fine("Annuity size is " + annuities.size());
        for (IAnnuity annuity : annuities) {
            this.logger.fine("attempting to add riders to annuity");
            ArrayList<String> riders = new ArrayList<String>();
            this.logger.fine("Updating Annuity with Rider");
            while (threshold <= this.maximumThreshold) {
                try {
                    riders = new ArrayList();
                    resultAnnuity = this.addRidersToAnnuity(annuity, riders);
                    break;
                }
                catch (Exception e) {
                    threshold = this.recoverableExceptionCheck(e, threshold, annuity);
                    if (threshold == 0) {
                        this.logger.severe("Failed to update annuity with rider. ID:" + (String)annuity.getId() + " Error: " + e);
                        this.getExecutionUnitEvent().addException(e);
                        return;
                    }
                    try {
                        annuity.setConfiguration(this.getConfiguration());
                        annuity = this.getServerAdapter().findAnnuityById(annuity);
                    }
                    catch (Exception e1) {
                        this.logger.severe("After an optomistic locking exception or deadlock on an annuity, an exception was thrown while trying to retrieve the persisted annuity");
                        this.getExecutionUnitEvent().addException(e1);
                        return;
                    }
                }
            }
            threshold = 0;
            if (this.enableVerify) {
                this.logger.fine("Verifying Annuity with Rider");
                try {
                    this.verifyAnnuityValues(annuity, resultAnnuity);
                }
                catch (Exception e) {
                    this.logger.warning("Failed to verify update annuity with rider. Error: " + e);
                    this.getExecutionUnitEvent().addException(e);
                    return;
                }
            }
            annuity = resultAnnuity;
            this.logger.fine("Attempting to update Riders");
            while (threshold <= this.maximumThreshold) {
                try {
                    resultAnnuity = this.updateAnnuityRiderRule(annuity, riders.get(0));
                    break;
                }
                catch (Exception e) {
                    threshold = this.recoverableExceptionCheck(e, threshold, annuity);
                    if (threshold == 0) {
                        this.logger.severe("Failed to update annuity with rider. ID:" + (String)annuity.getId() + " Error: " + e);
                        this.getExecutionUnitEvent().addException(e);
                        return;
                    }
                    try {
                        annuity.setConfiguration(this.getConfiguration());
                        annuity = this.getServerAdapter().findAnnuityById(annuity);
                    }
                    catch (Exception e1) {
                        this.logger.severe("After an optomistic locking exception or deadlock on an annuity, an exception was thrown while trying to retrieve the persisted annuity");
                        this.getExecutionUnitEvent().addException(e1);
                        return;
                    }
                }
            }
            threshold = 0;
            if (this.enableVerify) {
                this.logger.fine("Verifying Annuity with Rider");
                try {
                    this.verifyAnnuityValues(annuity, resultAnnuity);
                }
                catch (Exception e) {
                    this.logger.warning("Failed to verify update annuity with rider. Error: " + e);
                    this.getExecutionUnitEvent().addException(e);
                    return;
                }
            }
            annuity = resultAnnuity;
            this.logger.fine("Attempting to remove riders from Annuity");
            while (threshold <= this.maximumThreshold) {
                try {
                    annuity = resultAnnuity = this.removeRiderFromAnnuity(annuity, riders);
                    break;
                }
                catch (Exception e) {
                    threshold = this.recoverableExceptionCheck(e, threshold, annuity);
                    if (threshold == 0) {
                        this.logger.severe("Failed to update annuity with rider. ID:" + (String)annuity.getId() + " Error: " + e);
                        this.getExecutionUnitEvent().addException(e);
                        return;
                    }
                    try {
                        annuity.setConfiguration(this.getConfiguration());
                        annuity = this.getServerAdapter().findAnnuityById(annuity);
                    }
                    catch (Exception e1) {
                        this.logger.severe("After an optomistic locking exception or deadlock on an annuity, an exception was thrown while trying to retrieve the persisted annuity");
                        this.getExecutionUnitEvent().addException(e1);
                        return;
                    }
                }
            }
            threshold = 0;
            if (this.enableVerify) {
                this.logger.fine("Verifying Annuity with Rider");
                try {
                    this.verifyAnnuityValues(annuity, resultAnnuity);
                }
                catch (Exception e) {
                    this.logger.warning("Failed to verify update annuity. Error: " + e);
                    this.getExecutionUnitEvent().addException(e);
                    return;
                }
            }
            annuity = resultAnnuity;
            this.logger.fine("Attempting to add payouts to annuity");
            ArrayList<String> payouts = new ArrayList<String>();
            while (threshold <= this.maximumThreshold) {
                try {
                    payouts = new ArrayList();
                    resultAnnuity = this.addPayoutsToAnnuity(annuity, payouts);
                    break;
                }
                catch (Exception e) {
                    threshold = this.recoverableExceptionCheck(e, threshold, annuity);
                    if (threshold == 0) {
                        this.logger.severe("Failed to update annuity with payout. ID:" + (String)annuity.getId() + " Error: " + e);
                        this.getExecutionUnitEvent().addException(e);
                        return;
                    }
                    try {
                        annuity.setConfiguration(this.getConfiguration());
                        annuity = this.getServerAdapter().findAnnuityById(annuity);
                    }
                    catch (Exception e1) {
                        this.logger.severe("After an optomistic locking exception or deadlock on an annuity, an exception was thrown while trying to retrieve the persisted annuity");
                        this.getExecutionUnitEvent().addException(e1);
                        return;
                    }
                }
            }
            threshold = 0;
            if (this.enableVerify) {
                this.logger.fine("Verifying Annuity with Rider");
                try {
                    this.logger.fine("as = " + annuity.getPayors().size() + "ar = " + resultAnnuity.getPayors().size());
                    this.verifyAnnuityValues(annuity, resultAnnuity);
                }
                catch (Exception e) {
                    this.logger.warning("Failed to verify update annuity. Error: " + e);
                    this.getExecutionUnitEvent().addException(e);
                    return;
                }
            }
            annuity = resultAnnuity;
            this.logger.fine("Attempting to update payouts");
            while (threshold <= this.maximumThreshold) {
                try {
                    resultAnnuity = this.updateAnnuityPayout(annuity, payouts.get(0));
                    break;
                }
                catch (Exception e) {
                    threshold = this.recoverableExceptionCheck(e, threshold, annuity);
                    if (threshold == 0) {
                        this.logger.severe("Failed to update annuity with payout. ID:" + (String)annuity.getId() + " Error: " + e);
                        this.getExecutionUnitEvent().addException(e);
                        return;
                    }
                    try {
                        annuity.setConfiguration(this.getConfiguration());
                        annuity = this.getServerAdapter().findAnnuityById(annuity);
                    }
                    catch (Exception e1) {
                        this.logger.severe("After an optomistic locking exception or deadlock on an annuity, an exception was thrown while trying to retrieve the persisted annuity");
                        this.getExecutionUnitEvent().addException(e1);
                        return;
                    }
                }
            }
            threshold = 0;
            if (this.enableVerify) {
                this.logger.fine("Verifying Annuity with Rider");
                try {
                    this.verifyAnnuityValues(annuity, resultAnnuity);
                }
                catch (Exception e) {
                    this.logger.warning("Failed to verify update annuity. Error: " + e);
                    this.getExecutionUnitEvent().addException(e);
                    return;
                }
            }
            annuity = resultAnnuity;
            this.logger.fine("Attempting to delete payouts");
            for (String payoutId : payouts) {
                while (threshold <= this.maximumThreshold) {
                    try {
                        resultAnnuity = this.removeAnnuityPayout(annuity, payoutId);
                        break;
                    }
                    catch (Exception e) {
                        threshold = this.recoverableExceptionCheck(e, threshold, annuity);
                        if (threshold == 0) {
                            this.logger.severe("Failed to update annuity with payout. ID:" + (String)annuity.getId() + " Error: " + e);
                            this.getExecutionUnitEvent().addException(e);
                            return;
                        }
                        try {
                            annuity.setConfiguration(this.getConfiguration());
                            annuity = this.getServerAdapter().findAnnuityById(annuity);
                        }
                        catch (Exception e1) {
                            this.logger.severe("After an optomistic locking exception or deadlock on an annuity, an exception was thrown while trying to retrieve the persisted annuity");
                            this.getExecutionUnitEvent().addException(e1);
                            return;
                        }
                    }
                }
                threshold = 0;
                if (this.enableVerify) {
                    this.logger.fine("Verifying Annuity with Rider");
                    try {
                        this.verifyAnnuityValues(annuity, resultAnnuity);
                    }
                    catch (Exception e) {
                        this.logger.warning("Failed to verify update annuity. Error: " + e);
                        this.getExecutionUnitEvent().addException(e);
                        return;
                    }
                }
                annuity = resultAnnuity;
            }
            this.logger.fine("Attempting to add payors to annuity");
            ArrayList<String> payors = new ArrayList<String>();
            while (threshold <= this.maximumThreshold) {
                try {
                    payors = new ArrayList();
                    resultAnnuity = this.addPayorToAnnuity(annuity, payors);
                    break;
                }
                catch (Exception e) {
                    threshold = this.recoverableExceptionCheck(e, threshold, annuity);
                    if (threshold == 0) {
                        this.logger.severe("Failed to update annuity with payor. ID:" + (String)annuity.getId() + " Error: " + e);
                        this.getExecutionUnitEvent().addException(e);
                        return;
                    }
                    try {
                        annuity.setConfiguration(this.getConfiguration());
                        annuity = this.getServerAdapter().findAnnuityById(annuity);
                    }
                    catch (Exception e1) {
                        this.logger.severe("After an optomistic locking exception or deadlock on an annuity, an exception was thrown while trying to retrieve the persisted annuity");
                        this.getExecutionUnitEvent().addException(e1);
                        return;
                    }
                }
            }
            threshold = 0;
            if (this.enableVerify) {
                this.logger.fine("Verifying Annuity with Rider");
                try {
                    this.verifyAnnuityValues(annuity, resultAnnuity);
                }
                catch (Exception e) {
                    this.logger.warning("Failed to verify update annuity. Error: " + e);
                    this.getExecutionUnitEvent().addException(e);
                    return;
                }
            }
            annuity = resultAnnuity;
            this.logger.fine("Attempting to update payors");
            while (threshold <= this.maximumThreshold) {
                try {
                    resultAnnuity = this.updateAnnuityPayor(annuity, payors.get(0));
                    break;
                }
                catch (Exception e) {
                    threshold = this.recoverableExceptionCheck(e, threshold, annuity);
                    if (threshold == 0) {
                        this.logger.severe("Failed to update annuity with payor. ID:" + (String)annuity.getId() + " Error: " + e);
                        this.getExecutionUnitEvent().addException(e);
                        return;
                    }
                    try {
                        annuity.setConfiguration(this.getConfiguration());
                        annuity = this.getServerAdapter().findAnnuityById(annuity);
                    }
                    catch (Exception e1) {
                        this.logger.severe("After an optomistic locking exception or deadlock on an annuity, an exception was thrown while trying to retrieve the persisted annuity");
                        this.getExecutionUnitEvent().addException(e1);
                        return;
                    }
                }
            }
            threshold = 0;
            if (this.enableVerify) {
                this.logger.fine("Verifying Annuity with Rider");
                try {
                    this.verifyAnnuityValues(annuity, resultAnnuity);
                }
                catch (Exception e) {
                    this.logger.warning("Failed to verify update annuity. Error: " + e);
                    this.getExecutionUnitEvent().addException(e);
                    return;
                }
            }
            annuity = resultAnnuity;
            this.logger.fine("Attempting to delete payors");
            for (String payorId : payors) {
                while (threshold <= this.maximumThreshold) {
                    try {
                        resultAnnuity = this.removePayorFromAnnuity(annuity, payorId);
                        break;
                    }
                    catch (Exception e) {
                        threshold = this.recoverableExceptionCheck(e, threshold, annuity);
                        if (threshold == 0) {
                            this.logger.severe("Failed to remove payor from annuity. ID:" + (String)annuity.getId() + " Error: " + e);
                            this.getExecutionUnitEvent().addException(e);
                            return;
                        }
                        try {
                            annuity.setConfiguration(this.getConfiguration());
                            annuity = this.getServerAdapter().findAnnuityById(annuity);
                        }
                        catch (Exception e1) {
                            this.logger.severe("After an optomistic locking exception or deadlock on an annuity, an exception was thrown while trying to retrieve the persisted annuity");
                            this.getExecutionUnitEvent().addException(e1);
                            return;
                        }
                    }
                }
                threshold = 0;
                if (this.enableVerify) {
                    this.logger.fine("Verifying Annuity with Rider");
                    try {
                        this.verifyAnnuityValues(annuity, resultAnnuity);
                    }
                    catch (Exception e) {
                        this.logger.warning("Failed to verify update annuity. Error: " + e);
                        this.getExecutionUnitEvent().addException(e);
                        return;
                    }
                }
                annuity = resultAnnuity;
            }
            this.logger.fine("finish12");
            this.logger.fine("Attempting to update annuity fields");
            while (threshold <= this.maximumThreshold) {
                try {
                    resultAnnuity = this.updateAnnuityAlone(annuity);
                    break;
                }
                catch (Exception e) {
                    threshold = this.recoverableExceptionCheck(e, threshold, annuity);
                    if (threshold == 0) {
                        this.logger.severe("Failed to update just the annuity. ID:" + (String)annuity.getId() + " Error: " + e);
                        this.getExecutionUnitEvent().addException(e);
                        return;
                    }
                    try {
                        annuity.setConfiguration(this.getConfiguration());
                        annuity = this.getServerAdapter().findAnnuityById(annuity);
                    }
                    catch (Exception e1) {
                        this.logger.severe("After an optomistic locking exception or deadlock on an annuity, an exception was thrown while trying to retrieve the persisted annuity");
                        this.getExecutionUnitEvent().addException(e1);
                        return;
                    }
                }
            }
            threshold = 0;
            if (this.enableVerify) {
                this.logger.fine("Verifying Annuity with Rider");
                try {
                    this.verifyAnnuityValues(annuity, resultAnnuity);
                }
                catch (Exception e) {
                    this.logger.warning("Failed to verify update annuity. Error: " + e);
                    this.getExecutionUnitEvent().addException(e);
                    return;
                }
            }
            annuity = resultAnnuity;
        }
    }

    private void setScenarioVariables() throws InvalidExecutionUnitParameterException {
        this.logger = this.getLogger(((Object)((Object)this)).getClass().getName());
        this.startHolderId = this.getParameterValueInt(START_HOLDER_ID);
        this.endHolderId = this.getParameterValueInt(END_HOLDER_ID);
        if (this.startHolderId <= 0) {
            throw new InvalidExecutionUnitParameterException("startHolderId is less or equal to 0.  Invalid value for scenario with description: " + this.getDescription() + ".  Value must be one or more.");
        }
        if (this.endHolderId <= 0) {
            throw new InvalidExecutionUnitParameterException("endHolderId is less or equal to 0.  Invalid value for scenario with description: " + this.getDescription() + ".  Value must be one or more.");
        }
        this.holderRange = this.endHolderId - this.startHolderId;
        try {
            this.maximumThreshold = this.getParameterValueInt(MAX_THRESHOLD);
        }
        catch (Exception e) {
            this.logger.fine("maximumThreshold parameter not specified, using default");
            this.maximumThreshold = 2;
        }
        try {
            this.enableVerify = this.getParameterValueBoolean(ENABLE_VERIFY_KEY);
        }
        catch (Exception e) {
            this.logger.warning("enableVerify parameter is not set, using default true.");
            this.enableVerify = true;
        }
    }

    private IAnnuity updateAnnuityAlone(IAnnuity annuity) throws EntityNotFoundException, EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        if (annuity instanceof IEquityAnnuity) {
            return this.updateEquityAnnuity((IEquityAnnuity)annuity);
        }
        if (annuity instanceof IFixedAnnuity) {
            return this.updateFixedAnnuity((IFixedAnnuity)annuity);
        }
        return this.updateBasicAnnuity(annuity);
    }

    private IAnnuity updateBasicAnnuity(IAnnuity annuity) throws EntityNotFoundException, EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        annuity.setAmount(new Double(111111.0));
        annuity.setLastPaidAmt(new Double(1111.0));
        annuity.setConfiguration(this.getConfiguration());
        return this.getServerAdapter().updateAnnuity(annuity);
    }

    private IEquityAnnuity updateEquityAnnuity(IEquityAnnuity annuity) throws EntityNotFoundException, EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        annuity.setAmount(new Double(111111.0));
        annuity.setLastPaidAmt(new Double(1111.0));
        annuity.setFundNames(this.getUpdatedString(annuity.getFundNames()));
        annuity.setIndexRate(new Double(0.88));
        annuity.setConfiguration(this.getConfiguration());
        return (IEquityAnnuity)this.getServerAdapter().updateAnnuity(annuity);
    }

    private IFixedAnnuity updateFixedAnnuity(IFixedAnnuity annuity) throws EntityNotFoundException, EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        annuity.setAmount(new Double(111111.0));
        annuity.setLastPaidAmt(new Double(1111.0));
        annuity.setRate(new Double(0.88));
        annuity.setConfiguration(this.getConfiguration());
        return (IFixedAnnuity)this.getServerAdapter().updateAnnuity(annuity);
    }

    private IPayor getAnnuityPayor(IAnnuity annuity, String payorId) {
        for (int i = 0; i < annuity.getPayors().size(); ++i) {
            if (!((String)annuity.getPayors().get(i).getId()).equals(payorId)) continue;
            return annuity.getPayors().get(i);
        }
        return null;
    }

    private boolean removeAnnuityPayorHelp(IAnnuity annuity, String payorId) {
        for (int i = 0; i < annuity.getPayors().size(); ++i) {
            if (!((String)annuity.getPayors().get(i).getId()).equals(payorId)) continue;
            annuity.getPayors().remove(i);
            return true;
        }
        return false;
    }

    private IAnnuity removePayorFromAnnuity(IAnnuity annuity, String payorId) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        annuity.setConfiguration(this.getConfiguration());
        IAnnuity annuityBug = this.getServerAdapter().findAnnuityById(annuity);
        if (annuityBug.getPayors() == null || annuityBug.getPayors().size() < 1) {
            throw new ExecutionUnitVerificationException("Attempting to update a payor from annuity, but payors is either null or has 0 elements");
        }
        IPayor payor = this.getAnnuityPayor(annuity, payorId);
        if (!this.removeAnnuityPayorHelp(annuity, payorId)) {
            throw new ExecutionUnitVerificationException("The payor ID does not exist after it was added this is a possible defect");
        }
        annuity.setConfiguration(this.getConfiguration());
        IAnnuity resultAnnuity = this.getServerAdapter().updateAnnuity(annuity);
        payor.setConfiguration(this.getConfiguration());
        this.getServerAdapter().deletePayor(payor);
        return resultAnnuity;
    }

    private IAnnuity updateAnnuityPayor(IAnnuity annuity, String payorId) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        IAnnuity annuityBug = annuity;
        annuityBug.setConfiguration(this.getConfiguration());
        annuityBug = this.getServerAdapter().findAnnuityById(annuityBug);
        if (annuityBug.getPayors() == null || annuityBug.getPayors().size() < 1) {
            throw new ExecutionUnitVerificationException("Attempting to update a payor from annuity, but payors is either null or has 0 elements");
        }
        IPayor payor = this.getAnnuityPayor(annuity, payorId);
        if (payor == null) {
            throw new ExecutionUnitVerificationException("The payor ID does not exist after it was added this is a possible defect");
        }
        payor.setName(this.getUpdatedString(payor.getName()));
        payor.setConfiguration(this.getConfiguration());
        payor = this.getServerAdapter().updatePayor(payor);
        annuity.setConfiguration(this.getConfiguration());
        return this.getServerAdapter().updateAnnuity(annuity);
    }

    private IAnnuity addPayorToAnnuity(IAnnuity annuity, ArrayList<String> payors) throws EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, EntityNotFoundException, RemoteException {
        IPayor payor1 = BasicExecutionUnitLibrarry.getPayor(this.getAnnuityBeansFactory());
        payor1.setConfiguration(this.getConfiguration());
        payor1 = this.getServerAdapter().createPayor(payor1);
        IPayor payor2 = BasicExecutionUnitLibrarry.getPayor(this.getAnnuityBeansFactory());
        payor2.setConfiguration(this.getConfiguration());
        payor2 = this.getServerAdapter().createPayor(payor2);
        annuity.getPayors().add(payor1);
        annuity.getPayors().add(payor2);
        payors.add((String)payor1.getId());
        payors.add((String)payor2.getId());
        annuity.setConfiguration(this.getConfiguration());
        return this.getServerAdapter().updateAnnuity(annuity);
    }

    private IPayout getAnnuityPayout(IAnnuity annuity, String payoutId) {
        for (int i = 0; i < annuity.getPayouts().size(); ++i) {
            if (!((String)annuity.getPayouts().get(i).getId()).equals(payoutId)) continue;
            return annuity.getPayouts().get(i);
        }
        return null;
    }

    private boolean removeAnnuityPayoutHelp(IAnnuity annuity, String payoutId) {
        for (int i = 0; i < annuity.getPayouts().size(); ++i) {
            if (!((String)annuity.getPayouts().get(i).getId()).equals(payoutId)) continue;
            annuity.getPayouts().remove(i);
            return true;
        }
        return false;
    }

    private IAnnuity removeAnnuityPayout(IAnnuity annuity, String payoutId) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        IAnnuity annuityBug = annuity;
        annuityBug.setConfiguration(this.getConfiguration());
        annuityBug = this.getServerAdapter().findAnnuityById(annuityBug);
        if (annuityBug.getPayouts() == null || annuityBug.getPayouts().size() < 1) {
            throw new ExecutionUnitVerificationException("Attempting to remove a payout from annuity, but payouts is either null or has 0 elements");
        }
        IPayout payout = this.getAnnuityPayout(annuity, payoutId);
        this.logger.fine("REMOVING PAYOUT = " + payoutId);
        if (!this.removeAnnuityPayoutHelp(annuity, payoutId)) {
            throw new ExecutionUnitVerificationException("The payout ID does not exist after it was added this is a possible defect");
        }
        annuity.setConfiguration(this.getConfiguration());
        IAnnuity resultAnnuity = this.getServerAdapter().updateAnnuity(annuity);
        payout.setConfiguration(this.getConfiguration());
        this.getServerAdapter().deletePayout(payout);
        this.logger.fine("REMOVING PAYOUT = " + (String)payout.getId());
        return resultAnnuity;
    }

    private IAnnuity updateAnnuityPayout(IAnnuity annuity, String payoutId) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, EntityAlreadyExistsException, RemoteException {
        IAnnuity annuityBug = annuity;
        annuityBug.setConfiguration(this.getConfiguration());
        annuityBug = this.getServerAdapter().findAnnuityById(annuityBug);
        if (annuityBug.getPayouts() == null || annuityBug.getPayouts().size() < 1) {
            throw new ExecutionUnitVerificationException("Attempting to update a payout from annuity, but payouts is either null or has 0 elements");
        }
        Calendar newEndDate = Calendar.getInstance();
        newEndDate.add(2, 11);
        IPayout payout = this.getAnnuityPayout(annuity, payoutId);
        if (payout == null) {
            throw new ExecutionUnitVerificationException("The payout ID does not exist after it was added this is a possible defect");
        }
        payout.setEndDate(newEndDate);
        payout.setTaxableAmount(new BigDecimal(this.getRandomInteger(10000, 100000)));
        payout.setAnnuity(annuity);
        payout.setConfiguration(this.getConfiguration());
        payout = this.getServerAdapter().updatePayout(payout);
        annuity.setConfiguration(this.getConfiguration());
        return this.getServerAdapter().updateAnnuity(annuity);
    }

    private IAnnuity addPayoutsToAnnuity(IAnnuity annuity, ArrayList<String> payouts) throws EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, EntityNotFoundException, ExecutionUnitVerificationException, RemoteException {
        IAnnuity annuityBug = annuity;
        annuityBug.setConfiguration(this.getConfiguration());
        annuityBug = this.getServerAdapter().findAnnuityById(annuityBug);
        if (annuityBug.getPayouts() == null || annuityBug.getPayouts().size() < 1) {
            throw new ExecutionUnitVerificationException("Attempting to update a payout from annuity, but payouts is either null or has 0 elements");
        }
        IPayout payout1 = BasicExecutionUnitLibrarry.getPayout(this.getAnnuityBeansFactory());
        payout1.setAnnuity(annuity);
        payout1.setTaxableAmount(new BigDecimal(this.getRandomInteger(100, 1000)));
        payout1.setConfiguration(this.getConfiguration());
        payout1 = this.getServerAdapter().createPayout(payout1);
        IPayout payout2 = BasicExecutionUnitLibrarry.getPayout(this.getAnnuityBeansFactory());
        payout2.setAnnuity(annuity);
        payout2.setTaxableAmount(new BigDecimal(this.getRandomInteger(100, 1000)));
        payout2.setConfiguration(this.getConfiguration());
        payout2 = this.getServerAdapter().createPayout(payout2);
        annuity.getPayouts().add(payout1);
        annuity.getPayouts().add(payout2);
        this.logger.fine("ADDED PAYOUT = " + (String)payout1.getId());
        this.logger.fine("ADDED PAYOUT = " + (String)payout2.getId());
        this.logger.fine("Start Output All payout IDS");
        for (IPayout temp : annuity.getPayouts()) {
            this.logger.fine((String)temp.getId());
        }
        payouts.add((String)payout1.getId());
        payouts.add((String)payout2.getId());
        annuity.setConfiguration(this.getConfiguration());
        IAnnuity toRet = this.getServerAdapter().updateAnnuity(annuity);
        this.logger.fine("Start Output All payout IDS");
        for (IPayout temp : annuity.getPayouts()) {
            this.logger.fine((String)temp.getId());
        }
        return toRet;
    }

    private IAnnuity updateAnnuityRiderRule(IAnnuity annuity, String riderId) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        IRider rider = null;
        for (int i = 0; i < annuity.getRiders().size(); ++i) {
            if (!((String)annuity.getRiders().get(i).getId()).equals(riderId)) continue;
            rider = annuity.getRiders().get(i);
            break;
        }
        rider.setRule(this.getUpdatedString(rider.getRule()));
        annuity.setConfiguration(this.getConfiguration());
        return this.getServerAdapter().updateAnnuity(annuity);
    }

    private String getUpdatedString(String st) {
        String newName = "";
        String first = "";
        String last = "";
        if (st.indexOf("**") < 0) {
            newName = st + "**0";
        } else {
            StringTokenizer parser = new StringTokenizer(st, "**");
            first = parser.nextToken();
            last = parser.nextToken();
            newName = first + "**" + (Integer.valueOf(last) + 1);
        }
        return newName;
    }

    private IAnnuityHolder findAnnuityHolderById(String randomHolderId) throws ServerAdapterCommunicationException, EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException, RemoteException {
        IAnnuityHolder holder = this.getAnnuityBeansFactory().createAnnuityHolder();
        holder.setId(randomHolderId);
        holder.setConfiguration(this.getConfiguration());
        holder = this.getServerAdapter().findHolderById(holder);
        return holder;
    }

    private List<IAnnuity> getAnnuities(IAnnuityHolder holder) throws ServerAdapterCommunicationException, InvalidArgumentException, ServerInternalErrorException, RemoteException {
        holder.setConfiguration(this.getConfiguration());
        List<IAnnuity> annuities = this.getServerAdapter().findHolderAnnuities(holder);
        return annuities;
    }

    private IAnnuity addRidersToAnnuity(IAnnuity annuity, ArrayList<String> toAdd) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        IRider rider1 = BasicExecutionUnitLibrarry.getRider(this.getAnnuityBeansFactory());
        IRider rider2 = BasicExecutionUnitLibrarry.getRider(this.getAnnuityBeansFactory());
        annuity.getRiders().add(rider1);
        annuity.getRiders().add(rider2);
        toAdd.add((String)rider1.getId());
        toAdd.add((String)rider2.getId());
        annuity.setConfiguration(this.getConfiguration());
        return this.getServerAdapter().updateAnnuity(annuity);
    }

    private IAnnuity removeRiderFromAnnuity(IAnnuity annuity, ArrayList<String> toRemove) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        annuity.setConfiguration(this.getConfiguration());
        IAnnuity annuityBug = annuity;
        annuityBug.setConfiguration(this.getConfiguration());
        annuityBug = this.getServerAdapter().findAnnuityById(annuityBug);
        if (annuityBug.getRiders() == null || annuityBug.getRiders().size() < 1) {
            throw new ExecutionUnitVerificationException("Attempting to remove a rider from annuity, but riders is either null or has 0 elements");
        }
        List<IRider> curRiders = annuity.getRiders();
        ArrayList<IRider> ridersToRemove = new ArrayList<IRider>();
        block0: for (int i = 0; i < toRemove.size(); ++i) {
            for (int c = 0; c < curRiders.size(); ++c) {
                if (!((String)curRiders.get(c).getId()).equals(toRemove.get(i))) continue;
                ridersToRemove.add(curRiders.get(c));
                curRiders.remove(c);
                continue block0;
            }
        }
        annuity.setRiders(curRiders);
        annuity.setConfiguration(this.getConfiguration());
        IAnnuity toReturn = this.getServerAdapter().updateAnnuity(annuity);
        for (IRider curRider : ridersToRemove) {
            curRider.setConfiguration(this.getConfiguration());
            this.getServerAdapter().deleteRider(curRider);
        }
        return toReturn;
    }

    private int recoverableExceptionCheck(Exception e, int threshold, IAnnuity annuity) {
        boolean tryAgain = false;
        ServerExceptionType exType = ServerExceptionMapper.getExceptionType(e);
        if (ServerExceptionType.OPTIMISTIC_LOCKING_EXCEPTION.equals((Object)exType)) {
            this.logger.info("OPTIMISTIC LOCKING EXCEPTION encountered while updating annuity id: " + (String)annuity.getId() + ".  Trying again to a max of: " + this.maximumThreshold + " times. This is attempt: " + (threshold + 1));
            tryAgain = true;
        } else if (ServerExceptionType.DEADLOCK_EXCEPTION.equals((Object)exType)) {
            this.logger.info("DEADLOCK EXCEPTION encountered while updating annuity id: " + (String)annuity.getId() + ".  Trying again to a max of: " + this.maximumThreshold + " times. This is attempt: " + (threshold + 1));
            tryAgain = true;
        }
        if (tryAgain) {
            if (++threshold == this.maximumThreshold) {
                threshold = 0;
            }
            try {
                Thread.sleep(this.retryThinkTime);
            }
            catch (InterruptedException eSleep) {
                this.logger.severe("Thread Sleep has been interrupted" + eSleep.toString());
                this.getExecutionUnitEvent().addException((Exception)eSleep);
            }
        }
        return threshold;
    }

    private void verifyAnnuityValues(IAnnuity annuity, IAnnuity results) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException {
        int i;
        this.logger.fine("annuity payouts size = " + annuity.getPayouts().size());
        for (IPayout temp : annuity.getPayouts()) {
            this.logger.fine((String)temp.getId());
        }
        this.logger.fine("results payouts size = " + results.getPayouts().size());
        for (IPayout temp : results.getPayouts()) {
            this.logger.fine((String)temp.getId());
        }
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, annuity.getPayouts(), results.getPayouts(), "Annuity payouts from Client is not equal to DB value", "Mismacth was found in number of payouts");
        boolean found = false;
        if (annuity.getPayouts() != null) {
            IPayout clientPayout = null;
            for (i = 0; i < annuity.getPayouts().size(); ++i) {
                found = false;
                clientPayout = annuity.getPayouts().get(i);
                for (IPayout resultPayout : results.getPayouts()) {
                    if (!((String)clientPayout.getId()).equals(resultPayout.getId())) continue;
                    found = true;
                    ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, clientPayout, resultPayout, "Annuity Payout from Client is not equal to DB value at location: " + i, "Mismacth was found");
                }
                if (found || clientPayout == null) continue;
                throw new ExecutionUnitVerificationException("Annuity Payout from client is not equal to DB.  Found Payout with id: " + (String)clientPayout.getId() + " on the client side, but not in the database for annuity id:" + (String)annuity.getId());
            }
        }
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, annuity.getRiders(), results.getRiders(), "Annuity rider from Client is not equal to DB value", "Mismacth was found in number of rider");
        if (annuity.getRiders() != null) {
            IRider clientRider = null;
            for (i = 0; i < annuity.getRiders().size(); ++i) {
                found = false;
                clientRider = annuity.getRiders().get(i);
                for (IRider resultRider : results.getRiders()) {
                    if (!((String)clientRider.getId()).equals(resultRider.getId())) continue;
                    found = true;
                    ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, clientRider, resultRider, "Annuity rider from Client is not equal to DB value at location: " + i, "Mismacth was found");
                }
                if (found || clientRider == null) continue;
                throw new ExecutionUnitVerificationException("Annuity rider from client is not equal to DB.  Found rider with id: " + (String)clientRider.getId() + " on the client side, but not in the database for annuity id:" + (String)annuity.getId());
            }
        }
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, annuity.getPayors(), results.getPayors(), "Annuity Payor from Client is not equal to DB value", "Mismacth was found.");
        if (annuity.getPayors() != null) {
            IPayor clientPayor = null;
            for (i = 0; i < annuity.getPayors().size(); ++i) {
                found = false;
                clientPayor = annuity.getPayors().get(i);
                for (IPayor resultPayor : results.getPayors()) {
                    if (!((String)clientPayor.getId()).equals(resultPayor.getId())) continue;
                    found = true;
                    ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, annuity.getPayors().get(i), resultPayor, "Annuity payor from Client is not equal to DB value at location: " + i, "Mismacth was found");
                }
                if (found || clientPayor == null) continue;
                throw new ExecutionUnitVerificationException("Annuity payor from client is not equal to DB.  Found payor with id: " + (String)clientPayor.getId() + " on the client side, but not in the database for annuity id:" + (String)annuity.getId());
            }
        }
    }
}

