/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.executionunit;

import com.ibm.wssvt.acme.annuity.common.bean.IAnnuity;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.AbastractAnnuityExecutionUnit;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.annuity.common.util.ServerExceptionMapper;
import com.ibm.wssvt.acme.annuity.common.util.ServerExceptionType;
import com.ibm.wssvt.acme.common.adapter.ServerAdapterCommunicationException;
import com.ibm.wssvt.acme.common.executionunit.ExecutionUnitVerificationException;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.rmi.RemoteException;

public class UpdateAnnuityWithProvidedIdEU
extends AbastractAnnuityExecutionUnit {
    private static final long serialVersionUID = -4582734443081148303L;
    private static final String ID = "id";
    private AcmeLogger logger;
    private static final String MAX_THRESHOLD = "maximumThreshold";
    private int maximumThreshold;

    public void execute() {
        try {
            this.setScenarioVariables();
            IAnnuity annuity = this.getAnnuityBeansFactory().createAnnuity();
            String id = (String)this.getConfiguration().getParameterValue((Object)ID);
            annuity.setId(id);
            annuity.setConfiguration(this.getConfiguration());
            IAnnuity results = this.getServerAdapter().findAnnuityById(annuity);
            this.verifyFindSuccess(results);
            String prefixUpdate = "" + System.currentTimeMillis();
            try {
                this.updateAnnuity(annuity, prefixUpdate);
            }
            catch (Exception e) {
                this.examinException(annuity, e);
            }
            results = this.getServerAdapter().findAnnuityById(annuity);
            this.verifyFindSuccess(results);
            if (!results.getAccountNumber().startsWith(prefixUpdate)) {
                throw new ExecutionUnitVerificationException("Updated Annuity with id:" + id + " failed." + " Expected account number to start with the words: " + prefixUpdate + " but found: " + annuity.getAccountNumber());
            }
        }
        catch (Exception e) {
            this.getExecutionUnitEvent().addException(e);
        }
    }

    private void examinException(IAnnuity annuity, Exception e) {
        boolean success = false;
        ServerExceptionType exType = ServerExceptionMapper.getExceptionType(e);
        if (ServerExceptionType.OPTIMISTIC_LOCKING_EXCEPTION.equals((Object)exType)) {
            for (int i = 1; i <= this.maximumThreshold; ++i) {
                try {
                    this.logger.info("OPTIMISTIC LOCKING EXCEPTION encountered while updating contact id: " + (String)annuity.getId() + ".  Trying again to a max of: " + this.maximumThreshold + " times. This is the: " + (i + 1) + " attempt.");
                    String prefixUpdate = "" + System.currentTimeMillis();
                    annuity.setConfiguration(this.getConfiguration());
                    annuity = this.getServerAdapter().findAnnuityById(annuity);
                    this.updateAnnuity(annuity, prefixUpdate);
                    success = true;
                    break;
                }
                catch (Exception exp) {
                    continue;
                }
            }
            if (!success) {
                ExecutionUnitVerificationException exp = new ExecutionUnitVerificationException("Attempted to update annuity for: " + this.maximumThreshold + " but was not successfuil");
                this.getExecutionUnitEvent().addException((Exception)((Object)exp));
                return;
            }
        }
    }

    private IAnnuity updateAnnuity(IAnnuity annuity, String prefix) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        String newAccountNumber = prefix + annuity.getAccountNumber();
        annuity.setConfiguration(this.getConfiguration());
        annuity.setAccountNumber(newAccountNumber);
        return this.getServerAdapter().updateAnnuity(annuity);
    }

    private void verifyFindSuccess(IAnnuity annuity) throws ExecutionUnitVerificationException {
        if (annuity == null) {
            throw new ExecutionUnitVerificationException(this.getDescription() + " Find Annuity Failed in.  Returned object is null");
        }
        if (annuity.getId() == null) {
            throw new ExecutionUnitVerificationException(this.getDescription() + " Find Annuity Failed. Returned object id == 0");
        }
    }

    private void setScenarioVariables() {
        this.logger = this.getLogger(((Object)((Object)this)).getClass().getName());
        try {
            this.maximumThreshold = this.getParameterValueInt(MAX_THRESHOLD);
        }
        catch (Exception e) {
            this.logger.fine("maximumThreshold parameter not specified, using default");
            this.maximumThreshold = 2;
        }
    }
}

