/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.executionunit;

import com.ibm.wssvt.acme.annuity.common.bean.AnnuityHolderCategory;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.bean.IContact;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.AbastractAnnuityExecutionUnit;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.BasicExecutionUnitLibrarry;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.ExecutionUnitVerificationHelper;
import com.ibm.wssvt.acme.annuity.common.exception.EntityAlreadyExistsException;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.annuity.common.util.ServerExceptionMapper;
import com.ibm.wssvt.acme.annuity.common.util.ServerExceptionType;
import com.ibm.wssvt.acme.common.adapter.ServerAdapterCommunicationException;
import com.ibm.wssvt.acme.common.executionunit.ExecutionUnitVerificationException;
import com.ibm.wssvt.acme.common.executionunit.IExecutionUnit;
import com.ibm.wssvt.acme.common.executionunit.InvalidExecutionUnitParameterException;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;

public class UpdateExistingHoldeAndContactEU
extends AbastractAnnuityExecutionUnit {
    private static final long serialVersionUID = -8978758038714550844L;
    private static final String START_HOLDER_ID = "startHolderId";
    private static final String END_HOLDER_ID = "endHolderId";
    private int startHolderId;
    private int endHolderId;
    private int holderRange;
    private int overRideIdint = 0;
    private boolean enableVerify = true;
    private int maximumThreshold = 2;
    private int retryThinkTime = 5000;
    private int threshold = 0;
    private AcmeLogger logger;

    public void execute() {
        try {
            this.setScenarioVariables();
        }
        catch (Exception e) {
            this.logger.warning("Invalid scenario parameters for scenario description:" + this.getDescription() + "  Error is: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        String randomHolderId = "" + (this.startHolderId + this.getRandomInteger(0, this.holderRange));
        this.logger.fine("Got the random holder ID - " + randomHolderId);
        this.logger.fine("Find the holder from existing database");
        IAnnuityHolder holder = null;
        try {
            holder = this.getAnnuityBeansFactory().createAnnuityHolder();
            holder.setId(randomHolderId);
            holder.setConfiguration(this.getConfiguration());
            holder = this.getServerAdapter().findHolderById(holder);
            this.logger.fine("holder category - " + (Object)((Object)holder.getCategory()));
            this.logger.fine("holder first name - " + holder.getFirstName());
            this.logger.fine("holder last name - " + holder.getLastName());
        }
        catch (Exception e) {
            this.logger.warning("Failed to find holder. ID - " + randomHolderId + " Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        if (this.enableVerify) {
            this.logger.fine("Verifying annuity holder from db: " + randomHolderId);
            try {
                this.verifyAnnuityHolderValue(holder);
            }
            catch (Exception e) {
                this.logger.severe("Find AnnuityHolder verification failed.  Error: " + e);
                this.getExecutionUnitEvent().addException(e);
            }
        }
        this.logger.fine("Getting Contact from AnnuityHolder:" + randomHolderId);
        IContact contact = null;
        try {
            contact = holder.getContact();
            if (contact == null) {
                this.logger.severe("Failed to read holder Contact. Contact = null. HolderId: " + randomHolderId);
                return;
            }
        }
        catch (Exception e) {
            this.logger.severe("Failed to get Contact. Error: " + randomHolderId + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        if (this.enableVerify) {
            this.logger.fine("Verifying Create Contact:" + randomHolderId);
            try {
                this.verifyContactValue(contact, holder);
            }
            catch (Exception e) {
                this.logger.severe("Create Contact verification failed.  Error: " + randomHolderId + e);
                this.getExecutionUnitEvent().addException(e);
            }
        }
        this.logger.fine("Updating Contact:" + randomHolderId);
        IContact updatedContact = null;
        try {
            updatedContact = this.updateContact(contact, holder);
            if (updatedContact == null) {
                this.logger.severe("Failed to update Contact. HolderId: " + randomHolderId);
                return;
            }
        }
        catch (Exception e) {
            this.logger.severe("Failed to update Contact. Error: " + randomHolderId + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        if (this.enableVerify) {
            this.logger.fine("Verifying Update Contact:" + (String)updatedContact.getId());
            try {
                this.verifyContactValue(updatedContact, holder);
            }
            catch (Exception e) {
                this.logger.severe("Update Contact verification failed. Error: " + e);
                this.getExecutionUnitEvent().addException(e);
            }
        }
        this.logger.fine("Updating AnnuityHolder:" + randomHolderId);
        IAnnuityHolder updatedHolder = null;
        try {
            updatedHolder = this.updateAnnuityHolder(holder, updatedContact);
        }
        catch (Exception e) {
            this.logger.severe("Failed to update AnnuityHolder. Error: " + randomHolderId + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        if (this.enableVerify) {
            this.logger.fine("Verifying Update AnnuityHolder:" + randomHolderId);
            try {
                this.verifyAnnuityHolderValue(updatedHolder);
            }
            catch (Exception e) {
                this.logger.severe("Update AnnuityHolder verification failed. Error: " + e);
                this.getExecutionUnitEvent().addException(e);
            }
        }
    }

    private void setScenarioVariables() throws InvalidExecutionUnitParameterException {
        String OVERRIDE_ID_KEY = "overRideId";
        String MAX_THRESHOLD = "maximumThreshold";
        String ENABLE_VERIFY_KEY = "enableVerify";
        String RETRY_THINK_TIME = "retryThinkTime";
        this.logger = this.getLogger(((Object)((Object)this)).getClass().getName());
        this.startHolderId = this.getParameterValueInt(START_HOLDER_ID);
        this.endHolderId = this.getParameterValueInt(END_HOLDER_ID);
        try {
            this.maximumThreshold = this.getParameterValueInt("maximumThreshold");
        }
        catch (Exception e) {
            this.logger.warning("maximumThreshold parameter not specified, using default");
            this.maximumThreshold = 2;
        }
        try {
            this.retryThinkTime = this.getParameterValueInt("retryThinkTime");
        }
        catch (Exception e) {
            this.logger.warning("the attribute:retryThinkTime is missing for scenario: " + this.getDescription() + " .Setting the default to 5 seconds");
            this.retryThinkTime = 5000;
        }
        try {
            this.enableVerify = this.getParameterValueBoolean("enableVerify");
        }
        catch (Exception e) {
            this.logger.warning("enableVerify parameter is not set, using default true.");
            this.enableVerify = true;
        }
        try {
            this.overRideIdint = this.getParameterValueInt("overRideId");
        }
        catch (Exception e) {
            this.logger.warning("the attribute:overRideId is missing for scenario: " + this.getDescription() + " .Setting the default to zero");
            this.overRideIdint = 0;
        }
        if (this.startHolderId <= 0) {
            throw new InvalidExecutionUnitParameterException("startHolderId is less or equal to 0.  Invalid value for scenario with description: " + this.getDescription() + ".  Value must be one or more.");
        }
        if (this.endHolderId <= 0) {
            throw new InvalidExecutionUnitParameterException("endHolderId is less or equal to 0.  Invalid value for scenario with description: " + this.getDescription() + ".  Value must be one or more.");
        }
        if (this.overRideIdint > 0) {
            this.startHolderId = this.overRideIdint;
            this.holderRange = 0;
        } else {
            this.holderRange = this.endHolderId - this.startHolderId;
        }
    }

    private IAnnuityHolder updateAnnuityHolder(IAnnuityHolder before, IContact updatedContact) throws EntityNotFoundException, EntityAlreadyExistsException, ServerAdapterCommunicationException, InvalidArgumentException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        IAnnuityHolder after = null;
        this.threshold = 0;
        while (this.threshold <= this.maximumThreshold) {
            after = BasicExecutionUnitLibrarry.getAnnuityHolder(this.getAnnuityBeansFactory());
            after.setId(before.getId());
            after.setConfiguration(this.getConfiguration());
            after = this.getServerAdapter().findHolderById(after);
            after.setCategory(this.getRandomEnum(AnnuityHolderCategory.class));
            Date dob = after.getDateOfBirth();
            Calendar newdob = Calendar.getInstance();
            newdob.setTime(dob);
            newdob.add(2, 1);
            after.setDateOfBirth(newdob.getTime());
            after.setLastName(this.getUpdatedString(after.getLastName()));
            try {
                after.setConfiguration(this.getConfiguration());
                after = this.getServerAdapter().updateAnnuityHolder(after);
                break;
            }
            catch (Exception e) {
                this.threshold = this.recoverableExceptionCheck(e, this.threshold, (String)after.getId());
                if (this.threshold != 0) continue;
                this.logger.severe("Failed to update holder ID:" + (String)before.getId());
                this.getExecutionUnitEvent().addException(e);
                throw new ExecutionUnitVerificationException("updateAnnuityHolder: returning null after contact object");
            }
        }
        if (after == null) {
            throw new ExecutionUnitVerificationException("updateAnnuityHolder: returning null after object");
        }
        return after;
    }

    private IContact updateContact(IContact before, IAnnuityHolder holder) throws EntityNotFoundException, EntityAlreadyExistsException, ServerAdapterCommunicationException, InvalidArgumentException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        this.threshold = 0;
        IContact after = null;
        while (this.threshold <= this.maximumThreshold) {
            after = BasicExecutionUnitLibrarry.getContact(this.getAnnuityBeansFactory());
            after.setId(before.getId());
            after.setConfiguration(this.getConfiguration());
            try {
                after = this.getServerAdapter().findContactById(after);
            }
            catch (Exception e) {
                this.logger.severe("Failed: HolderID:" + (String)holder.getId() + " to find Contact ID:" + (String)before.getId());
                this.getExecutionUnitEvent().addException(e);
            }
            after.setPhone(this.getUpdatedString(after.getPhone()));
            after.setEmail(this.getUpdatedString(after.getEmail()));
            try {
                after.setConfiguration(this.getConfiguration());
                after = this.getServerAdapter().updateContact(after);
                break;
            }
            catch (Exception e) {
                this.threshold = this.recoverableExceptionCheck(e, this.threshold, (String)after.getId());
                if (this.threshold != 0) continue;
                this.logger.severe("Failed: HolderID:" + (String)holder.getId() + " to update Contact ID:" + (String)before.getId());
                this.getExecutionUnitEvent().addException(e);
                throw new ExecutionUnitVerificationException("updateContact: returning null after contact object");
            }
        }
        this.threshold = 0;
        IContact newContact = null;
        IAnnuityHolder updatedHolder = null;
        while (this.threshold <= this.maximumThreshold) {
            newContact = BasicExecutionUnitLibrarry.getContact(this.getAnnuityBeansFactory());
            newContact.setId(after.getId());
            updatedHolder = BasicExecutionUnitLibrarry.getAnnuityHolder(this.getAnnuityBeansFactory());
            updatedHolder.setId(holder.getId());
            updatedHolder.setConfiguration(this.getConfiguration());
            updatedHolder = this.getServerAdapter().findHolderById(updatedHolder);
            updatedHolder.setContact(null);
            try {
                updatedHolder.setConfiguration(this.getConfiguration());
                updatedHolder = this.getServerAdapter().updateAnnuityHolder(updatedHolder);
                break;
            }
            catch (Exception e) {
                this.threshold = this.recoverableExceptionCheck(e, this.threshold, (String)updatedHolder.getId());
                if (this.threshold != 0) continue;
                this.logger.severe("Failed: HolderID:" + (String)holder.getId() + " to update Holder with new contact ID:" + (String)after.getId());
                this.getExecutionUnitEvent().addException(e);
                throw new ExecutionUnitVerificationException("updateContact: returning null after contact object");
            }
        }
        this.threshold = 0;
        while (this.threshold <= this.maximumThreshold) {
            try {
                after.setConfiguration(this.getConfiguration());
                this.getServerAdapter().deleteContact(after);
                break;
            }
            catch (Exception e) {
                this.threshold = this.recoverableExceptionCheck(e, this.threshold, (String)after.getId());
                if (this.threshold != 0) continue;
                this.logger.severe("Failed: HolderID:" + (String)holder.getId() + " to delete contact ID:" + (String)after.getId());
                this.getExecutionUnitEvent().addException(e);
                throw new ExecutionUnitVerificationException("updateContact: returning null after contact object");
            }
        }
        this.threshold = 0;
        while (this.threshold <= this.maximumThreshold) {
            newContact.setConfiguration(this.getConfiguration());
            after = this.getServerAdapter().createContact(newContact);
            updatedHolder.setContact(after);
            updatedHolder.setConfiguration(this.getConfiguration());
            try {
                updatedHolder = this.getServerAdapter().updateAnnuityHolder(updatedHolder);
                break;
            }
            catch (Exception e) {
                this.threshold = this.recoverableExceptionCheck(e, this.threshold, (String)after.getId());
                if (this.threshold != 0) continue;
                this.logger.severe("Failed: HolderID:" + (String)holder.getId() + " to updte with new contact ID:" + (String)after.getId());
                this.getExecutionUnitEvent().addException(e);
                throw new ExecutionUnitVerificationException("updateContact: returning null after contact object");
            }
        }
        if (after == null) {
            throw new ExecutionUnitVerificationException("updateContact: returning null after contact object");
        }
        return after;
    }

    private int recoverableExceptionCheck(Exception e, int threshold, String id) {
        boolean tryAgain = false;
        ServerExceptionType exType = ServerExceptionMapper.getExceptionType(e);
        if (ServerExceptionType.OPTIMISTIC_LOCKING_EXCEPTION.equals((Object)exType)) {
            this.logger.info("OPTIMISTIC LOCKING EXCEPTION encountered while updating contact or holder id: " + id + ".  Trying again to a max of: " + this.maximumThreshold + " times. This is attempt: " + (threshold + 1));
            tryAgain = true;
        } else if (ServerExceptionType.DEADLOCK_EXCEPTION.equals((Object)exType)) {
            this.logger.info("DEADLOCK EXCEPTION encountered while updating contact or holder id: " + id + ".  Trying again to a max of: " + this.maximumThreshold + " times. This is attempt: " + (threshold + 1));
            tryAgain = true;
        }
        if (tryAgain) {
            if (++threshold == this.maximumThreshold) {
                threshold = 0;
            }
            try {
                Thread.sleep(this.retryThinkTime);
            }
            catch (InterruptedException eSleep) {
                this.logger.severe("Thread Sleep has been interrupted" + eSleep.toString());
                this.getExecutionUnitEvent().addException((Exception)eSleep);
            }
        }
        return threshold;
    }

    private void verifyAnnuityHolderValue(IAnnuityHolder annuityHolder) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        IAnnuityHolder results = this.getAnnuityBeansFactory().createAnnuityHolder();
        results.setId(annuityHolder.getId());
        results.setConfiguration(this.getConfiguration());
        results = this.getServerAdapter().findHolderById(results);
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, annuityHolder, results, "AnnuityHolder from Client is not equal to DB value", "Mismacth was found.");
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, annuityHolder.getContact(), results.getContact(), "AnnuityHolder Contact from Client is not equal to DB value", "Mismacth was found.");
    }

    private void verifyContactValue(IContact contact, IAnnuityHolder holder) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        IContact results = this.getAnnuityBeansFactory().createContact();
        if (results == null) {
            throw new ExecutionUnitVerificationException("HolderId:" + (String)holder.getId() + " Create contact getAnnuityBeansFactory().createContact() is null");
        }
        if (contact == null) {
            throw new ExecutionUnitVerificationException("HolderId:" + (String)holder.getId() + " passed in contact object is null");
        }
        results.setId(contact.getId());
        results.setConfiguration(this.getConfiguration());
        results = this.getServerAdapter().findContactById(results);
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, contact, results, "HolderId:" + (String)holder.getId() + " Contact from client is not equal to DB value", "Contact Create mismacth was found.");
    }

    private String getUpdatedString(String st) {
        String newName = "";
        String first = "";
        String last = "";
        if (st.indexOf("**") < 0) {
            newName = st + "**0";
        } else {
            StringTokenizer parser = new StringTokenizer(st, "**");
            first = parser.nextToken();
            last = parser.nextToken();
            newName = first + "**" + (Integer.valueOf(last) + 1);
        }
        return newName;
    }
}

