/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.executionunit.policy;

import com.ibm.wssvt.acme.annuity.common.bean.IBeneContact;
import com.ibm.wssvt.acme.annuity.common.bean.IBeneficiary;
import com.ibm.wssvt.acme.annuity.common.bean.jpa.BeneContactId;
import com.ibm.wssvt.acme.annuity.common.bean.jpa.JPABeansFactory;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.BasicExecutionUnitLibrarry;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.ExecutionUnitVerificationHelper;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.policy.AbastractPolicyExecutionUnit;
import com.ibm.wssvt.acme.annuity.common.exception.EntityAlreadyExistsException;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.common.adapter.ServerAdapterCommunicationException;
import com.ibm.wssvt.acme.common.executionunit.ExecutionUnitVerificationException;
import com.ibm.wssvt.acme.common.executionunit.IExecutionUnit;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.rmi.RemoteException;

public class CRUDBeneficiaryWithBeneContactEU
extends AbastractPolicyExecutionUnit {
    private static final long serialVersionUID = -5069230737845432381L;
    private AcmeLogger logger;

    public void execute() {
        this.setScenarioVariables();
        this.logger.fine("Creating beneficiary");
        IBeneficiary beneficiary = null;
        try {
            beneficiary = this.createBeneficiary();
        }
        catch (Exception e) {
            this.logger.warning("Failed to create Beneficiary. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.fine("Verifying create beneficiary");
        try {
            this.verifyCreate(beneficiary);
        }
        catch (Exception e) {
            this.logger.info("Create Beneficiary verification failed.  Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
        this.logger.fine("Creating beneficiary contact");
        IBeneContact beneContact = null;
        try {
            beneContact = this.createBeneContact((String)beneficiary.getId());
        }
        catch (Exception e) {
            this.logger.warning("Failed to create Beneficiary contact. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.fine("Verifying create beneficiary contact");
        try {
            this.verifyCreate(beneContact);
        }
        catch (Exception e) {
            this.logger.info("Create Beneficiary contact verification failed.  Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
        this.logger.fine("Updating beneficiary contact");
        IBeneContact updatedBeneContact = null;
        try {
            updatedBeneContact = this.updateBeneContact(beneContact);
        }
        catch (Exception e) {
            this.logger.warning("Failed to update Beneficiary contact. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.fine("Verifying update beneficiary contact");
        try {
            this.verifyUpdate(updatedBeneContact);
        }
        catch (Exception e) {
            this.logger.info("Update Beneficiary contact verification failed. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
        this.logger.fine("Reading beneficiary via beneficiary contact");
        try {
            this.readBeneficiaryFromBeneContact(updatedBeneContact);
        }
        catch (Exception e) {
            this.logger.info("Could not read beneficiary from beneficiary contact. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
        this.logger.fine("Updating beneficiary");
        IBeneficiary updatedBeneficiary = null;
        try {
            updatedBeneficiary = this.updateBeneficiary(beneficiary);
        }
        catch (Exception e) {
            this.logger.warning("Failed to update Beneficiary. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.fine("Verifying update beneficiary");
        try {
            this.verifyUpdate(updatedBeneficiary);
        }
        catch (Exception e) {
            this.logger.info("Update Beneficiary verification failed. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
        this.logger.fine("Deleting beneficiary");
        try {
            this.deleteBeneficiary(updatedBeneficiary);
        }
        catch (Exception e) {
            this.logger.info("Failed to delete Beneficiary. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.fine("Verifying delete beneficiary");
        try {
            this.verifyDelete(updatedBeneficiary);
        }
        catch (Exception e) {
            this.logger.info("Delete Beneficiary verification failed.  Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
        this.logger.fine("Verifying delete beneficiary contact via automatic orphan removal");
        try {
            this.verifyDelete(updatedBeneContact);
        }
        catch (Exception e) {
            this.logger.info("Delete Beneficiary contact verification failed.  Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
    }

    private void readBeneficiaryFromBeneContact(IBeneContact beneContact) throws EntityNotFoundException, InvalidArgumentException, ServerInternalErrorException, ServerAdapterCommunicationException, RemoteException, ExecutionUnitVerificationException {
        IBeneficiary beneficiary = beneContact.getBeneficiary();
        IBeneficiary results = ((JPABeansFactory)this.getAnnuityBeansFactory()).createBeneficiary();
        results.setId(beneficiary.getId());
        results.setConfiguration(this.getConfiguration());
        results = this.getServerAdapter().findBeneficiaryById(results);
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, beneficiary, results, "beneficiary from client is not equal to DB value", "beneficiary read mismatch was found.");
    }

    private IBeneficiary createBeneficiary() throws EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        IBeneficiary beneficiary = BasicExecutionUnitLibrarry.getBeneficiary(this.getAnnuityBeansFactory());
        beneficiary.setConfiguration(this.getConfiguration());
        beneficiary = this.getServerAdapter().createBeneficiary(beneficiary);
        return beneficiary;
    }

    private IBeneContact createBeneContact(String beneficiaryPK) throws EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        IBeneContact beneContact = BasicExecutionUnitLibrarry.getBeneContact(this.getAnnuityBeansFactory(), beneficiaryPK);
        beneContact.setConfiguration(this.getConfiguration());
        beneContact = this.getServerAdapter().createBeneContact(beneContact);
        return beneContact;
    }

    private IBeneficiary updateBeneficiary(IBeneficiary before) throws EntityNotFoundException, InvalidArgumentException, ServerInternalErrorException, ServerAdapterCommunicationException, RemoteException {
        IBeneficiary after = BasicExecutionUnitLibrarry.getBeneficiary(this.getAnnuityBeansFactory());
        after.setId(before.getId());
        after.setConfiguration(this.getConfiguration());
        after = this.getServerAdapter().findBeneficiaryById(after);
        after.setFirstName(after.getFirstName() + "-updated");
        after.setLastName(after.getLastName() + "-updated");
        after.setRelationship(after.getRelationship() + "-updated");
        after.setConfiguration(this.getConfiguration());
        after = this.getServerAdapter().updateBeneficiary(after);
        return after;
    }

    private IBeneContact updateBeneContact(IBeneContact before) throws EntityNotFoundException, InvalidArgumentException, ServerInternalErrorException, ServerAdapterCommunicationException, RemoteException {
        IBeneContact after = BasicExecutionUnitLibrarry.getBeneContact(this.getAnnuityBeansFactory(), ((BeneContactId)before.getId()).getBeneficiaryPK());
        after.setId(before.getId());
        after.setConfiguration(this.getConfiguration());
        after = this.getServerAdapter().findBeneContactById(after);
        after.setEmail(after.getEmail() + "-updated");
        after.setConfiguration(this.getConfiguration());
        after = this.getServerAdapter().updateBeneContact(after);
        return after;
    }

    private void deleteBeneficiary(IBeneficiary beneficiary) throws InvalidArgumentException, EntityNotFoundException, ServerInternalErrorException, ServerAdapterCommunicationException, RemoteException {
        IBeneficiary removed = BasicExecutionUnitLibrarry.getBeneficiary(this.getAnnuityBeansFactory());
        removed.setId(beneficiary.getId());
        removed.setConfiguration(this.getConfiguration());
        this.getServerAdapter().deleteBeneficiary(removed);
    }

    private void verifyCreate(IBeneficiary beneficiary) throws EntityNotFoundException, InvalidArgumentException, ServerInternalErrorException, ServerAdapterCommunicationException, RemoteException, ExecutionUnitVerificationException {
        IBeneficiary results = ((JPABeansFactory)this.getAnnuityBeansFactory()).createBeneficiary();
        results.setId(beneficiary.getId());
        results.setConfiguration(this.getConfiguration());
        results = this.getServerAdapter().findBeneficiaryById(results);
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, beneficiary, results, "beneficiary from client is not equal to DB value", "beneficiary Create mismatch was found.");
    }

    private void verifyCreate(IBeneContact beneContact) throws EntityNotFoundException, InvalidArgumentException, ServerInternalErrorException, ServerAdapterCommunicationException, RemoteException, ExecutionUnitVerificationException {
        IBeneContact results = ((JPABeansFactory)this.getAnnuityBeansFactory()).createBeneContact();
        results.setId(beneContact.getId());
        results.setConfiguration(this.getConfiguration());
        results = this.getServerAdapter().findBeneContactById(results);
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, beneContact, results, "beneficiary contact from client is not equal to DB value", "beneficiary contact Create mismatch was found.");
    }

    private void verifyUpdate(IBeneficiary beneficiary) throws ExecutionUnitVerificationException, EntityNotFoundException, InvalidArgumentException, ServerInternalErrorException, ServerAdapterCommunicationException, RemoteException {
        IBeneficiary results = ((JPABeansFactory)this.getAnnuityBeansFactory()).createBeneficiary();
        results.setId(beneficiary.getId());
        results.setConfiguration(this.getConfiguration());
        results = this.getServerAdapter().findBeneficiaryById(results);
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, beneficiary, results, "beneficiary from client is not equal to DB value", "beneficiary Update mismatch was found.");
    }

    private void verifyUpdate(IBeneContact beneContact) throws ExecutionUnitVerificationException, EntityNotFoundException, InvalidArgumentException, ServerInternalErrorException, ServerAdapterCommunicationException, RemoteException {
        IBeneContact results = ((JPABeansFactory)this.getAnnuityBeansFactory()).createBeneContact();
        results.setId(beneContact.getId());
        results.setConfiguration(this.getConfiguration());
        results = this.getServerAdapter().findBeneContactById(results);
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, beneContact, results, "beneficiary from client is not equal to DB value", "beneficiary Update mismatch was found.");
    }

    private void verifyDelete(IBeneficiary beneficiary) throws InvalidArgumentException, ServerInternalErrorException, ServerAdapterCommunicationException, RemoteException, ExecutionUnitVerificationException {
        IBeneficiary results = ((JPABeansFactory)this.getAnnuityBeansFactory()).createBeneficiary();
        results.setId(beneficiary.getId());
        results.setConfiguration(this.getConfiguration());
        try {
            results = this.getServerAdapter().findBeneficiaryById(results);
            if (results != null) {
                throw new ExecutionUnitVerificationException("Deletion of beneficiary with ID = " + (String)beneficiary.getId() + " was not successful! The object still exists in DB.");
            }
        }
        catch (EntityNotFoundException entityNotFoundException) {
            // empty catch block
        }
    }

    private void verifyDelete(IBeneContact beneContact) throws InvalidArgumentException, ServerInternalErrorException, ServerAdapterCommunicationException, RemoteException, ExecutionUnitVerificationException {
        IBeneContact results = ((JPABeansFactory)this.getAnnuityBeansFactory()).createBeneContact();
        results.setId(beneContact.getId());
        results.setConfiguration(this.getConfiguration());
        try {
            results = this.getServerAdapter().findBeneContactById(results);
            if (results != null) {
                throw new ExecutionUnitVerificationException("Deletion of beneficiary contact with ID = " + beneContact.getId() + " was not successful! The object still exists in DB.");
            }
        }
        catch (EntityNotFoundException entityNotFoundException) {
            // empty catch block
        }
    }

    private void setScenarioVariables() {
        this.logger = this.getLogger(((Object)((Object)this)).getClass().getName());
    }
}

