/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.executionunit.policy;

import com.ibm.wssvt.acme.annuity.common.bean.IFund;
import com.ibm.wssvt.acme.annuity.common.bean.IPolicy;
import com.ibm.wssvt.acme.annuity.common.bean.jpa.JPABeansFactory;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.BasicExecutionUnitLibrarry;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.ExecutionUnitVerificationHelper;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.policy.AbastractPolicyExecutionUnit;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.common.adapter.ServerAdapterCommunicationException;
import com.ibm.wssvt.acme.common.executionunit.ExecutionUnitVerificationException;
import com.ibm.wssvt.acme.common.executionunit.IExecutionUnit;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.rmi.RemoteException;
import java.util.Map;

public class CreatePolicyEU
extends AbastractPolicyExecutionUnit {
    private static final long serialVersionUID = -3967925682867028969L;

    public void execute() {
        try {
            AcmeLogger logger = this.getLogger(((Object)((Object)this)).getClass().getName());
            IPolicy original = BasicExecutionUnitLibrarry.getPolicy(this.getAnnuityBeansFactory());
            original.setConfiguration(this.getConfiguration());
            logger.info("creating policy");
            IPolicy result = this.getServerAdapter().createPolicy(original);
            Map<Integer, IFund> fundMap = result.getFunds();
            for (int i = 1; i <= fundMap.size(); ++i) {
                logger.info("Policy's fund name is: " + result.getFunds().get(new Integer(i)).getFundName());
            }
            this.verifyPolicyValues(original);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getExecutionUnitEvent().addException(e);
        }
    }

    private void verifyPolicyValues(IPolicy policy) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        IPolicy results = ((JPABeansFactory)this.getAnnuityBeansFactory()).createPolicy();
        results.setId(policy.getId());
        results.setConfiguration(this.getConfiguration());
        results = this.getServerAdapter().findPolicyById(results);
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, policy, results, "policy from Client is not equal to DB value", "Mismacth was found.");
    }
}

