/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.executionunit.stackunit;

import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.AbstractAnnuityStackableExecutionUnit;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.BasicExecutionUnitLibrarry;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.common.executionunit.ExecutionUnitVerificationException;
import com.ibm.wssvt.acme.common.executionunit.InvalidExecutionUnitParameterException;
import com.ibm.wssvt.acme.common.log.AcmeLogger;

public class DeleteAnnuityHolderEU
extends AbstractAnnuityStackableExecutionUnit {
    private static final long serialVersionUID = 5751982103363852382L;
    boolean enableVerify = true;
    AcmeLogger logger;

    public void execute() {
        this.logger = this.getLogger(((Object)((Object)this)).getClass().getName());
        try {
            this.setEUParams();
            IAnnuityHolder holder = BasicExecutionUnitLibrarry.getAnnuityHolder(this.getAnnuityBeansFactory());
            holder.setConfiguration(this.getConfiguration());
            String annuityHolderId = (String)this.getStackMap().get("annuityHolderId");
            if (annuityHolderId == null || annuityHolderId.trim().length() == 0) {
                throw new InvalidExecutionUnitParameterException("This EU expects to find the attribute annuityHolderId in the stack but found null or empty.  found: " + annuityHolderId + ".  Make sure that you use this EU in a correct order.");
            }
            holder.setId(annuityHolderId);
            this.logger.fine("ready to delete annuityHolder: " + holder);
            this.getServerAdapter().deleteAnnuityHolder(holder);
            this.logger.fine("deleted annuityHolder ");
            if (this.enableVerify) {
                holder.setConfiguration(this.getConfiguration());
                try {
                    this.getServerAdapter().findHolderById(holder);
                    throw new ExecutionUnitVerificationException("Deleted the holder and expected an EntityNotFoundException on a subsequent read, but did not get the exception");
                }
                catch (EntityNotFoundException entityNotFoundException) {
                    // empty catch block
                }
            }
            this.getStackMap().remove("annuityHolderId");
        }
        catch (Exception e) {
            this.getExecutionUnitEvent().addException(e);
        }
    }

    private void setEUParams() {
        try {
            this.enableVerify = this.getParameterValueBoolean("enableVerify");
        }
        catch (InvalidExecutionUnitParameterException e) {
            this.enableVerify = true;
        }
    }
}

