/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.servicelookup.ejb3jaxrpc;

import com.ibm.wssvt.acme.annuity.common.business.IAnnuityService;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.ejb3impl.AnnuityMgmtSvcEJB3JAXRPCImpl;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.ejb3impl.AnnuityMgmtSvcEJB3JAXRPCImplLocator;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.ejb3impl.AnnuityMgmtSvcEJB3JAXRPCSEI;
import com.ibm.wssvt.acme.annuity.common.servicelookup.ejb3jaxrpc.EJB30JAXRPJAXRPCCServiceProxy;
import com.ibm.wssvt.acme.common.bean.Configrable;
import com.ibm.wssvt.acme.common.exception.ExceptionFormatter;
import com.ibm.wssvt.acme.common.exception.InvalidConfigurationException;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.rpc.ServiceException;

public class EJB30JAXRPCJAXRPCServiceLookup {
    private static final String JAXRPC_SERVICE_URL_KEY = "ejb3JAXRPCServiceURL";

    public static IAnnuityService getAnnuityEJB30JAXRPCJAXRPCService(AnnuityMgmtSvcEJB3JAXRPCImpl injectedService, Configrable<String, String> configrable, AcmeLogger logger) throws InvalidConfigurationException {
        String jaxrpcServiceUrl = (String)configrable.getConfiguration().getParameterValue((Object)JAXRPC_SERVICE_URL_KEY);
        try {
            AnnuityMgmtSvcEJB3JAXRPCSEI port;
            if (injectedService != null) {
                logger.fine("using injected service: " + injectedService);
                URL endPoint = new URL(jaxrpcServiceUrl);
                port = injectedService.getAnnuityMgmtSvcEJB3JAXRPCImplPort(endPoint);
                logger.fine("using injected service port: " + port);
            } else {
                URL endPoint = new URL(jaxrpcServiceUrl);
                AnnuityMgmtSvcEJB3JAXRPCImplLocator locator = new AnnuityMgmtSvcEJB3JAXRPCImplLocator();
                port = locator.getAnnuityMgmtSvcEJB3JAXRPCImplPort(endPoint);
                logger.fine("the ws port is: " + port);
            }
            return new EJB30JAXRPJAXRPCCServiceProxy(port);
        }
        catch (MalformedURLException e) {
            logger.info("The url is invalid.  url value is: " + jaxrpcServiceUrl);
            throw new InvalidConfigurationException("The url is invalid.  url value is: " + jaxrpcServiceUrl + ". Error: " + ExceptionFormatter.deepFormatToString((Throwable)e) + logger.getAllLogs());
        }
        catch (ServiceException e) {
            logger.info("Service Exception - The url is invalid.  url value is: " + jaxrpcServiceUrl);
            throw new InvalidConfigurationException("The url is invalid.  url value is: " + jaxrpcServiceUrl + ". Error: " + ExceptionFormatter.deepFormatToString((Throwable)e) + logger.getAllLogs());
        }
    }
}

