/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.servicelookup.jaxrpc2pojojaxws;

import com.ibm.wssvt.acme.annuity.common.business.IAnnuityService;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.jaxrpc2pojojaxwsimpl.AnnuityMgmtSvcPojoJAXWS;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.jaxrpc2pojojaxwsimpl.AnnuityMgmtSvcPojoJAXWSImpl;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.jaxrpc2pojojaxwsimpl.AnnuityMgmtSvcPojoJAXWSImplLocator;
import com.ibm.wssvt.acme.annuity.common.servicelookup.jaxrpc2pojojaxws.AnnuityJAXRPCToPojoJAXWSServiceProxy;
import com.ibm.wssvt.acme.common.bean.Configrable;
import com.ibm.wssvt.acme.common.exception.ExceptionFormatter;
import com.ibm.wssvt.acme.common.exception.InvalidConfigurationException;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.rpc.ServiceException;

public class JAXRPCToPojoJAXWSServiceLookup {
    private static final String JAXWS_SERVICE_URL_KEY = "JAXWSServiceURL";

    public static IAnnuityService getAnnuityJAXWSService(AnnuityMgmtSvcPojoJAXWSImpl injectedService, Configrable<String, String> configrable, AcmeLogger logger) throws InvalidConfigurationException {
        String jaxwsServiceURL = (String)configrable.getConfiguration().getParameterValue((Object)JAXWS_SERVICE_URL_KEY);
        try {
            AnnuityMgmtSvcPojoJAXWS port;
            if (injectedService != null) {
                logger.fine("using injected service: " + injectedService);
                URL endPoint = new URL(jaxwsServiceURL);
                port = injectedService.getAnnuityMgmtSvcPojoJAXWSImplPort(endPoint);
                logger.fine("using injected service port: " + port);
            } else {
                URL endPoint = new URL(jaxwsServiceURL);
                AnnuityMgmtSvcPojoJAXWSImplLocator locator = new AnnuityMgmtSvcPojoJAXWSImplLocator();
                port = locator.getAnnuityMgmtSvcPojoJAXWSImplPort(endPoint);
                logger.fine("the ws port is: " + port);
            }
            return new AnnuityJAXRPCToPojoJAXWSServiceProxy(port);
        }
        catch (MalformedURLException e) {
            logger.info("The url is invalid.  url value is: " + jaxwsServiceURL);
            throw new InvalidConfigurationException("The url is invalid.  url value is: " + jaxwsServiceURL + ". Error: " + ExceptionFormatter.deepFormatToString((Throwable)e) + logger.getAllLogs());
        }
        catch (ServiceException e) {
            logger.info("Service Exception - The url is invalid.  url value is: " + jaxwsServiceURL);
            throw new InvalidConfigurationException("The url is invalid.  url value is: " + jaxwsServiceURL + ". Error: " + ExceptionFormatter.deepFormatToString((Throwable)e) + logger.getAllLogs());
        }
    }
}

