/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.servicelookup.pojojaxws;

import com.ibm.wssvt.acme.annuity.common.bean.IAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.bean.IContact;
import com.ibm.wssvt.acme.annuity.common.bean.IPayor;
import com.ibm.wssvt.acme.annuity.common.bean.IPayout;
import com.ibm.wssvt.acme.annuity.common.bean.IRider;
import com.ibm.wssvt.acme.annuity.common.bean.jaxbjpa.AnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.bean.jaxbjpa.AnnuityValueObject;
import com.ibm.wssvt.acme.annuity.common.bean.jaxbjpa.Contact;
import com.ibm.wssvt.acme.annuity.common.bean.jaxbjpa.Payor;
import com.ibm.wssvt.acme.annuity.common.bean.jaxbjpa.PayoutValueObject;
import com.ibm.wssvt.acme.annuity.common.bean.jaxbjpa.Rider;
import com.ibm.wssvt.acme.annuity.common.business.IAnnuityService;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.pojoimpl.AnnuityMgmtSvcPojoJAXWS;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.pojoimpl.CreateAnnuityHolderResponse;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.pojoimpl.CreateAnnuityResponse;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.pojoimpl.CreateContactResponse;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.pojoimpl.CreatePayorResponse;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.pojoimpl.CreatePayoutResponse;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.pojoimpl.DeleteAnnuityHolderResponse;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.pojoimpl.DeleteAnnuityResponse;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.pojoimpl.DeleteContactResponse;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.pojoimpl.DeletePayorResponse;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.pojoimpl.DeletePayoutResponse;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.pojoimpl.DeleteRiderResponse;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.pojoimpl.EntityAlreadyExistsException_Exception;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.pojoimpl.EntityNotFoundException_Exception;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.pojoimpl.FindAnnuityByIdResponse;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.pojoimpl.FindAnnuityHolderResponse;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.pojoimpl.FindContactByIdResponse;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.pojoimpl.FindHolderAnnuitiesResponse;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.pojoimpl.FindHolderByIdResponse;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.pojoimpl.FindPayorAnnuitiesResponse;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.pojoimpl.FindPayorByIdResponse;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.pojoimpl.FindPayoutByIdResponse;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.pojoimpl.FindRiderByIdResponse;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.pojoimpl.InvalidArgumentException_Exception;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.pojoimpl.ServerBusinessModuleException_Exception;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.pojoimpl.ServerPersistenceModuleException_Exception;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.pojoimpl.UpdateAnnuityHolderResponse;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.pojoimpl.UpdateAnnuityResponse;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.pojoimpl.UpdateContactResponse;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.pojoimpl.UpdatePayorResponse;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.pojoimpl.UpdatePayoutResponse;
import com.ibm.wssvt.acme.annuity.common.exception.EntityAlreadyExistsException;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerBusinessModuleException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerPersistenceModuleException;
import com.ibm.wssvt.acme.common.bean.Configrable;
import com.ibm.wssvt.acme.common.exception.ExceptionFormatter;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import javax.xml.ws.Response;

public class AnnuityJAXWSServiceProxyAsync
implements IAnnuityService {
    private AnnuityMgmtSvcPojoJAXWS webService;
    private AcmeLogger logger;

    public AnnuityJAXWSServiceProxyAsync(AnnuityMgmtSvcPojoJAXWS webServiceInterface, AcmeLogger logger) {
        this.webService = webServiceInterface;
        this.logger = logger;
    }

    @Override
    public IAnnuity createAnnuity(IAnnuity annuity) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        AnnuityValueObject result = null;
        try {
            AnnuityValueObject annuityValueObject = new AnnuityValueObject();
            annuityValueObject.setAnnuity(annuity);
            Response<CreateAnnuityResponse> response = this.webService.createAnnuityAsync(annuityValueObject);
            this.waitAndCheckForValidResponse(response, annuity);
            annuityValueObject.getAnnuity();
            result = ((CreateAnnuityResponse)response.get()).getReturn();
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.processEntityAlreadyExistsException(cause);
            this.processCommonException(cause);
        }
        return result == null ? null : result.getAnnuity();
    }

    @Override
    public IAnnuity findAnnuityById(IAnnuity annuity) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        AnnuityValueObject result = null;
        try {
            AnnuityValueObject annuityValueObject = new AnnuityValueObject();
            annuityValueObject.setAnnuity(annuity);
            Response<FindAnnuityByIdResponse> response = this.webService.findAnnuityByIdAsync(annuityValueObject);
            this.waitAndCheckForValidResponse(response, annuity);
            annuityValueObject.getAnnuity();
            result = ((FindAnnuityByIdResponse)response.get()).getReturn();
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.processEntityNotFoundException(cause);
            this.processCommonException(cause);
        }
        return result == null ? null : result.getAnnuity();
    }

    @Override
    public IAnnuityHolder findAnnuityHolder(IAnnuity annuity) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        AnnuityHolder result = null;
        try {
            AnnuityValueObject annuityValueObject = new AnnuityValueObject();
            annuityValueObject.setAnnuity(annuity);
            Response<FindAnnuityHolderResponse> response = this.webService.findAnnuityHolderAsync(annuityValueObject);
            this.waitAndCheckForValidResponse(response, annuity);
            annuityValueObject.getAnnuity();
            result = ((FindAnnuityHolderResponse)response.get()).getReturn();
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.processEntityNotFoundException(cause);
            this.processCommonException(cause);
        }
        return result;
    }

    @Override
    public IContact findContactById(IContact contact) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        Contact result = null;
        try {
            Response<FindContactByIdResponse> response = this.webService.findContactByIdAsync((Contact)contact);
            this.waitAndCheckForValidResponse(response, contact);
            result = ((FindContactByIdResponse)response.get()).getReturn();
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.processEntityNotFoundException(cause);
            this.processCommonException(cause);
        }
        return result;
    }

    @Override
    public List<IAnnuity> findHolderAnnuities(IAnnuityHolder annuityHolder) throws ServerInternalErrorException, InvalidArgumentException {
        ArrayList<IAnnuity> result = new ArrayList<IAnnuity>();
        List<Object> tempList = new ArrayList();
        try {
            Response<FindHolderAnnuitiesResponse> response = this.webService.findHolderAnnuitiesAsync((AnnuityHolder)annuityHolder);
            this.waitAndCheckForValidResponse(response, annuityHolder);
            tempList = ((FindHolderAnnuitiesResponse)response.get()).getReturn();
            for (AnnuityValueObject annuityValueObject : tempList) {
                result.add(annuityValueObject.getAnnuity());
            }
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.processCommonException(cause);
        }
        return result;
    }

    @Override
    public IAnnuityHolder findHolderById(IAnnuityHolder annuityHolder) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        AnnuityHolder result = null;
        try {
            Response<FindHolderByIdResponse> response = this.webService.findHolderByIdAsync((AnnuityHolder)annuityHolder);
            this.waitAndCheckForValidResponse(response, annuityHolder);
            result = ((FindHolderByIdResponse)response.get()).getReturn();
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.processEntityNotFoundException(cause);
            this.processCommonException(cause);
        }
        return result;
    }

    @Override
    public List<IAnnuity> findPayorAnnuities(IPayor payor) throws ServerInternalErrorException, InvalidArgumentException {
        ArrayList<IAnnuity> result = null;
        try {
            Response<FindPayorAnnuitiesResponse> response = this.webService.findPayorAnnuitiesAsync((Payor)payor);
            this.waitAndCheckForValidResponse(response, payor);
            List<AnnuityValueObject> tempList = ((FindPayorAnnuitiesResponse)response.get()).getReturn();
            if (tempList != null) {
                result = new ArrayList<IAnnuity>();
                for (AnnuityValueObject object : tempList) {
                    result.add(object.getAnnuity());
                }
            }
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.processCommonException(cause);
        }
        return result;
    }

    @Override
    public IPayor findPayorById(IPayor payor) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        Payor result = null;
        try {
            Response<FindPayorByIdResponse> response = this.webService.findPayorByIdAsync((Payor)payor);
            this.waitAndCheckForValidResponse(response, payor);
            result = ((FindPayorByIdResponse)response.get()).getReturn();
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.processEntityNotFoundException(cause);
            this.processCommonException(cause);
        }
        return result;
    }

    @Override
    public IPayout findPayoutById(IPayout payout) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        PayoutValueObject result = null;
        try {
            PayoutValueObject in = new PayoutValueObject();
            in.setPayout(payout);
            Response<FindPayoutByIdResponse> response = this.webService.findPayoutByIdAsync(in);
            this.waitAndCheckForValidResponse(response, payout);
            in.getPayout();
            result = ((FindPayoutByIdResponse)response.get()).getReturn();
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.processEntityNotFoundException(cause);
            this.processCommonException(cause);
        }
        return result == null ? null : result.getPayout();
    }

    @Override
    public IRider findRiderById(IRider rider) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        Rider result = null;
        try {
            Response<FindRiderByIdResponse> response = this.webService.findRiderByIdAsync((Rider)rider);
            this.waitAndCheckForValidResponse(response, rider);
            result = ((FindRiderByIdResponse)response.get()).getReturn();
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.processEntityNotFoundException(cause);
            this.processCommonException(cause);
        }
        return result;
    }

    @Override
    public IAnnuityHolder createAnnuityHolder(IAnnuityHolder annHolder) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        AnnuityHolder result = null;
        try {
            Response<CreateAnnuityHolderResponse> response = this.webService.createAnnuityHolderAsync((AnnuityHolder)annHolder);
            this.waitAndCheckForValidResponse(response, annHolder);
            result = ((CreateAnnuityHolderResponse)response.get()).getReturn();
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.processEntityAlreadyExistsException(cause);
            this.processCommonException(cause);
        }
        return result;
    }

    @Override
    public IContact createContact(IContact contact) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        Contact result = null;
        try {
            Response<CreateContactResponse> response = this.webService.createContactAsync((Contact)contact);
            this.waitAndCheckForValidResponse(response, contact);
            result = ((CreateContactResponse)response.get()).getReturn();
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.processEntityAlreadyExistsException(cause);
            this.processCommonException(cause);
        }
        return result;
    }

    @Override
    public IPayor createPayor(IPayor payor) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        Payor result = null;
        try {
            Response<CreatePayorResponse> response = this.webService.createPayorAsync((Payor)payor);
            this.waitAndCheckForValidResponse(response, payor);
            result = ((CreatePayorResponse)response.get()).getReturn();
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.processEntityAlreadyExistsException(cause);
            this.processCommonException(cause);
        }
        return result;
    }

    @Override
    public IPayout createPayout(IPayout payout) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        PayoutValueObject result = null;
        try {
            PayoutValueObject in = new PayoutValueObject();
            in.setPayout(payout);
            Response<CreatePayoutResponse> response = this.webService.createPayoutAsync(in);
            this.waitAndCheckForValidResponse(response, payout);
            in.getPayout();
            result = ((CreatePayoutResponse)response.get()).getReturn();
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.processEntityAlreadyExistsException(cause);
            this.processCommonException(cause);
        }
        return result == null ? null : result.getPayout();
    }

    @Override
    public void deleteAnnuity(IAnnuity annuity) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            AnnuityValueObject annuityValueObject = new AnnuityValueObject();
            annuityValueObject.setAnnuity(annuity);
            Response<DeleteAnnuityResponse> response = this.webService.deleteAnnuityAsync(annuityValueObject);
            this.waitAndCheckForValidResponse(response, annuity);
            annuityValueObject.getAnnuity();
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.processCommonException(cause);
        }
    }

    @Override
    public void deleteAnnuityHolder(IAnnuityHolder annHolder) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            Response<DeleteAnnuityHolderResponse> response = this.webService.deleteAnnuityHolderAsync((AnnuityHolder)annHolder);
            this.waitAndCheckForValidResponse(response, annHolder);
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.processCommonException(cause);
        }
    }

    @Override
    public void deleteContact(IContact contact) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            Response<DeleteContactResponse> response = this.webService.deleteContactAsync((Contact)contact);
            this.waitAndCheckForValidResponse(response, contact);
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.processCommonException(cause);
        }
    }

    @Override
    public void deletePayor(IPayor payor) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            Response<DeletePayorResponse> response = this.webService.deletePayorAsync((Payor)payor);
            this.waitAndCheckForValidResponse(response, payor);
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.processCommonException(cause);
        }
    }

    @Override
    public void deletePayout(IPayout payout) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            PayoutValueObject in = new PayoutValueObject();
            in.setPayout(payout);
            Response<DeletePayoutResponse> response = this.webService.deletePayoutAsync(in);
            this.waitAndCheckForValidResponse(response, payout);
            in.getPayout();
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.processCommonException(cause);
        }
    }

    @Override
    public void deleteRider(IRider rider) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            Response<DeleteRiderResponse> response = this.webService.deleteRiderAsync((Rider)rider);
            this.waitAndCheckForValidResponse(response, rider);
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.processCommonException(cause);
        }
    }

    @Override
    public IAnnuity updateAnnuity(IAnnuity annuity) throws ServerInternalErrorException, InvalidArgumentException {
        AnnuityValueObject result = null;
        try {
            AnnuityValueObject annuityValueObject = new AnnuityValueObject();
            annuityValueObject.setAnnuity(annuity);
            Response<UpdateAnnuityResponse> response = this.webService.updateAnnuityAsync(annuityValueObject);
            this.waitAndCheckForValidResponse(response, annuity);
            annuityValueObject.getAnnuity();
            result = ((UpdateAnnuityResponse)response.get()).getReturn();
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.processCommonException(cause);
        }
        return result == null ? null : result.getAnnuity();
    }

    @Override
    public IAnnuityHolder updateAnnuityHolder(IAnnuityHolder annHolder) throws ServerInternalErrorException, InvalidArgumentException {
        AnnuityHolder result = null;
        try {
            Response<UpdateAnnuityHolderResponse> response = this.webService.updateAnnuityHolderAsync((AnnuityHolder)annHolder);
            this.waitAndCheckForValidResponse(response, annHolder);
            result = ((UpdateAnnuityHolderResponse)response.get()).getReturn();
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.processCommonException(cause);
        }
        return result;
    }

    @Override
    public IContact updateContact(IContact contact) throws ServerInternalErrorException, InvalidArgumentException {
        Contact result = null;
        try {
            Response<UpdateContactResponse> response = this.webService.updateContactAsync((Contact)contact);
            this.waitAndCheckForValidResponse(response, contact);
            result = ((UpdateContactResponse)response.get()).getReturn();
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.processCommonException(cause);
        }
        return result;
    }

    @Override
    public IPayor updatePayor(IPayor payor) throws ServerInternalErrorException, InvalidArgumentException {
        Payor result = null;
        try {
            Response<UpdatePayorResponse> response = this.webService.updatePayorAsync((Payor)payor);
            this.waitAndCheckForValidResponse(response, payor);
            result = ((UpdatePayorResponse)response.get()).getReturn();
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.processCommonException(cause);
        }
        return result;
    }

    @Override
    public IPayout updatePayout(IPayout payout) throws ServerInternalErrorException, InvalidArgumentException {
        PayoutValueObject result = null;
        try {
            PayoutValueObject in = new PayoutValueObject();
            in.setPayout(payout);
            Response<UpdatePayoutResponse> response = this.webService.updatePayoutAsync(in);
            this.waitAndCheckForValidResponse(response, payout);
            in.getPayout();
            result = ((UpdatePayoutResponse)response.get()).getReturn();
        }
        catch (InterruptedException e) {
            this.processInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.processCommonException(cause);
        }
        return result == null ? null : result.getPayout();
    }

    private void waitForResponse(Response resp, Configrable<String, String> configrable) throws InterruptedException {
        long waitCount;
        long waitTime;
        try {
            waitTime = Long.parseLong((String)configrable.getConfiguration().getParameterValue((Object)"waitTime"));
            waitCount = Long.parseLong((String)configrable.getConfiguration().getParameterValue((Object)"waitCount"));
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid Configuration.  WaitTime or WaitCount are not valid values.current values are: waitTime:" + (String)configrable.getConfiguration().getParameterValue((Object)"waitTime") + " and waitCount: " + (String)configrable.getConfiguration().getParameterValue((Object)"waitCount"));
        }
        for (long cntr = 0L; cntr <= waitCount; ++cntr) {
            if (resp.isDone()) {
                return;
            }
            this.logger.fine("waiting for response ... wait count: " + cntr);
            Thread.sleep(waitTime);
        }
    }

    private void waitAndCheckForValidResponse(Response response, Configrable<String, String> configrable) throws ServerInternalErrorException, InterruptedException, ExecutionException {
        this.waitForResponse(response, configrable);
        if (response.isDone()) {
            if (response.get() == null) {
                throw new ServerInternalErrorException("The server responded with a null object.  Expected either an error or a non-null object.");
            }
        } else {
            throw new ServerInternalErrorException("The server did not respond in in the expected time.wait values are: waitTime:" + (String)configrable.getConfiguration().getParameterValue((Object)"waitTime") + " and waitCount: " + (String)configrable.getConfiguration().getParameterValue((Object)"waitCount") + " was waiting for Response class: " + response.getClass().getName());
        }
    }

    private void processEntityNotFoundException(Throwable e) throws EntityNotFoundException {
        if (e instanceof EntityNotFoundException_Exception) {
            throw new EntityNotFoundException(e);
        }
    }

    private void processEntityAlreadyExistsException(Throwable e) throws EntityAlreadyExistsException {
        if (e instanceof EntityAlreadyExistsException_Exception) {
            throw new EntityAlreadyExistsException(e);
        }
    }

    private void processInterruptedException(InterruptedException e) {
        this.logger.log(Level.WARNING, "Got an unexpected InterruptedException while waiting for a response object");
        throw new RuntimeException("Got an unexpected InterruptedException while waiting for a response object. error " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
    }

    private void processCommonException(Throwable e) throws ServerInternalErrorException, InvalidArgumentException {
        if (e instanceof InvalidArgumentException_Exception) {
            throw new InvalidArgumentException(e);
        }
        if (e instanceof ServerBusinessModuleException_Exception) {
            throw new ServerBusinessModuleException(e);
        }
        if (e instanceof ServerPersistenceModuleException_Exception) {
            throw new ServerPersistenceModuleException(e);
        }
        this.logger.log(Level.INFO, "unable to detect the type of the exception.  Returning a RuntimeException.  Error is: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        e.printStackTrace();
        throw new RuntimeException("Unexpected error. Erros is: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
    }
}

