package com.ibm.osgi.jpa.jpa2;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.SingularAttribute;

public class NewAPITest extends TestTools
{
  //private UserTransaction userTran;
  private EntityManagerFactory helperEMF;

  private EntityManager em;
  
  // Not injected
  private EntityManager localEM;
  
  @PersistenceUnit(unitName="jpa2Helper")
  public void setHelperEMF(EntityManagerFactory emf) {
    helperEMF = emf;
  }
  
  @PersistenceContext(unitName="jpa2")
  public void setEm(EntityManager em) {
    this.em = em;
  }
  
  void before()
  {
    primeDB();
  }
  
  void after() throws Exception
  {
    if (localEM != null && localEM.isOpen())
      localEM.close();

    //userTran.rollback();
  }
  
  void testCriteriaAPI() throws Exception
  {
    try{      
      //userTran.begin();
      CriteriaBuilder cb = em.getCriteriaBuilder();
      CriteriaQuery<String> cq = cb.createQuery(String.class);
      Root<MagicCard> root = cq.from(MagicCard.class);
      cq = cq.where(cb.equal(root.get("edition"), "Alpha"))
        .select(root.<String>get("rarity"));
      
      TypedQuery<String> tq = em.createQuery(cq);
      if ("Rare".equals(tq.getSingleResult())) {
        logPass("testCriteriaAPI");
      } else {
        logFail("testCriteriaAPI", "Incorrect result: "+tq.getSingleResult());
      }
    } catch (Exception e) {
      logError("testCriteriaAPI", e);
    } finally {
      //userTran.rollback();
    }
  }
  
  void testMetamodelAPI() throws Exception
  {
    try {
      EntityType<MagicCard> et = em.getMetamodel().entity(MagicCard.class);
      SingularAttribute<?, String> idAttr = et.getId(String.class);
      if ("name".equals(idAttr.getName())) {
        logPass("testMetamodelAPI");
      } else {
        logFail("testMetamodelAPI", "Incorrect result: "+idAttr.getName());
      }
    } catch (Exception e) {
      logError("testMetamodelAPI", e);
    }
  }
  
  private void primeDB()
  {
    localEM = helperEMF.createEntityManager();
    localEM.getTransaction().begin();
    localEM.createQuery("DELETE FROM MagicCard a").executeUpdate();

    MagicCard bl = new MagicCard();
    bl.setName("Black Lotus");
    bl.setEdition("Alpha");
    bl.setRarity("Rare");
    
    MagicCard cs = new MagicCard();
    cs.setName("Counterspell");
    cs.setEdition("4ed");
    cs.setRarity("Common");
    
    localEM.persist(bl);
    localEM.persist(cs);
    localEM.getTransaction().commit();
    localEM.close();
  }
}
