/*
 * @start_prolog@
 * ============================================================================
 * IBM Confidential OCO Source Materials
 *
 * 5724-J08, 5724-I63, 5724-H88, 5724-H89, 5655-N02, 5733-W70 Copyright IBM Corp. 2009
 *
 * The source code for this program is not published or otherwise divested
 * of its trade secrets, irrespective of what has been deposited with the
 * U.S. Copyright Office.
 * ============================================================================
 * @end_prolog@
 * 
 * Change activity:
 * 
 * Issue       Date        Name        Description
 * ----------- ----------- --------    ------------------------------------
 * 2976        04-Aug-2009 timoward@uk Support removal of hardcoded sleeps
 * 4089        20-Oct-2009 mahrwald@uk Change copyright
 */
package com.ibm.osgi.jpa.jpa2;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

//import com.ibm.componenttest.logging.ResultLogger;

public class TestTools
{
  //private ResultLogger logger;

  private final static String COMPONENT_TEST = "JPAComponentTest";
  private final static String BUNDLE_NAME = "com.ibm.osgi.jpa.jpa2";

  public void run() throws Exception
  {
    Method setupMethod = null;
    Method teardownMethod = null;
    for (Method m : this.getClass().getDeclaredMethods())
    {
      if (m.getName().equals("before") && m.getParameterTypes().length == 0)
      {
        setupMethod = m;
        m.setAccessible(true);
      }
      
      if (m.getName().equals("after") && m.getParameterTypes().length == 0)
      {
        teardownMethod = m;
        m.setAccessible(true);
      }
    }
    
    for (Method m : this.getClass().getDeclaredMethods())
    {
      if (m.getName().startsWith("test") && m.getParameterTypes().length == 0)
      {
        try {
          if (setupMethod != null)
            setupMethod.invoke(this);
        }
        catch (Exception e) {
          e.printStackTrace();
        }

        m.setAccessible(true);
        try {
          m.invoke(this);
        }
        catch (InvocationTargetException e) {
          logError(m.getName(), e.getCause());
        }
        catch (IllegalAccessException e) {
          logError(m.getName(), e);
        }
        
        try {
          if (teardownMethod != null)
            teardownMethod.invoke(this);
        }
        catch (Exception e) {
          e.printStackTrace();
        }
      }
    }
    //logger.logFinished(BUNDLE_NAME);
    System.out.println(BUNDLE_NAME + ", Finished");
  }
  
  protected void logPass(String test) throws Exception
  {
    //logger.logTestPass(COMPONENT_TEST, BUNDLE_NAME, test);
    System.out.println(COMPONENT_TEST + ", " + BUNDLE_NAME + ", " + test + ", Pass");
  }
  
  protected void logFail(String test, String reason) throws Exception
  {
    //logger.logTestFail(COMPONENT_TEST, BUNDLE_NAME, test, reason);
    System.out.println(COMPONENT_TEST + ", " + BUNDLE_NAME + ", " + test + ", " + reason);
  }
  
  protected void logError(String test, Throwable reason) throws Exception
  {
    //logger.logTestError(COMPONENT_TEST, BUNDLE_NAME, test, reason);
    System.out.println(COMPONENT_TEST + ", " + BUNDLE_NAME + ", " + test + ", " + reason);
  }

}
