/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.ListOrSingle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import wiremock.com.fasterxml.jackson.core.JsonParser;
import wiremock.com.fasterxml.jackson.core.JsonProcessingException;
import wiremock.com.fasterxml.jackson.databind.DeserializationContext;
import wiremock.com.fasterxml.jackson.databind.JsonDeserializer;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.fasterxml.jackson.databind.node.ArrayNode;
import wiremock.com.google.common.collect.Lists;

public class ListOrStringDeserialiser<T>
extends JsonDeserializer<ListOrSingle<T>> {
    @Override
    public ListOrSingle<T> deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode rootNode = (JsonNode)parser.readValueAsTree();
        if (rootNode.isArray()) {
            ArrayNode arrayNode = (ArrayNode)rootNode;
            ArrayList<Object> items = Lists.newArrayList();
            Iterator<JsonNode> i = arrayNode.elements();
            while (i.hasNext()) {
                JsonNode node = i.next();
                Object value = ListOrStringDeserialiser.getValue(node);
                items.add(value);
            }
            return new ListOrSingle(items);
        }
        return new ListOrSingle<Object>(ListOrStringDeserialiser.getValue(rootNode));
    }

    private static Object getValue(JsonNode node) {
        return node.isTextual() ? node.textValue() : (node.isNumber() ? node.numberValue() : (node.isBoolean() ? Boolean.valueOf(node.booleanValue()) : node.textValue()));
    }
}

