/*
 * Decompiled with CFR 0.152.
 */
package wlp.lib.extract;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import wlp.lib.extract.ExtractProgress;
import wlp.lib.extract.LicenseProvider;
import wlp.lib.extract.ReturnCode;
import wlp.lib.extract.SelfExtractUtils;
import wlp.lib.extract.SelfExtractor;

public class SelfExtract {
    private static final ResourceBundle resourceBundle;
    private static BufferedReader in;
    private static boolean acceptLicense;
    private static boolean downloadDependencies;
    private static boolean verbose;
    private static String targetString;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("wlp.lib.extract.SelfExtract");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        resourceBundle = ResourceBundle.getBundle(String.valueOf(clazz.getName()) + "Messages");
        acceptLicense = false;
        downloadDependencies = false;
        verbose = false;
        targetString = null;
    }

    public static void main(String[] args) {
        int code;
        ReturnCode rc = SelfExtractor.buildInstance();
        SelfExtractor extractor = SelfExtractor.getInstance();
        if (rc == ReturnCode.OK) {
            File wlpOutputDir;
            File outputDirFromUser;
            acceptLicense = false;
            if (extractor.isUserSample()) {
                acceptLicense = true;
            }
            downloadDependencies = false;
            extractor.setDoExternalDepsDownload(false);
            verbose = false;
            targetString = null;
            boolean archiveHasLicense = extractor.hasLicense();
            extractor.parseArguments(args, archiveHasLicense);
            if (archiveHasLicense) {
                extractor.handleLicenseAcceptance(extractor, acceptLicense);
            }
            if (targetString == null) {
                File workingDir = new File(System.getProperty("user.dir"));
                File defaultPath = SelfExtract.findValidWlpInstallPath(workingDir, extractor);
                SelfExtract.out("extractInstruction");
                SelfExtract.out("extractDefault", defaultPath.getAbsolutePath());
                System.out.println();
                targetString = SelfExtract.getResponse(String.valueOf(SelfExtract.format("extractPrompt")) + " ");
                targetString = targetString.trim();
                outputDirFromUser = "".equals(targetString) ? defaultPath : new File(targetString);
            } else {
                outputDirFromUser = new File(targetString.trim());
            }
            outputDirFromUser = outputDirFromUser.getAbsoluteFile();
            File outputDir = SelfExtract.findValidWlpInstallPath(outputDirFromUser, extractor);
            if (!outputDir.exists() && !outputDir.mkdirs()) {
                SelfExtract.err("extractDirectoryError", outputDir.getAbsolutePath());
                System.exit(4);
            }
            if ((rc = extractor.validate(wlpOutputDir = new File(outputDir, extractor.getRoot()))) == ReturnCode.OK && (rc = SelfExtract.checkUserWantsExternalDeps(extractor, downloadDependencies)) == ReturnCode.OK) {
                rc = extractor.extract(wlpOutputDir, verbose ? new VerboseExtractProgress() : null);
            }
        }
        if ((code = rc.getCode()) > 0) {
            System.err.println(rc.getErrorMessage());
        } else {
            SelfExtract.out("extractSuccess");
        }
        System.exit(code);
    }

    private static File findValidWlpInstallPath(File searchDirectory, SelfExtractor extractor) {
        File wlpSubdir;
        if (extractor.validate(searchDirectory) == ReturnCode.OK) {
            return searchDirectory;
        }
        if (extractor.isProductAddon() && extractor.validate(wlpSubdir = new File(searchDirectory, "wlp")) == ReturnCode.OK) {
            return wlpSubdir;
        }
        return searchDirectory;
    }

    public static ReturnCode checkUserWantsExternalDeps(SelfExtractor extractor, boolean downloadDependencies) {
        if (extractor.hasExternalDepsFile()) {
            SelfExtractor.ExternalDependencies extDependencies;
            try {
                extDependencies = extractor.getExternalDependencies();
            }
            catch (Exception e) {
                return new ReturnCode(2, "readDepsError", e.getMessage());
            }
            String dependenciesDesc = extDependencies.getDescription();
            List allDependencies = extDependencies.getDependencies();
            boolean enableDependencyDownload = false;
            if (!downloadDependencies) {
                StringBuilder printableDepsList = new StringBuilder();
                printableDepsList.append(dependenciesDesc).append("\n");
                int i = 0;
                while (i < allDependencies.size()) {
                    SelfExtractor.ExternalDependency dependency = (SelfExtractor.ExternalDependency)allDependencies.get(i);
                    printableDepsList.append(dependency.getSourceUrl()).append("\n");
                    ++i;
                }
                printableDepsList.append("\n");
                SelfExtract.out("externalDepsInstruction", printableDepsList.toString());
                enableDependencyDownload = SelfExtract.getResponse(SelfExtract.format("externalDepsPrompt", new Object[]{"[1]", "[2]"}), "1", "2", "1");
            } else {
                enableDependencyDownload = true;
            }
            extractor.setDoExternalDepsDownload(enableDependencyDownload);
        }
        return ReturnCode.OK;
    }

    public static String format(String key) {
        return SelfExtract.format(key, new Object[0]);
    }

    public static String format(String key, Object o) {
        return SelfExtract.format(key, new Object[]{o});
    }

    public static String format(String key, Object[] args) {
        return MessageFormat.format(resourceBundle.getString(key), args);
    }

    public static void wordWrappedOut(String fullLine) {
        List lines = SelfExtractUtils.wordWrap(fullLine, null);
        int i = 0;
        while (i < lines.size()) {
            System.out.println(lines.get(i));
            ++i;
        }
        System.out.flush();
        System.out.println();
    }

    public static void out(String key) {
        SelfExtract.out(key, new Object[0]);
    }

    public static void out(String key, Object o) {
        SelfExtract.out(key, new Object[]{o});
    }

    public static void out(String key, Object[] args) {
        System.out.println(SelfExtract.format(key, args));
    }

    public static void err(String key) {
        SelfExtract.err(key, new Object[0]);
    }

    public static void err(String key, Object o) {
        SelfExtract.err(key, new Object[]{o});
    }

    public static void err(String key, Object[] args) {
        System.err.println(SelfExtract.format(key, args));
    }

    public static BufferedReader in() {
        if (in == null) {
            in = new BufferedReader(new InputStreamReader(System.in));
        }
        return in;
    }

    public static String getResponse(String promptString) {
        String input = null;
        System.out.print(promptString);
        try {
            input = SelfExtract.in().readLine();
        }
        catch (IOException ioe) {
            SelfExtract.err("inputException", ioe.getMessage());
        }
        if (input == null) {
            System.exit(3);
        }
        return input;
    }

    public static boolean getResponse(String promptString, String yes, String no) {
        return SelfExtract.getResponse(promptString, yes, no, null);
    }

    public static boolean getResponse(String promptString, String yes, String no, String defaultValue) {
        promptString = String.valueOf(promptString) + " ";
        String input = null;
        while (true) {
            if ((input = SelfExtract.getResponse(promptString)).length() == 0) {
                if (defaultValue != null) {
                    input = defaultValue;
                } else {
                    if (yes.length() == 0) {
                        return true;
                    }
                    if (no.length() == 0) {
                        return false;
                    }
                }
            }
            if (input.length() != 1) continue;
            if (yes.indexOf(input.charAt(0)) > -1) {
                return true;
            }
            if (no.indexOf(input.charAt(0)) > -1) break;
        }
        return false;
    }

    public static void setAcceptLicense(boolean b) {
        acceptLicense = b;
    }

    public static void setVerbose(boolean b) {
        verbose = b;
    }

    public static void setDownloadDependencies(boolean b) {
        downloadDependencies = b;
    }

    public static void setTargetString(String string) {
        targetString = string;
    }

    public static void showLicenseFile(InputStream licenseFile) {
        SelfExtractor.buildInstance();
        SelfExtractor extractor = SelfExtractor.getInstance();
        extractor.showLicenseFile(licenseFile);
    }

    public static void handleLicenseAcceptance(LicenseProvider licenseProvider, boolean acceptLicense) {
        SelfExtractor.buildInstance();
        SelfExtractor extractor = SelfExtractor.getInstance();
        extractor.handleLicenseAcceptance(licenseProvider, acceptLicense);
    }

    private static final class VerboseExtractProgress
    implements ExtractProgress {
        private VerboseExtractProgress() {
        }

        public void extractedFile(String f) {
            System.out.println("\t" + f);
        }

        public void downloadingFile(URL sourceUrl, File targetFile) {
            SelfExtract.out("downloadingFileNotice", new Object[]{sourceUrl.toString(), targetFile.getAbsolutePath()});
        }

        public void dataDownloaded(int numBytes) {
        }

        public void setFilesToExtract(int count) {
        }

        public void commandRun(List args) {
            StringBuffer cmdString = new StringBuffer();
            int i = 0;
            while (i < args.size()) {
                cmdString.append(args.get(i)).append(' ');
                ++i;
            }
            cmdString.setLength(cmdString.length() - 1);
            System.out.println(cmdString);
        }

        public void commandsToRun(int count) {
        }

        public boolean isCanceled() {
            return false;
        }

        public void skippedFile() {
        }
    }
}

