/*
 * Decompiled with CFR 0.152.
 */
package wlp.lib.extract;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import wlp.lib.extract.ExtractProgress;
import wlp.lib.extract.LicenseProvider;
import wlp.lib.extract.ReturnCode;
import wlp.lib.extract.SelfExtractUtils;
import wlp.lib.extract.SelfExtractor;

public class SelfExtract {
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle(SelfExtract.class.getName() + "Messages");
    private static BufferedReader in;

    public static void main(String[] args) {
        int code;
        ReturnCode rc = SelfExtractor.buildInstance();
        SelfExtractor extractor = SelfExtractor.getInstance();
        if (rc == ReturnCode.OK) {
            File wlpOutputDir;
            File outputDirFromUser;
            boolean acceptLicense = false;
            if (extractor.isUserSample()) {
                acceptLicense = true;
            }
            boolean downloadDependencies = false;
            extractor.setDoExternalDepsDownload(false);
            boolean verbose = false;
            String targetString = null;
            boolean archiveHasLicense = extractor.hasLicense();
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i].trim().toLowerCase(Locale.ENGLISH);
                if (arg.startsWith("-")) {
                    if (SelfExtract.argIsOption(arg, "-viewlicenseagreement")) {
                        if (archiveHasLicense) {
                            SelfExtract.showLicenseFile(extractor.getLicenseAgreement());
                        } else {
                            SelfExtract.out("archiveContainsNoLicense");
                        }
                        System.exit(0);
                        continue;
                    }
                    if (SelfExtract.argIsOption(arg, "-viewlicenseinfo") || SelfExtract.argIsOption(arg, "-viewlicenseinformation")) {
                        if (archiveHasLicense) {
                            SelfExtract.showLicenseFile(extractor.getLicenseInformation());
                        } else {
                            SelfExtract.out("archiveContainsNoLicense");
                        }
                        System.exit(0);
                        continue;
                    }
                    if (SelfExtract.argIsOption(arg, "-help")) {
                        SelfExtract.displayCommandLineHelp(extractor);
                        System.exit(0);
                        continue;
                    }
                    if (SelfExtract.argIsOption(arg, "-acceptlicense")) {
                        acceptLicense = true;
                        continue;
                    }
                    if (SelfExtract.argIsOption(arg, "-downloadDependencies")) {
                        downloadDependencies = true;
                        continue;
                    }
                    if (SelfExtract.argIsOption(arg, "-verbose")) {
                        verbose = true;
                        continue;
                    }
                    System.out.println("\n" + SelfExtract.format("invalidOption", arg));
                    SelfExtract.displayCommandLineHelp(extractor);
                    System.exit(0);
                    continue;
                }
                targetString = args[i];
            }
            if (archiveHasLicense) {
                SelfExtract.handleLicenseAcceptance(extractor, acceptLicense);
            }
            if (targetString == null) {
                File workingDir = new File(System.getProperty("user.dir"));
                File defaultPath = SelfExtract.findValidWlpInstallPath(workingDir, extractor);
                SelfExtract.out("extractInstruction");
                SelfExtract.out("extractDefault", defaultPath.getAbsolutePath());
                System.out.println();
                targetString = SelfExtract.getResponse(SelfExtract.format("extractPrompt") + " ");
                targetString = targetString.trim();
                outputDirFromUser = "".equals(targetString) ? defaultPath : new File(targetString);
            } else {
                outputDirFromUser = new File(targetString.trim());
            }
            outputDirFromUser = outputDirFromUser.getAbsoluteFile();
            File outputDir = SelfExtract.findValidWlpInstallPath(outputDirFromUser, extractor);
            if (!outputDir.exists() && !outputDir.mkdirs()) {
                SelfExtract.err("extractDirectoryError", outputDir.getAbsolutePath());
                System.exit(4);
            }
            if ((rc = extractor.validate(wlpOutputDir = new File(outputDir, extractor.getRoot()))) == ReturnCode.OK && (rc = SelfExtract.checkUserWantsExternalDeps(extractor, downloadDependencies)) == ReturnCode.OK) {
                rc = extractor.extract(wlpOutputDir, verbose ? new VerboseExtractProgress() : null);
            }
        }
        if ((code = rc.getCode()) > 0) {
            System.err.println(rc.getErrorMessage());
        } else {
            SelfExtract.out("extractSuccess");
        }
        System.exit(code);
    }

    private static File findValidWlpInstallPath(File searchDirectory, SelfExtractor extractor) {
        File wlpSubdir;
        if (extractor.validate(searchDirectory) == ReturnCode.OK) {
            return searchDirectory;
        }
        if (extractor.isProductAddon() && extractor.validate(wlpSubdir = new File(searchDirectory, "wlp")) == ReturnCode.OK) {
            return wlpSubdir;
        }
        return searchDirectory;
    }

    public static ReturnCode checkUserWantsExternalDeps(SelfExtractor extractor, boolean downloadDependencies) {
        if (extractor.hasExternalDepsFile()) {
            SelfExtractor.ExternalDependencies extDependencies;
            try {
                extDependencies = extractor.getExternalDependencies();
            }
            catch (Exception e) {
                return new ReturnCode(2, "readDepsError", e.getMessage());
            }
            String dependenciesDesc = extDependencies.getDescription();
            List allDependencies = extDependencies.getDependencies();
            boolean enableDependencyDownload = false;
            if (!downloadDependencies) {
                StringBuilder printableDepsList = new StringBuilder();
                printableDepsList.append(dependenciesDesc).append("\n");
                for (int i = 0; i < allDependencies.size(); ++i) {
                    SelfExtractor.ExternalDependency dependency = (SelfExtractor.ExternalDependency)allDependencies.get(i);
                    printableDepsList.append(dependency.getSourceUrl()).append("\n");
                }
                printableDepsList.append("\n");
                SelfExtract.out("externalDepsInstruction", printableDepsList.toString());
                enableDependencyDownload = SelfExtract.getResponse(SelfExtract.format("externalDepsPrompt", new Object[]{"[1]", "[2]"}), "1", "2", "1");
            } else {
                enableDependencyDownload = true;
            }
            extractor.setDoExternalDepsDownload(enableDependencyDownload);
        }
        return ReturnCode.OK;
    }

    private static void displayCommandLineHelp(SelfExtractor extractor) {
        String jarName = System.getProperty("sun.java.command", "wlp-liberty-developers-core.jar");
        String[] s = jarName.split(" ");
        jarName = s[0];
        System.out.println("\n" + SelfExtract.format("usage"));
        System.out.println("\njava -jar " + jarName + " [" + SelfExtract.format("options") + "] [" + SelfExtract.format("installLocation") + "]\n");
        System.out.println(SelfExtract.format("options"));
        System.out.println("    --acceptLicense");
        System.out.println("        " + SelfExtract.format("helpAcceptLicense"));
        System.out.println("    --verbose");
        System.out.println("        " + SelfExtract.format("helpVerbose"));
        System.out.println("    --viewLicenseAgreement");
        System.out.println("        " + SelfExtract.format("helpAgreement"));
        System.out.println("    --viewLicenseInfo");
        System.out.println("        " + SelfExtract.format("helpInformation"));
        if (extractor.isUserSample()) {
            System.out.println("    --downloadDependencies");
            System.out.println("        " + SelfExtract.format("helpDownloadDependencies"));
        }
    }

    public static void handleLicenseAcceptance(LicenseProvider licenseProvider, boolean acceptLicense) {
        SelfExtract.wordWrappedOut(SelfExtract.format("licenseStatement", new Object[]{licenseProvider.getProgramName(), licenseProvider.getLicenseName()}));
        System.out.println();
        if (acceptLicense) {
            SelfExtract.wordWrappedOut(SelfExtract.format("licenseAccepted", "--acceptLicense"));
            System.out.println();
        } else if (!SelfExtract.obtainLicenseAgreement(licenseProvider)) {
            System.exit(0);
        }
    }

    private static boolean obtainLicenseAgreement(LicenseProvider licenseProvider) {
        SelfExtract.wordWrappedOut(SelfExtract.format("showAgreement", "--viewLicenseAgreement"));
        boolean view = SelfExtract.getResponse(SelfExtract.format("promptAgreement"), "", "xX");
        if (view) {
            SelfExtract.showLicenseFile(licenseProvider.getLicenseAgreement());
            System.out.println();
        }
        SelfExtract.wordWrappedOut(SelfExtract.format("showInformation", "--viewLicenseInfo"));
        view = SelfExtract.getResponse(SelfExtract.format("promptInfo"), "", "xX");
        if (view) {
            SelfExtract.showLicenseFile(licenseProvider.getLicenseInformation());
            System.out.println();
        }
        System.out.println();
        SelfExtract.wordWrappedOut(SelfExtract.format("licenseOptionDescription"));
        System.out.println();
        boolean accept = SelfExtract.getResponse(SelfExtract.format("licensePrompt", new Object[]{"[1]", "[2]"}), "1", "2");
        System.out.println();
        return accept;
    }

    public static void showLicenseFile(InputStream licenseFile) {
        Serializable e;
        Class clazz = e = SelfExtract.class;
        if (licenseFile != null) {
            e = SelfExtractUtils.showLicenseFile(licenseFile);
        }
        if (e != null) {
            SelfExtract.err("licenseNotFound");
            System.exit(2);
        }
    }

    private static boolean argIsOption(String arg, String option) {
        return arg.equalsIgnoreCase(option) || arg.equalsIgnoreCase('-' + option);
    }

    private static String format(String key) {
        return SelfExtract.format(key, new Object[0]);
    }

    private static String format(String key, Object o) {
        return SelfExtract.format(key, new Object[]{o});
    }

    private static String format(String key, Object[] args) {
        return MessageFormat.format(resourceBundle.getString(key), args);
    }

    private static void wordWrappedOut(String fullLine) {
        List lines = SelfExtractUtils.wordWrap(fullLine, null);
        for (int i = 0; i < lines.size(); ++i) {
            System.out.println(lines.get(i));
        }
        System.out.flush();
        System.out.println();
    }

    private static void out(String key) {
        SelfExtract.out(key, new Object[0]);
    }

    private static void out(String key, Object o) {
        SelfExtract.out(key, new Object[]{o});
    }

    static void out(String key, Object[] args) {
        System.out.println(SelfExtract.format(key, args));
    }

    private static void err(String key) {
        SelfExtract.err(key, new Object[0]);
    }

    private static void err(String key, Object o) {
        SelfExtract.err(key, new Object[]{o});
    }

    private static void err(String key, Object[] args) {
        System.err.println(SelfExtract.format(key, args));
    }

    private static BufferedReader in() {
        if (in == null) {
            in = new BufferedReader(new InputStreamReader(System.in));
        }
        return in;
    }

    private static String getResponse(String promptString) {
        String input = null;
        System.out.print(promptString);
        try {
            input = SelfExtract.in().readLine();
        }
        catch (IOException ioe) {
            SelfExtract.err("inputException", ioe.getMessage());
        }
        if (input == null) {
            System.exit(3);
        }
        return input;
    }

    private static boolean getResponse(String promptString, String yes, String no) {
        return SelfExtract.getResponse(promptString, yes, no, null);
    }

    private static boolean getResponse(String promptString, String yes, String no, String defaultValue) {
        promptString = promptString + " ";
        String input = null;
        while (true) {
            if ((input = SelfExtract.getResponse(promptString)).length() == 0) {
                if (defaultValue != null) {
                    input = defaultValue;
                } else {
                    if (yes.length() == 0) {
                        return true;
                    }
                    if (no.length() == 0) {
                        return false;
                    }
                }
            }
            if (input.length() != 1) continue;
            if (yes.indexOf(input.charAt(0)) > -1) {
                return true;
            }
            if (no.indexOf(input.charAt(0)) > -1) break;
        }
        return false;
    }

    private static final class VerboseExtractProgress
    implements ExtractProgress {
        private VerboseExtractProgress() {
        }

        public void extractedFile(String f) {
            System.out.println("\t" + f);
        }

        public void downloadingFile(URL sourceUrl, File targetFile) {
            SelfExtract.out("downloadingFileNotice", new Object[]{sourceUrl.toString(), targetFile.getAbsolutePath()});
        }

        public void dataDownloaded(int numBytes) {
        }

        public void setFilesToExtract(int count) {
        }

        public void commandRun(List args) {
            StringBuffer cmdString = new StringBuffer();
            for (int i = 0; i < args.size(); ++i) {
                cmdString.append(args.get(i)).append(' ');
            }
            cmdString.setLength(cmdString.length() - 1);
            System.out.println(cmdString);
        }

        public void commandsToRun(int count) {
        }

        public boolean isCanceled() {
            return false;
        }

        public void skippedFile() {
        }
    }
}

