/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.svt.gs.ejb;

import com.ibm.websphere.svt.cc.ejb.session.CCManagerRemote;
import com.ibm.websphere.svt.cc.wrapper.CCInfoWrapper;
import com.ibm.websphere.svt.gs.cart.CartItem;
import com.ibm.websphere.svt.gs.ejb.CategoryLocal;
import com.ibm.websphere.svt.gs.ejb.CustomerInfoLocal;
import com.ibm.websphere.svt.gs.ejb.CustomerLocal;
import com.ibm.websphere.svt.gs.ejb.InventoryLocal;
import com.ibm.websphere.svt.gs.ejb.MfgCategoryLocal;
import com.ibm.websphere.svt.gs.ejb.SettingsLocal;
import com.ibm.websphere.svt.gs.ejb.StoreCreditLocal;
import com.ibm.websphere.svt.gs.util.EJBUtils;
import com.ibm.websphere.svt.gs.wrapper.CategoryWrapper;
import com.ibm.websphere.svt.gs.wrapper.CustomerInfoWrapper;
import com.ibm.websphere.svt.gs.wrapper.CustomerWrapper;
import com.ibm.websphere.svt.gs.wrapper.InventoryWrapper;
import com.ibm.websphere.svt.gs.wrapper.MfgCategoryWrapper;
import com.ibm.websphere.svt.gs.wrapper.PaymentInfoWrapper;
import com.ibm.websphere.svt.gs.wrapper.SettingsWrapper;
import com.ibm.websphere.svt.gs.wrapper.ShoppingCartWrapper;
import com.ibm.websphere.svt.wsbank.ejb.BankManager;
import com.ibm.websphere.svt.wsn.WSNProxy;
import com.ibm.websphere.svt.wsn.utils.WSNUtils;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.Session;
import javax.sql.DataSource;
import javax.transaction.UserTransaction;

public class StoreManagerBean
implements SessionBean {
    private static String componentName = "com.ibm.websphere.svt.gs.ejb";
    private static Logger logger = Logger.getLogger(componentName);
    private static String className = StoreManagerBean.class.getName();
    private static int settingsID = 1;
    private static Random random = new Random();
    private static SettingsWrapper settings = null;
    private SessionContext mySessionCtx;
    static final long serialVersionUID = 3206093459760846163L;

    public boolean checkOut(String custID, Vector cart) {
        boolean checkOutCompleted;
        block21: {
            CustomerWrapper customerWrapper;
            PaymentInfoWrapper paymentInfo;
            String username;
            int tempInvoiceCount;
            CustomerLocal customer;
            boolean sdoEnabled;
            String methodName;
            block20: {
                CustomerInfoLocal customerInfo;
                boolean wsatEnabled;
                block19: {
                    block18: {
                        block17: {
                            methodName = "checkOut";
                            checkOutCompleted = false;
                            try {
                                if (settings == null) {
                                    this.initializeSettings();
                                }
                                wsatEnabled = settings.isWsatEnabled();
                                boolean wsnEnabled = settings.isWsnEnabled();
                                sdoEnabled = settings.isSdoEnabled();
                                customer = EJBUtils.findCustomerByPrimaryKeyForUpdate(custID);
                                if (customer != null) break block17;
                                logger.logp(Level.INFO, className, methodName, "null customer? how come?");
                                return false;
                            }
                            catch (Exception e) {
                                logger.logp(Level.SEVERE, className, methodName, e.getMessage());
                                e.printStackTrace();
                                return false;
                            }
                        }
                        customerInfo = EJBUtils.findCustomerInfoByPrimaryKey(custID);
                        if (customerInfo != null) break block18;
                        logger.logp(Level.INFO, className, methodName, "null customerInfo? How come?");
                        return false;
                    }
                    if (cart != null && !cart.isEmpty()) break block19;
                    logger.logp(Level.INFO, className, methodName, "empty cart? why bother checkOut?");
                    return false;
                }
                float totalBill = this.calculateCart(cart);
                logger.logp(Level.FINER, className, methodName, "totalBill: " + totalBill);
                tempInvoiceCount = customer.getNumInvoicesCreated();
                username = customer.getCustName();
                String userpwd = customer.getCustPwd();
                customer.setNumInvoicesCreated(tempInvoiceCount + 1);
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, className, methodName, "Customer: " + username + " with password: " + userpwd + " has " + customer.getNumInvoicesCreated() + " invoices");
                }
                paymentInfo = new PaymentInfoWrapper();
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, className, methodName, "take a look at the paymentinfo, account: " + paymentInfo.getAccountNumber() + " amount: " + paymentInfo.getAmount() + " trackingNumber: " + paymentInfo.getTrackingNumber());
                }
                if (wsatEnabled) {
                    logger.logp(Level.FINEST, className, methodName, "WSAT enabled");
                    paymentInfo.setAccountNumber(customerInfo.getCcNum());
                } else {
                    logger.logp(Level.FINEST, className, methodName, "WSAT not enabled");
                    paymentInfo.setAccountNumber(username);
                }
                paymentInfo.setAmount(totalBill);
                customerWrapper = this.getCustomer(username, userpwd);
                if (customerWrapper != null) break block20;
                return false;
            }
            CustomerInfoWrapper customerInfoWrapper = this.getCustomerInfo(username);
            if (this.validateCreditCard(paymentInfo, customerInfoWrapper)) {
                if (sdoEnabled) {
                    logger.logp(Level.FINER, className, methodName, "SDO Enabled");
                    ShoppingCartWrapper shoppingCart = new ShoppingCartWrapper();
                    shoppingCart.setCartItems(cart);
                    shoppingCart.setCustomerInfoWrapper(customerInfoWrapper);
                    shoppingCart.setCustomerWrapper(customerWrapper);
                    shoppingCart.setPaymentInfoWrapper(paymentInfo);
                    boolean addInvoiceCompleted = this.addInvoiceToShippingQueue(shoppingCart);
                    if (!addInvoiceCompleted) {
                        logger.logp(Level.INFO, className, methodName, "Add invoice to Shipping Queue failed !!");
                    }
                    checkOutCompleted = this.processTransaction(paymentInfo);
                } else {
                    logger.logp(Level.FINER, className, methodName, "SDO not Enabled");
                    checkOutCompleted = this.processTransaction(paymentInfo);
                    if (checkOutCompleted) {
                        tempInvoiceCount = customer.getNumInvoicesCompleted();
                        customer.setNumInvoicesCompleted(++tempInvoiceCount);
                        if (logger.isLoggable(Level.FINER)) {
                            logger.logp(Level.FINER, className, methodName, "Customer: " + customer.getCustName() + " now has " + tempInvoiceCount + " invoices completed");
                        }
                    }
                }
                break block21;
            }
            logger.logp(Level.FINER, className, methodName, "check credit not good, return false");
            return false;
        }
        return checkOutCompleted;
    }

    private boolean validateCreditCard(PaymentInfoWrapper paymentInfo, CustomerInfoWrapper customerInfo) {
        String methodName = "validateCreditCard";
        boolean cardValidated = false;
        if (settings == null) {
            this.initializeSettings();
        }
        if (settings.isWsatEnabled()) {
            logger.logp(Level.FINER, className, methodName, "WSAT enabled, will have to go to CCManager");
            try {
                CCManagerRemote ccManager = EJBUtils.getCCManager();
                cardValidated = ccManager.validateCard(paymentInfo.getAccountNumber(), customerInfo.getCustID(), customerInfo.getCustID(), customerInfo.getAddress1(), customerInfo.getAddress2());
            }
            catch (Exception e) {
                logger.logp(Level.SEVERE, className, methodName, e.getMessage());
                e.printStackTrace();
            }
        } else {
            logger.logp(Level.FINER, className, methodName, "WSAT not enabled, just return a true");
            cardValidated = true;
        }
        return cardValidated;
    }

    private boolean processTransaction(PaymentInfoWrapper paymentInfo) {
        UserTransaction ut;
        boolean wsnEnabled;
        String methodName;
        block20: {
            StoreCreditLocal storeCredit;
            block19: {
                block16: {
                    int suffix;
                    int id;
                    BankManager bankManager;
                    block18: {
                        block17: {
                            methodName = "processTransaction";
                            boolean wsatForcedRollback = false;
                            if (settings == null) {
                                this.initializeSettings();
                            }
                            storeCredit = null;
                            bankManager = null;
                            CCManagerRemote ccManager = null;
                            boolean wsatEnabled = settings.isWsatEnabled();
                            wsnEnabled = settings.isWsnEnabled();
                            logger.logp(Level.FINER, className, methodName, "process transaction with WSAT: " + wsatEnabled + " wsnEnabled: " + wsnEnabled);
                            if (wsatEnabled) {
                                bankManager = EJBUtils.getBankManager();
                                ccManager = EJBUtils.getCCManager();
                            }
                            id = settingsID;
                            suffix = this.getSubAccountNumber();
                            ut = null;
                            try {
                                ut = this.mySessionCtx.getUserTransaction();
                                ut.begin();
                                if (!wsatEnabled) break block16;
                                logger.logp(Level.FINE, className, methodName, "Before CreditCard doDebit : AccountNumber " + paymentInfo.getAccountNumber());
                                logger.logp(Level.FINE, className, methodName, "Before CreditCard doDebit : TmeStamp " + System.currentTimeMillis());
                                logger.logp(Level.FINE, className, methodName, "Before CreditCard doDebit : AccountNumber " + paymentInfo.getAccountNumber());
                                logger.logp(Level.FINE, className, methodName, "Before CreditCard doDebit : TmeStamp " + System.currentTimeMillis());
                                if (ccManager.doDebit(paymentInfo.getAccountNumber(), paymentInfo.getAmount(), "GS", settings.isWsnEnabled(), settings.getWsnVariables())) break block17;
                                logger.logp(Level.INFO, className, methodName, "credit card failed");
                                ut.rollback();
                                return false;
                            }
                            catch (Exception e) {
                                logger.logp(Level.SEVERE, className, methodName, e.getMessage());
                                e.printStackTrace();
                                try {
                                    if (ut.getStatus() == 0) {
                                        ut.rollback();
                                        logger.logp(Level.INFO, className, methodName, "Attempting rollback of WS-TX");
                                    }
                                }
                                catch (Exception e2) {
                                    logger.logp(Level.SEVERE, className, methodName, e2.getMessage());
                                    e2.printStackTrace();
                                }
                                return false;
                            }
                        }
                        logger.logp(Level.FINE, className, methodName, "After CreditCard doDebit : AccountNumber " + paymentInfo.getAccountNumber());
                        logger.logp(Level.FINE, className, methodName, "After CreditCard doDebit : TmeStamp " + System.currentTimeMillis());
                        if (System.getProperty("WSAT_ROLLBACK_CC") == null || !System.getProperty("WSAT_ROLLBACK_CC").equalsIgnoreCase("true")) break block18;
                        ut.rollback();
                        logger.logp(Level.INFO, className, methodName, "WSAT_ROLLBACK_CC is true, rolled-back ");
                        return false;
                    }
                    if (bankManager.doTransaction(id, suffix, paymentInfo.getAmount(), "GS", settings.isWsnEnabled(), settings.getWsnVariables())) break block16;
                    logger.logp(Level.INFO, className, methodName, "bank failed");
                    ut.rollback();
                    return false;
                }
                if (System.getProperty("WSAT_ROLLBACK_WSBANK") == null || !System.getProperty("WSAT_ROLLBACK_WSBANK").equalsIgnoreCase("true")) break block19;
                ut.rollback();
                logger.logp(Level.INFO, className, methodName, "WSAT_ROLLBACK_WSBANK is true, rolled-back ");
                return false;
            }
            storeCredit = EJBUtils.createStoreCredit(paymentInfo.getAccountNumber(), new Timestamp(System.currentTimeMillis()));
            if (storeCredit == null) {
                logger.logp(Level.INFO, className, methodName, "ATTENTION! null store credit");
                ut.rollback();
                return false;
            }
            storeCredit.setAmount(paymentInfo.getAmount());
            logger.logp(Level.FINE, className, methodName, "StoreCredit updated: " + storeCredit.getAmount());
            if (System.getProperty("WSAT_ROLLBACK_ALL") == null || !System.getProperty("WSAT_ROLLBACK_ALL").equalsIgnoreCase("true")) break block20;
            logger.logp(Level.INFO, className, methodName, "WSAT_ROLLBACK_ALL is " + System.getProperty("WSAT_ROLLBACK_ALL"));
            ut.rollback();
            logger.logp(Level.INFO, className, methodName, "done rollback...");
            return false;
        }
        if (ut.getStatus() == 0) {
            ut.commit();
            if (wsnEnabled) {
                Timestamp time = new Timestamp(System.currentTimeMillis());
                String msg = null;
                WSNProxy wsnProxyRemote = null;
                WSNUtils wsnUtils = new WSNUtils();
                String[] resultMsg = settings.getWsnVariables().split("\\|");
                String nameSpaceMapping = resultMsg[0];
                String nameSpaceURI = resultMsg[1];
                String topic = resultMsg[2];
                String endPointURL = resultMsg[3];
                String port = resultMsg[4];
                wsnProxyRemote = wsnUtils.createWSNProxyRemote();
                msg = wsnProxyRemote.createMsg2Send("GS", time.toString(), this.getClass().toString(), "Transaction complete");
                wsnProxyRemote.sendMessage(msg, nameSpaceMapping, nameSpaceURI, topic, endPointURL, port);
                logger.logp(Level.FINE, className, methodName, "sent WSN message: " + msg);
            }
        }
        return true;
    }

    private boolean addInvoiceToShippingQueue(ShoppingCartWrapper shoppingCart) {
        String methodName = "addInvoiceToShippingQueue";
        Connection conn = null;
        MessageProducer msgProducer = null;
        Session sess = null;
        try {
            try {
                conn = EJBUtils.getGSShippingQCFConn();
                sess = conn.createSession(false, 1);
                Queue queue = EJBUtils.getGSShippingQueue();
                msgProducer = sess.createProducer((Destination)queue);
                ObjectMessage message = sess.createObjectMessage((Serializable)shoppingCart);
                msgProducer.send((Message)message);
            }
            catch (Exception e) {
                logger.logp(Level.SEVERE, className, methodName, e.getMessage());
                e.printStackTrace();
                try {
                    msgProducer.close();
                    sess.close();
                    conn.close();
                }
                catch (Exception e2) {
                    logger.logp(Level.SEVERE, className, methodName, e2.getMessage());
                    e2.printStackTrace();
                }
                return false;
            }
        }
        finally {
            try {
                msgProducer.close();
                sess.close();
                conn.close();
            }
            catch (Exception e) {
                logger.logp(Level.SEVERE, className, methodName, e.getMessage());
                e.printStackTrace();
            }
        }
        return true;
    }

    public void orderShipped(PaymentInfoWrapper paymentInfo, Vector cart, CustomerInfoWrapper customerInfo) {
        String methodName = "orderShipped";
        logger.logp(Level.FINE, className, methodName, "<====EJBEJB: entered " + methodName);
        try {
            logger.logp(Level.FINE, className, methodName, "<====EJBEJB: to find the customer ");
            CustomerLocal customer = EJBUtils.findCustomerByPrimaryKeyForUpdate(customerInfo.getCustID());
            logger.logp(Level.FINE, className, methodName, "<====EJBEJB: found the customer " + customer.getCustName());
            int tempInvoiceCount = customer.getNumInvoicesCompleted();
            logger.logp(Level.FINE, className, methodName, "<====EJBEJB: found the customer invoice " + tempInvoiceCount);
            customer.setNumInvoicesCompleted(++tempInvoiceCount);
            logger.logp(Level.FINE, className, methodName, "<====EJBEJB: set the invoice completed");
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
        }
    }

    private float calculateCart(Vector cart) {
        String methodName = "calculateCart";
        float totalBill = 0.0f;
        try {
            int verify = 0;
            CartItem currentRow = null;
            int i = 0;
            while (i < cart.size()) {
                currentRow = (CartItem)cart.elementAt(i);
                verify = this.verifyCartItem(currentRow);
                if (verify != 0) {
                    logger.logp(Level.INFO, className, methodName, "Invalid Cart Item, disregarding current CartItem with ID= " + currentRow.getItemID() + ". Return Code is " + verify);
                } else {
                    float totalCostForItem = (float)currentRow.getItemCount() * currentRow.getUnitPrice();
                    totalBill += totalCostForItem;
                }
                ++i;
            }
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
        }
        logger.logp(Level.FINE, className, methodName, "total bill is: " + totalBill);
        return totalBill;
    }

    private int verifyCartItem(CartItem item) {
        InventoryLocal inventory = null;
        inventory = EJBUtils.findInventoryByPrimaryKey(item.getItemID());
        if (inventory == null) {
            return 8;
        }
        if (item.getItemCount() <= 0) {
            return 4;
        }
        if (item.getItemID().equals("") || item.getItemID() == null) {
            return 7;
        }
        if (item.getUnitPrice() < 0.0f) {
            return 11;
        }
        return 0;
    }

    private int getSubAccountNumber() {
        String methodName = "getSubAccountNumber";
        if (settings == null) {
            this.initializeSettings();
        }
        int subAccount = 0;
        try {
            subAccount = random.nextInt(settings.getNumSubAccounts());
            ++subAccount;
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
        }
        return subAccount;
    }

    public Vector<CategoryWrapper> listCategories() {
        String methodName = "listCategories";
        if (settings == null) {
            this.initializeSettings();
        }
        Vector<CategoryWrapper> categories = new Vector<CategoryWrapper>();
        Iterator i = EJBUtils.findAllCategories();
        CategoryLocal categoryLocal = null;
        CategoryWrapper categoryWrapper = null;
        while (i != null && i.hasNext()) {
            try {
                categoryLocal = (CategoryLocal)i.next();
                categoryWrapper = categoryLocal.getWrapper();
                if (categoryWrapper == null) continue;
                categories.add(categoryWrapper);
            }
            catch (Exception e) {
                logger.logp(Level.SEVERE, className, methodName, e.getMessage());
                e.printStackTrace();
            }
        }
        return categories;
    }

    public Vector<MfgCategoryWrapper> listMfgCategories(String categoryName) {
        String methodName = "listMfgCategories";
        if (settings == null) {
            this.initializeSettings();
        }
        Vector<MfgCategoryWrapper> manufacturers = new Vector<MfgCategoryWrapper>();
        CategoryLocal categoryLocal = null;
        MfgCategoryLocal mfgCategoryLocal = null;
        MfgCategoryWrapper mfgCategoryWrapper = null;
        UserTransaction ut = null;
        try {
            ut = this.mySessionCtx.getUserTransaction();
            ut.begin();
            categoryLocal = EJBUtils.findCategoryByPrimaryKey(categoryName);
            Iterator i = categoryLocal.getManufacturers().iterator();
            while (i != null && i.hasNext()) {
                mfgCategoryLocal = (MfgCategoryLocal)i.next();
                mfgCategoryWrapper = mfgCategoryLocal.getWrapper();
                if (mfgCategoryWrapper == null) continue;
                manufacturers.add(mfgCategoryWrapper);
            }
            if (i == null) {
                ut.rollback();
            } else {
                ut.commit();
            }
        }
        catch (Exception ex) {
            logger.logp(Level.SEVERE, className, methodName, ex.getMessage());
            ex.printStackTrace();
        }
        return manufacturers;
    }

    public Vector<MfgCategoryWrapper> listAllMfgCategories() {
        String methodName = "listAllMfgCategories";
        if (settings == null) {
            this.initializeSettings();
        }
        MfgCategoryLocal mfgCategoryLocal = null;
        MfgCategoryWrapper mfgCategoryWrapper = null;
        Vector<MfgCategoryWrapper> mfgCategories = new Vector<MfgCategoryWrapper>();
        try {
            Iterator i = EJBUtils.findAllMfgCategories();
            while (i != null && i.hasNext()) {
                mfgCategoryLocal = (MfgCategoryLocal)i.next();
                mfgCategoryWrapper = mfgCategoryLocal.getWrapper();
                if (mfgCategoryWrapper == null) continue;
                mfgCategories.add(mfgCategoryWrapper);
            }
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
        }
        return mfgCategories;
    }

    public Vector<InventoryWrapper> listInventory(String categoryName, String mfgName) {
        String methodName = "listInventory";
        if (settings == null) {
            this.initializeSettings();
        }
        Vector<InventoryWrapper> inventory = new Vector<InventoryWrapper>();
        InventoryLocal inventoryLocal = null;
        InventoryWrapper inventoryWrapper = null;
        Iterator i = EJBUtils.findInventoryByCategoryMfgName(categoryName, mfgName);
        while (i != null && i.hasNext()) {
            try {
                inventoryLocal = (InventoryLocal)i.next();
                inventoryWrapper = inventoryLocal.getWrapper();
                if (inventoryWrapper == null) continue;
                inventory.add(inventoryWrapper);
            }
            catch (Exception e) {
                logger.logp(Level.SEVERE, className, methodName, e.getMessage());
                e.printStackTrace();
            }
        }
        return inventory;
    }

    public Vector<InventoryWrapper> listInventoryByCategoryOrMfg(String arg1, int findBy) {
        String methodName = "listInventoryByCategoryOrMfg";
        if (settings == null) {
            this.initializeSettings();
        }
        Iterator i = null;
        Vector<InventoryWrapper> inventory = new Vector<InventoryWrapper>();
        InventoryLocal inventoryLocal = null;
        InventoryWrapper inventoryWrapper = null;
        if (findBy == 54) {
            i = EJBUtils.findInventoryByMfgName(arg1);
        } else if (findBy == 53) {
            i = EJBUtils.findInventoryByCategory(arg1);
        }
        while (i != null && i.hasNext()) {
            try {
                inventoryLocal = (InventoryLocal)i.next();
                inventoryWrapper = inventoryLocal.getWrapper();
                if (inventoryWrapper == null) continue;
                inventory.add(inventoryWrapper);
            }
            catch (Exception e) {
                logger.logp(Level.SEVERE, className, methodName, e.getMessage());
                e.printStackTrace();
            }
        }
        return inventory;
    }

    public Vector<InventoryWrapper> listAllInventory() {
        String methodName = "listAllInventory";
        if (settings == null) {
            this.initializeSettings();
        }
        Vector<InventoryWrapper> inventory = new Vector<InventoryWrapper>();
        InventoryLocal inventoryLocal = null;
        InventoryWrapper inventoryWrapper = null;
        Iterator i = EJBUtils.findAllInventory();
        while (i != null && i.hasNext()) {
            try {
                inventoryLocal = (InventoryLocal)i.next();
                inventoryWrapper = inventoryLocal.getWrapper();
                if (inventoryWrapper == null) continue;
                inventory.add(inventoryWrapper);
            }
            catch (Exception e) {
                logger.logp(Level.SEVERE, className, methodName, e.getMessage());
                e.printStackTrace();
            }
        }
        return inventory;
    }

    public Vector listAllCustomers() {
        String methodName = "listAllCustomers";
        if (settings == null) {
            this.initializeSettings();
        }
        Vector<Object> customers = new Vector<Object>();
        CustomerLocal customer = null;
        CustomerWrapper customerWrapper = null;
        Iterator i = EJBUtils.findAllCustomers();
        int totalInvoicesCreated = 0;
        int totalInvoicesCompleted = 0;
        while (i != null && i.hasNext()) {
            try {
                customer = (CustomerLocal)i.next();
                customerWrapper = customer.getWrapper();
                if (customerWrapper != null) {
                    customers.add(customerWrapper);
                }
                totalInvoicesCreated += customerWrapper.getNumInvoicesCreated();
                totalInvoicesCompleted += customerWrapper.getNumInvoicesCompleted();
            }
            catch (Exception e) {
                logger.logp(Level.SEVERE, className, methodName, e.getMessage());
                e.printStackTrace();
            }
        }
        int numCustomers = customers.size();
        customers.add(new String(String.valueOf(totalInvoicesCreated) + " invoices created and " + totalInvoicesCompleted + " invoices completed by " + numCustomers + " customers"));
        return customers;
    }

    public String getTotalStoreCredit() {
        String methodName = "getTotalStoreCredit";
        if (settings == null) {
            this.initializeSettings();
        }
        StoreCreditLocal storeCredit = null;
        String totalCredit = null;
        float runningTotal = 0.0f;
        int numCredits = 0;
        try {
            Iterator i = EJBUtils.findAllStoreCredit();
            while (i != null && i.hasNext()) {
                storeCredit = (StoreCreditLocal)i.next();
                ++numCredits;
                runningTotal += storeCredit.getAmount();
            }
            totalCredit = new String("$" + runningTotal + " in " + numCredits + " storeCredit entries");
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
        }
        return totalCredit;
    }

    public InventoryWrapper getInventory(String itemID) {
        String methodName = "getInventory";
        if (settings == null) {
            this.initializeSettings();
        }
        InventoryWrapper inventoryWrapper = new InventoryWrapper();
        InventoryLocal inventoryLocal = null;
        try {
            inventoryLocal = EJBUtils.findInventoryByPrimaryKey(itemID);
            inventoryWrapper = inventoryLocal.getWrapper();
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
        }
        return inventoryWrapper;
    }

    public CategoryWrapper getCategory(String categoryName) {
        String methodName = "getCategory";
        if (settings == null) {
            this.initializeSettings();
        }
        CategoryWrapper categoryWrapper = new CategoryWrapper();
        CategoryLocal categoryLocal = null;
        try {
            categoryLocal = EJBUtils.findCategoryByPrimaryKey(categoryName);
            categoryWrapper = categoryLocal.getWrapper();
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
        }
        return categoryWrapper;
    }

    public CustomerInfoWrapper getCustomerInfo(String custID) {
        String methodName = "getCustomerInfo";
        if (settings == null) {
            this.initializeSettings();
        }
        CustomerInfoWrapper customerInfoWrapper = new CustomerInfoWrapper();
        CustomerInfoLocal customerInfoLocal = null;
        try {
            customerInfoLocal = EJBUtils.findCustomerInfoByPrimaryKey(custID);
            customerInfoWrapper = customerInfoLocal.getWrapper();
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
        }
        return customerInfoWrapper;
    }

    public CustomerWrapper getCustomer(String custID, String custPwd) {
        String methodName = "getCustomer";
        if (settings == null) {
            this.initializeSettings();
        }
        if (custID.equals(custPwd)) {
            logger.logp(Level.FINE, className, methodName, "customer: " + custID + " = password: " + custPwd);
        } else {
            logger.logp(Level.INFO, className, methodName, "ATTENTION! customer: " + custID + " doesn't match password: " + custPwd);
        }
        CustomerWrapper customerWrapper = new CustomerWrapper();
        CustomerLocal customerLocal = null;
        try {
            customerLocal = EJBUtils.findCustomerByPrimaryKey(custID);
            customerWrapper = customerLocal.getWrapper();
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
        }
        if (customerWrapper.getCustPwd().equals(custPwd)) {
            return customerWrapper;
        }
        logger.logp(Level.INFO, className, methodName, "Null customer ???? " + custID + " while password: " + custPwd);
        return null;
    }

    public boolean populateInventory(SettingsWrapper settingsWrapper) {
        String methodName = "populateInventory";
        CategoryLocal category = null;
        boolean success = false;
        try {
            int i = 1;
            while (i <= settingsWrapper.getNumCategories()) {
                this.createNewCategory("CATEGORY" + i, "Category " + i);
                category = EJBUtils.findCategoryByPrimaryKey("CATEGORY" + i);
                logger.logp(Level.FINER, className, methodName, "found category: " + category.getCategoryDescription());
                int j = 1;
                while (j <= settingsWrapper.getNumMfgCategories()) {
                    this.createNewMfgCategory("CATEGORY" + i, "CAT" + i + "MFG" + j, false);
                    int k = 1;
                    while (k <= settingsWrapper.getNumItemsPerMfg()) {
                        Double itemValue = new Double(Math.random() * 500.0);
                        InventoryWrapper inventory = new InventoryWrapper();
                        inventory.setCategoryName("CATEGORY" + i);
                        inventory.setDescription("CAT" + i + " MFG" + j + " item " + k);
                        inventory.setMfgName("CAT" + i + "MFG" + j);
                        inventory.setInventorySold(0);
                        inventory.setUnitPrice(itemValue.intValue());
                        this.createNewInventory(inventory);
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            success = true;
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
        }
        return success;
    }

    public boolean populateCustomers(SettingsWrapper settingsWrapper, CCInfoWrapper[] ccinfoArray) {
        String methodName = "populateCustomers";
        boolean success = false;
        logger.logp(Level.FINE, className, methodName, "\tjust entered the populateCustomers()...");
        try {
            int numLoops = settingsWrapper.getNumCustomers();
            logger.logp(Level.FINE, className, methodName, "from SettingsWrapper, the loop is: " + numLoops);
            logger.logp(Level.FINE, className, methodName, "from ccinfoArray, the element # is: " + ccinfoArray.length);
            int i = 0;
            while (i < numLoops) {
                int custID = i + 1;
                CustomerWrapper customer = new CustomerWrapper();
                CustomerInfoWrapper customerInfo = new CustomerInfoWrapper();
                customer.setCustID("user" + custID);
                customer.setCustName("user" + custID);
                customer.setCustPwd("user" + custID);
                customer.setNumInvoicesCompleted(0);
                customer.setNumInvoicesCreated(0);
                customerInfo = new CustomerInfoWrapper();
                customerInfo.setCustID("user" + custID);
                customerInfo.setAddress1(String.valueOf(custID) + " Miami Blvd.");
                customerInfo.setAddress2("Apartment " + custID);
                customerInfo.setEmail("user" + custID + "@SVTRTPM.ibm.com");
                customerInfo.setPhone("555-555-5555");
                if (settingsWrapper.isWsatEnabled()) {
                    customerInfo.setCcNum(ccinfoArray[i].getCCNum());
                }
                this.createNewCustomer(customer, customerInfo);
                ++i;
            }
            success = true;
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
        }
        return success;
    }

    public void populateBankDB(SettingsWrapper settings) {
        String methodName = "populateBandDB";
        BankManager bankManager = EJBUtils.getBankManager();
        try {
            bankManager.createAccountsForGS(settingsID, settings.getNumSubAccounts());
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
        }
    }

    public CCInfoWrapper[] populateCCDB(int numCustomers) {
        String methodName = "populateCCDB";
        CCInfoWrapper[] ccinfo = new CCInfoWrapper[numCustomers];
        logger.logp(Level.FINE, className, methodName, "Populate CC Tables with numCustomers " + numCustomers);
        CCManagerRemote ccManager = EJBUtils.getCCManager();
        if (ccManager == null) {
            logger.logp(Level.FINE, className, methodName, "The CCManagerService reference is null");
        }
        logger.logp(Level.FINE, className, methodName, "ccManager reference is: " + ccManager.toString());
        try {
            logger.logp(Level.FINE, className, methodName, "Attempt to make call to ccManager");
            List<CCInfoWrapper> tempList = ccManager.createAccountForGS(numCustomers);
            if (tempList == null) {
                logger.logp(Level.FINE, className, methodName, "tempList null");
            } else {
                logger.logp(Level.FINE, className, methodName, "List returned from CCManager has element #: " + tempList.size());
            }
            CCInfoWrapper[] tempArray = new CCInfoWrapper[tempList.size()];
            tempArray = tempList.toArray(tempArray);
            logger.logp(Level.FINE, className, methodName, "tempArray returned from ccManager, " + tempArray.length + " elements, attempting to copy");
            System.arraycopy(tempArray, 0, ccinfo, 0, numCustomers);
            logger.logp(Level.FINE, className, methodName, "tempArray copied into ccinfo array");
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
        }
        if (ccinfo == null) {
            logger.logp(Level.FINE, className, methodName, "The CCInfoList is  null in StoreManagerBean");
        } else {
            logger.logp(Level.FINE, className, methodName, "The CCInfoList is  not null in StoreManagerBean");
        }
        return ccinfo;
    }

    public boolean clearGSDB() {
        String methodName = "clearGSDB";
        boolean cleared = false;
        try {
            DataSource gsDs = EJBUtils.getGsDs();
            java.sql.Connection gsConn = gsDs.getConnection();
            gsConn.setAutoCommit(false);
            PreparedStatement stmt = null;
            String sql = null;
            sql = "delete from category";
            stmt = gsConn.prepareStatement(sql);
            stmt.executeUpdate();
            stmt.close();
            gsConn.commit();
            sql = "delete from customer";
            stmt = gsConn.prepareStatement(sql);
            stmt.executeUpdate();
            stmt.close();
            gsConn.commit();
            sql = "delete from customerinfo";
            stmt = gsConn.prepareStatement(sql);
            stmt.executeUpdate();
            stmt.close();
            gsConn.commit();
            sql = "delete from inventory";
            stmt = gsConn.prepareStatement(sql);
            stmt.executeUpdate();
            stmt.close();
            gsConn.commit();
            sql = "delete from mfgcategory";
            stmt = gsConn.prepareStatement(sql);
            stmt.executeUpdate();
            stmt.close();
            gsConn.commit();
            sql = "delete from settings";
            stmt = gsConn.prepareStatement(sql);
            stmt.executeUpdate();
            stmt.close();
            gsConn.commit();
            sql = "delete from storecredit";
            stmt = gsConn.prepareStatement(sql);
            stmt.executeUpdate();
            stmt.close();
            gsConn.commit();
            cleared = true;
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
            cleared = false;
        }
        return cleared;
    }

    public boolean resetGSDB(boolean isZ) {
        String methodName = "resetGSDB";
        boolean resetComplete = false;
        try {
            DataSource gsDs = EJBUtils.getGsDs();
            java.sql.Connection gsConn = gsDs.getConnection();
            gsConn.setAutoCommit(false);
            PreparedStatement stmt = null;
            String sql = null;
            sql = "delete from storeCredit";
            stmt = gsConn.prepareStatement(sql);
            stmt.executeUpdate();
            stmt.close();
            gsConn.commit();
            sql = "update customer set numinvoicescreated=0";
            stmt = gsConn.prepareStatement(sql);
            stmt.executeUpdate();
            stmt.close();
            gsConn.commit();
            if (isZ) {
                sql = "update customer set numinvoicescomple1=0";
                stmt = gsConn.prepareStatement(sql);
                stmt.executeUpdate();
                stmt.close();
                gsConn.commit();
            } else {
                sql = "update customer set numinvoicescompleted=0";
                stmt = gsConn.prepareStatement(sql);
                stmt.executeUpdate();
                stmt.close();
                gsConn.commit();
            }
            resetComplete = true;
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
            resetComplete = false;
        }
        return resetComplete;
    }

    public boolean clearBankDB() {
        String methodName = "clearBankDB";
        boolean cleared = false;
        try {
            DataSource wsbankDS = EJBUtils.getWsbankDs();
            java.sql.Connection wsbankConn = wsbankDS.getConnection();
            wsbankConn.setAutoCommit(false);
            PreparedStatement stmt = null;
            String sql = null;
            sql = "delete from transactionhistory";
            stmt = wsbankConn.prepareStatement(sql);
            stmt.executeUpdate();
            stmt.close();
            wsbankConn.commit();
            sql = "delete from subaccount";
            stmt = wsbankConn.prepareStatement(sql);
            stmt.executeUpdate();
            stmt.close();
            wsbankConn.commit();
            sql = "delete from account";
            stmt = wsbankConn.prepareStatement(sql);
            stmt.executeUpdate();
            stmt.close();
            wsbankConn.commit();
            cleared = true;
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
            cleared = false;
        }
        return cleared;
    }

    public boolean resetBankDB() {
        String methodName = "resetBankDB";
        boolean cleared = false;
        try {
            DataSource wsbankDS = EJBUtils.getWsbankDs();
            java.sql.Connection wsbankConn = wsbankDS.getConnection();
            wsbankConn.setAutoCommit(false);
            PreparedStatement stmt = null;
            String sql = null;
            sql = "delete from transactionhistory";
            stmt = wsbankConn.prepareStatement(sql);
            stmt.executeUpdate();
            stmt.close();
            wsbankConn.commit();
            sql = "update subaccount set balance=0";
            stmt = wsbankConn.prepareStatement(sql);
            stmt.executeUpdate();
            stmt.close();
            wsbankConn.commit();
            cleared = true;
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
            cleared = false;
        }
        return cleared;
    }

    public boolean clearCCDB() {
        String methodName = "clearCCDB";
        boolean cleared = false;
        try {
            DataSource ccDS = EJBUtils.getCcDs();
            java.sql.Connection ccConn = ccDS.getConnection();
            ccConn.setAutoCommit(false);
            PreparedStatement stmt = null;
            String sql = null;
            sql = "delete from ccownerinfo";
            stmt = ccConn.prepareStatement(sql);
            stmt.executeUpdate();
            stmt.close();
            ccConn.commit();
            sql = "delete from ccinfo";
            stmt = ccConn.prepareStatement(sql);
            stmt.executeUpdate();
            stmt.close();
            ccConn.commit();
            sql = "delete from ccauthinfo";
            stmt = ccConn.prepareStatement(sql);
            stmt.executeUpdate();
            stmt.close();
            ccConn.commit();
            sql = "delete from cchistory";
            stmt = ccConn.prepareStatement(sql);
            stmt.executeUpdate();
            stmt.close();
            ccConn.commit();
            sql = "delete from ccuniqueid";
            stmt = ccConn.prepareStatement(sql);
            stmt.executeUpdate();
            stmt.close();
            ccConn.commit();
            cleared = true;
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
            cleared = false;
        }
        return cleared;
    }

    public boolean resetCCDB() {
        String methodName = "resetCCDB";
        boolean cleared = false;
        try {
            DataSource ccDS = EJBUtils.getCcDs();
            java.sql.Connection ccConn = ccDS.getConnection();
            ccConn.setAutoCommit(false);
            PreparedStatement stmt = null;
            String sql = null;
            sql = "delete from cchistory";
            stmt = ccConn.prepareStatement(sql);
            stmt.executeUpdate();
            stmt.close();
            ccConn.commit();
            sql = "update ccinfo set balance=0";
            stmt = ccConn.prepareStatement(sql);
            stmt.executeUpdate();
            stmt.close();
            ccConn.commit();
            cleared = true;
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
            cleared = false;
        }
        return cleared;
    }

    public String getCCHistoryData() {
        String methodName = "getCCHistoryData";
        StringBuffer ccHistoryData = new StringBuffer();
        try {
            DataSource ccDS = EJBUtils.getCcDs();
            java.sql.Connection ccConn = ccDS.getConnection();
            ccConn.setAutoCommit(false);
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String sql = null;
            sql = "select count(*) from cchistory";
            stmt = ccConn.prepareStatement(sql);
            rs = stmt.executeQuery();
            ccHistoryData.append(rs.getFloat(1));
            ccHistoryData.append("|");
            stmt.close();
            ccConn.commit();
            sql = "select sum(amount) from cchistory";
            stmt = ccConn.prepareStatement(sql);
            rs = stmt.executeQuery();
            ccHistoryData.append(rs.getFloat(1));
            ccHistoryData.append("|");
            stmt.close();
            ccConn.commit();
            sql = "select sum(balance) from ccinfo";
            stmt = ccConn.prepareStatement(sql);
            rs = stmt.executeQuery();
            ccHistoryData.append(rs.getFloat(1));
            ccHistoryData.append("|");
            stmt.close();
            ccConn.commit();
            ccConn.close();
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
        }
        return ccHistoryData.toString();
    }

    public String getBankHistoryData() {
        String methodName = "getBankHistoryData";
        StringBuffer bankHistoryData = new StringBuffer();
        try {
            DataSource bankDS = EJBUtils.getWsbankDs();
            java.sql.Connection bankConn = bankDS.getConnection();
            bankConn.setAutoCommit(false);
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String sql = null;
            sql = "select count(*) from transactionhistory";
            stmt = bankConn.prepareStatement(sql);
            rs = stmt.executeQuery();
            bankHistoryData.append(rs.getFloat(1));
            bankHistoryData.append("|");
            stmt.close();
            bankConn.commit();
            sql = "select sum(amount) from transactionhistory";
            stmt = bankConn.prepareStatement(sql);
            rs = stmt.executeQuery();
            bankHistoryData.append(rs.getFloat(1));
            bankHistoryData.append("|");
            stmt.close();
            bankConn.commit();
            sql = "select sum(balance) from subaccount";
            stmt = bankConn.prepareStatement(sql);
            rs = stmt.executeQuery();
            bankHistoryData.append(rs.getFloat(1));
            bankHistoryData.append("|");
            stmt.close();
            bankConn.commit();
            bankConn.close();
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
        }
        return bankHistoryData.toString();
    }

    public SettingsWrapper getSettings() {
        if (settings == null) {
            this.initializeSettings();
        }
        return settings;
    }

    private void initializeSettings() {
        settings = null;
        settings = new SettingsWrapper();
        SettingsLocal settingsCMP = EJBUtils.findSettingsByPrimaryKey(settingsID);
        settings.setNumCategories(settingsCMP.getNumCategories());
        settings.setNumCustomers(settingsCMP.getNumCustomers());
        settings.setNumItemsPerMfg(settingsCMP.getNumItemsPerMfg());
        settings.setNumMfgCategories(settingsCMP.getNumMfgCategories());
        settings.setNumSubAccounts(settingsCMP.getNumSubAccounts());
        settings.setWsatEnabled(settingsCMP.getWsatEnabled());
        settings.setWsnEnabled(settingsCMP.getWsnEnabled());
        settings.setSdoEnabled(settingsCMP.getSdoEnabled());
        settings.setWsnVariables(settingsCMP.getWsnVariables());
    }

    public void updateSettings(SettingsWrapper settingsWrapper) {
        SettingsLocal settingsLocal = EJBUtils.findSettingsByPrimaryKey(settingsID);
        settingsLocal.setNumCategories(settingsWrapper.getNumCategories());
        settingsLocal.setNumMfgCategories(settingsWrapper.getNumMfgCategories());
        settingsLocal.setNumItemsPerMfg(settingsWrapper.getNumItemsPerMfg());
        settingsLocal.setNumCustomers(settingsWrapper.getNumCustomers());
        settingsLocal.setNumSubAccounts(settingsWrapper.getNumCustomers() / 10);
        settingsLocal.setWsatEnabled(settingsWrapper.isWsatEnabled());
        settingsLocal.setWsnEnabled(settingsWrapper.isWsnEnabled());
        settingsLocal.setSdoEnabled(settingsWrapper.isSdoEnabled());
        settingsLocal.setWsnVariables(settingsWrapper.getWsnVariables());
        settings = settingsWrapper;
    }

    public boolean createNewCustomer(CustomerWrapper customer, CustomerInfoWrapper customerInfo) {
        String methodName = "createNewCustomer";
        if (settings == null) {
            this.initializeSettings();
        }
        boolean isCreated = false;
        CustomerLocal customerLocal = null;
        CustomerInfoLocal customerInfoLocal = null;
        try {
            customerLocal = EJBUtils.createCustomer(customer.getCustID());
            customerInfoLocal = EJBUtils.createCustomerInfo(customerInfo.getCustID());
            customerLocal.setCustName(customer.getCustName());
            customerLocal.setCustPwd(customer.getCustPwd());
            customerInfoLocal.setAddress1(customerInfo.getAddress1());
            customerInfoLocal.setAddress2(customerInfo.getAddress2());
            customerInfoLocal.setEmail(customerInfo.getEmail());
            customerInfoLocal.setPhone(customerInfo.getPhone());
            customerInfoLocal.setCcNum(customerInfo.getCcNum());
            isCreated = true;
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
        }
        return isCreated;
    }

    public boolean createNewCategory(String categoryName, String categoryDescription) {
        String methodName = "createNewCategory";
        if (settings == null) {
            this.initializeSettings();
        }
        boolean isCreated = false;
        CategoryLocal categoryLocal = null;
        try {
            categoryLocal = EJBUtils.createCategory(categoryName);
            categoryLocal.setNumItemsInCategory(0);
            categoryLocal.setCategoryDescription(categoryDescription);
            isCreated = true;
            logger.logp(Level.FINE, className, methodName, "created category: " + categoryName);
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
        }
        return isCreated;
    }

    public boolean createNewMfgCategory(String categoryName, String mfgName, boolean createCategory) {
        String methodName = "createNewMfgCategory";
        if (settings == null) {
            this.initializeSettings();
        }
        boolean isCreated = false;
        CategoryLocal categoryLocal = null;
        MfgCategoryLocal mfgCategoryLocal = null;
        categoryLocal = EJBUtils.findCategoryByPrimaryKey(categoryName);
        if (categoryLocal == null && createCategory) {
            logger.logp(Level.FINE, className, methodName, "category " + categoryName + " doesn't exist, to create? " + createCategory);
            boolean categoryCreated = this.createNewCategory(categoryName, "");
            if (!categoryCreated) {
                logger.logp(Level.FINE, className, methodName, "category " + categoryName + " Created? " + categoryCreated);
                return false;
            }
            logger.logp(Level.FINE, className, methodName, "category " + categoryName + " created");
            categoryLocal = EJBUtils.findCategoryByPrimaryKey(categoryName);
            if (logger.isLoggable(Level.FINE)) {
                String mfgCategoryName = categoryLocal.getWrapper().getCategoryName();
                logger.logp(Level.FINE, className, methodName, "found categorylocal: " + mfgCategoryName);
            }
        } else if (categoryLocal == null && !createCategory) {
            logger.logp(Level.FINE, className, methodName, "category " + categoryName + " doesn't exist, to create? " + createCategory);
            return false;
        }
        mfgCategoryLocal = EJBUtils.createMfgCategory(mfgName, categoryLocal);
        logger.logp(Level.FINE, className, methodName, "found mfgCategory: " + mfgCategoryLocal.toString());
        isCreated = true;
        return isCreated;
    }

    public boolean createNewInventory(InventoryWrapper inventoryWrapper) {
        String methodName = "createNewInventory";
        if (settings == null) {
            this.initializeSettings();
        }
        InventoryLocal inventoryLocal = null;
        CategoryLocal categoryLocal = null;
        boolean isCreated = false;
        try {
            categoryLocal = EJBUtils.findCategoryByPrimaryKey(inventoryWrapper.getCategoryName());
            String itemID = categoryLocal.getNextItemID();
            inventoryLocal = EJBUtils.createInventory(itemID);
            inventoryLocal.setCategoryName(inventoryWrapper.getCategoryName());
            inventoryLocal.setDescription(inventoryWrapper.getDescription());
            inventoryLocal.setInventorySold(0);
            inventoryLocal.setMfgName(inventoryWrapper.getMfgName());
            inventoryLocal.setUnitPrice(inventoryWrapper.getUnitPrice());
            isCreated = true;
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
        }
        return isCreated;
    }

    public void createSettings(SettingsWrapper settingsWrapper) {
        String methodName = "createSettings";
        logger.logp(Level.FINE, className, methodName, "<++++SSSSS: entered " + methodName);
        SettingsLocal settingsLocal = null;
        settingsLocal = EJBUtils.createSettings(settingsID);
        settingsLocal.setNumCategories(settingsWrapper.getNumCategories());
        settingsLocal.setNumMfgCategories(settingsWrapper.getNumMfgCategories());
        settingsLocal.setNumItemsPerMfg(settingsWrapper.getNumItemsPerMfg());
        settingsLocal.setNumCustomers(settingsWrapper.getNumCustomers());
        settingsLocal.setNumSubAccounts(settingsWrapper.getNumSubAccounts());
        settingsLocal.setWsatEnabled(settingsWrapper.isWsatEnabled());
        settingsLocal.setWsnEnabled(settingsWrapper.isWsnEnabled());
        settingsLocal.setSdoEnabled(settingsWrapper.isSdoEnabled());
        settingsLocal.setWsnVariables(settingsWrapper.getWsnVariables());
        settings = settingsWrapper;
        logger.logp(Level.FINE, className, methodName, "<++++SSSSS: done " + methodName);
    }

    public boolean deleteCustomer(String custID) {
        boolean wasRemoved = EJBUtils.removeCustomer(custID);
        return wasRemoved;
    }

    public boolean deleteCustomerInfo(String custID) {
        boolean wasRemoved = EJBUtils.removeCustomerInfo(custID);
        return wasRemoved;
    }

    public boolean deleteCategory(String categoryName) {
        boolean wasRemoved = EJBUtils.removeCategory(categoryName);
        return wasRemoved;
    }

    public boolean deleteMfgCategory(String categoryName, String mfgName) {
        boolean wasRemoved = EJBUtils.removeMfgCategory(mfgName, categoryName);
        return wasRemoved;
    }

    public boolean deleteInventory(String itemID) {
        boolean wasRemoved = EJBUtils.removeInventory(itemID);
        return wasRemoved;
    }

    public void generateWSStubs(CartItem cart, CategoryWrapper category, MfgCategoryWrapper mfg, InventoryWrapper inventory, CustomerWrapper customer, CustomerInfoWrapper customerInfo, PaymentInfoWrapper paymentInfo) {
    }

    public SessionContext getSessionContext() {
        return this.mySessionCtx;
    }

    public void setSessionContext(SessionContext ctx) {
        this.mySessionCtx = ctx;
    }

    public void ejbCreate() throws CreateException {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void ejbRemove() {
    }
}

