/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.recording;

import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.recording.CaptureHeadersSpec;
import com.github.tomakehurst.wiremock.recording.ProxiedServeEventFilters;
import com.github.tomakehurst.wiremock.recording.RecordSpec;
import com.github.tomakehurst.wiremock.recording.RequestBodyAutomaticPatternFactory;
import com.github.tomakehurst.wiremock.recording.RequestBodyEqualToJsonPatternFactory;
import com.github.tomakehurst.wiremock.recording.RequestBodyEqualToPatternFactory;
import com.github.tomakehurst.wiremock.recording.RequestBodyEqualToXmlPatternFactory;
import com.github.tomakehurst.wiremock.recording.RequestBodyPatternFactory;
import com.github.tomakehurst.wiremock.recording.ResponseDefinitionBodyMatcher;
import com.github.tomakehurst.wiremock.recording.SnapshotOutputFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import wiremock.com.google.common.collect.Maps;

public class RecordSpecBuilder {
    private String targetBaseUrl;
    private RequestPatternBuilder filterRequestPatternBuilder;
    private List<UUID> filterIds;
    private Map<String, CaptureHeadersSpec> headers = Maps.newLinkedHashMap();
    private RequestBodyPatternFactory requestBodyPatternFactory;
    private long maxTextBodySize = 10240L;
    private long maxBinaryBodySize = 0L;
    private boolean persistentStubs = true;
    private boolean repeatsAsScenarios = true;
    private List<String> transformerNames;
    private Parameters transformerParameters;

    public RecordSpecBuilder forTarget(String targetBaseUrl) {
        this.targetBaseUrl = targetBaseUrl;
        return this;
    }

    public RecordSpecBuilder onlyRequestsMatching(RequestPatternBuilder filterRequestPattern) {
        this.filterRequestPatternBuilder = filterRequestPattern;
        return this;
    }

    public RecordSpecBuilder onlyRequestIds(List<UUID> filterIds) {
        this.filterIds = filterIds;
        return this;
    }

    public RecordSpecBuilder extractTextBodiesOver(long size) {
        this.maxTextBodySize = size;
        return this;
    }

    public RecordSpecBuilder extractBinaryBodiesOver(long size) {
        this.maxBinaryBodySize = size;
        return this;
    }

    public RecordSpecBuilder makeStubsPersistent(boolean persistent) {
        this.persistentStubs = persistent;
        return this;
    }

    public RecordSpecBuilder ignoreRepeatRequests() {
        this.repeatsAsScenarios = false;
        return this;
    }

    public RecordSpecBuilder transformers(String ... transformerName) {
        return this.transformers(Arrays.asList(transformerName));
    }

    public RecordSpecBuilder transformers(List<String> transformerName) {
        this.transformerNames = transformerName;
        return this;
    }

    public RecordSpecBuilder transformerParameters(Parameters parameters) {
        this.transformerParameters = parameters;
        return this;
    }

    public RecordSpecBuilder captureHeader(String key) {
        return this.captureHeader(key, null);
    }

    public RecordSpecBuilder captureHeader(String key, Boolean caseInsensitive) {
        this.headers.put(key, new CaptureHeadersSpec(caseInsensitive));
        return this;
    }

    public RecordSpecBuilder chooseBodyMatchTypeAutomatically() {
        return this.chooseBodyMatchTypeAutomatically(null, null, null);
    }

    public RecordSpecBuilder chooseBodyMatchTypeAutomatically(Boolean ignoreArrayOrder, Boolean ignoreExtraElements, Boolean caseInsensitive) {
        this.requestBodyPatternFactory = new RequestBodyAutomaticPatternFactory(ignoreArrayOrder, ignoreExtraElements, caseInsensitive);
        return this;
    }

    public RecordSpecBuilder matchRequestBodyWithEqualToJson() {
        return this.matchRequestBodyWithEqualToJson(null, null);
    }

    public RecordSpecBuilder matchRequestBodyWithEqualToJson(Boolean ignoreArrayOrder, Boolean ignoreExtraElements) {
        this.requestBodyPatternFactory = new RequestBodyEqualToJsonPatternFactory(ignoreArrayOrder, ignoreExtraElements);
        return this;
    }

    public RecordSpecBuilder matchRequestBodyWithEqualToXml() {
        this.requestBodyPatternFactory = new RequestBodyEqualToXmlPatternFactory();
        return this;
    }

    public RecordSpecBuilder matchRequestBodyWithEqualTo() {
        return this.matchRequestBodyWithEqualTo(null);
    }

    public RecordSpecBuilder matchRequestBodyWithEqualTo(Boolean caseInsensitive) {
        this.requestBodyPatternFactory = new RequestBodyEqualToPatternFactory(caseInsensitive);
        return this;
    }

    public RecordSpec build() {
        RequestPattern filterRequestPattern = this.filterRequestPatternBuilder != null ? this.filterRequestPatternBuilder.build() : null;
        ProxiedServeEventFilters filters = this.filterRequestPatternBuilder != null || this.filterIds != null ? new ProxiedServeEventFilters(filterRequestPattern, this.filterIds) : null;
        ResponseDefinitionBodyMatcher responseDefinitionBodyMatcher = new ResponseDefinitionBodyMatcher(this.maxTextBodySize, this.maxBinaryBodySize);
        return new RecordSpec(this.targetBaseUrl, filters, this.headers.isEmpty() ? null : this.headers, this.requestBodyPatternFactory, responseDefinitionBodyMatcher, SnapshotOutputFormatter.FULL, this.persistentStubs, this.repeatsAsScenarios, this.transformerNames, this.transformerParameters);
    }
}

