/*!
 * # Semantic UI 1.11.4 - Dropdown
 * http://github.com/semantic-org/semantic-ui/
 *
 *
 * Copyright 2014 Contributors
 * Released under the MIT license
 * http://opensource.org/licenses/MIT
 *
 */
!function(e,t,n,i){"use strict";e.fn.dropdown=function(o){var a,r=e(this),s=e(n),c=r.selector||"",l="ontouchstart"in n.documentElement,u=(new Date).getTime(),d=[],f=arguments[0],v="string"==typeof f,m=[].slice.call(arguments,1);return r.each(function(h){var g,p,b,w,y=e.isPlainObject(o)?e.extend(!0,{},e.fn.dropdown.settings,o):e.extend({},e.fn.dropdown.settings),x=y.className,T=y.metadata,S=y.namespace,C=y.selector,k=y.error,I="."+S,E="module-"+S,A=e(this),D=A.find(C.text),F=A.find(C.search),M=A.find(C.input),O=A.prev().find(C.text).length>0?A.prev().find(C.text):A.prev(),q=A.children(C.menu),V=q.find(C.item),z=!1,Q=!1,R=this,P=A.data(E);w={initialize:function(){w.debug("Initializing dropdown",y),w.is.alreadySetup()?w.setup.reference():(w.setup.layout(),w.save.defaults(),w.set.selected(),w.create.id(),l&&w.bind.touchEvents(),w.bind.mouseEvents(),w.bind.keyboardEvents(),w.observeChanges(),w.instantiate())},instantiate:function(){w.verbose("Storing instance of dropdown",w),P=w,A.data(E,w)},destroy:function(){w.verbose("Destroying previous dropdown for",A),w.remove.tabbable(),A.off(I).removeData(E),q.off(I),s.off(g)},observeChanges:function(){"MutationObserver"in t&&(b=new MutationObserver(function(e){w.is.selectMutation(e)?(w.debug("<select> modified, recreating menu"),w.setup.select()):(w.debug("DOM tree modified, updating selector cache"),w.refresh())}),b.observe(R,{childList:!0,subtree:!0}),w.debug("Setting up mutation observer",b))},create:{id:function(){p=(Math.random().toString(16)+"000000000").substr(2,8),g="."+p,w.verbose("Creating unique id for element",p)}},search:function(){var e;e=F.val(),w.verbose("Searching for query",e),w.filter(e),w.is.searchSelection()&&w.can.show()&&w.show()},setup:{layout:function(){A.is("select")&&w.setup.select(),w.is.search()&&!w.is.searchable()&&(F=e("<input />").addClass(x.search).insertBefore(D)),y.allowTab&&w.set.tabbable()},select:function(){var t=w.get.selectValues();w.debug("Dropdown initialized on a select",t),A.is("select")&&(M=A),M.parent(C.dropdown).length>0?(w.debug("UI dropdown already exists. Creating dropdown menu only"),A=M.closest(C.dropdown),q=A.children(C.menu),0===q.length&&(q=e("<div />").addClass(x.menu).appendTo(A)),q.html(y.templates.menu(t))):(w.debug("Creating entire dropdown from select"),A=e("<div />").attr("class",M.attr("class")).addClass(x.selection).addClass(x.dropdown).html(y.templates.dropdown(t)).insertBefore(M),M.removeAttr("class").prependTo(A)),w.setup.reference()},reference:function(){var e,t;w.debug("Dropdown behavior was called on select, replacing with closest dropdown"),A=A.closest(C.dropdown),w.refresh(),e=r.slice(0,h),t=r.slice(h+1),r=e.add(A).add(t)}},refresh:function(){w.verbose("Refreshing selector cache"),D=A.find(C.text),F=A.find(C.search),M=A.find(C.input),O=A.prev().find(C.text).length>0?A.prev().find(C.text):A.prev(),q=A.children(C.menu),V=q.find(C.item)},toggle:function(){w.verbose("Toggling menu visibility"),w.is.active()?w.hide():w.show()},show:function(t){t=e.isFunction(t)?t:function(){},w.is.searchSelection()&&w.is.allFiltered()||w.can.show()&&!w.is.active()&&(w.debug("Showing dropdown"),w.animate.show(function(){w.can.click()&&w.bind.intent(),w.set.visible(),t.call(R)}),y.onShow.call(R))},hide:function(t){t=e.isFunction(t)?t:function(){},w.is.active()&&(w.debug("Hiding dropdown"),w.animate.hide(function(){w.remove.visible(),t.call(R)}),y.onHide.call(R))},hideOthers:function(){w.verbose("Finding other dropdowns to hide"),r.not(A).has(C.menu+":visible:not(."+x.animating+")").dropdown("hide")},hideSubMenus:function(){var e=q.find(C.menu);e.transition("hide")},bind:{keyboardEvents:function(){w.debug("Binding keyboard events"),A.on("keydown"+I,w.event.keydown),w.is.searchable()&&A.on(w.get.inputEvent(),C.search,w.event.input)},touchEvents:function(){w.debug("Touch device detected binding additional touch events"),w.is.searchSelection()||A.on("touchstart"+I,w.event.test.toggle),q.on("touchstart"+I,C.item,w.event.item.mouseenter)},mouseEvents:function(){w.verbose("Mouse detected binding mouse events"),w.is.searchSelection()?A.on("mousedown"+I,C.menu,w.event.menu.activate).on("mouseup"+I,C.menu,w.event.menu.deactivate).on("click"+I,C.search,w.show).on("focus"+I,C.search,w.event.searchFocus).on("blur"+I,C.search,w.event.searchBlur).on("click"+I,C.text,w.event.searchTextFocus):("click"==y.on?A.on("click"+I,w.event.test.toggle):"hover"==y.on?A.on("mouseenter"+I,w.delay.show).on("mouseleave"+I,w.delay.hide):A.on(y.on+I,w.toggle),A.on("mousedown"+I,w.event.mousedown).on("mouseup"+I,w.event.mouseup).on("focus"+I,w.event.focus).on("blur"+I,w.event.blur)),q.on("mouseenter"+I,C.item,w.event.item.mouseenter).on("mouseleave"+I,C.item,w.event.item.mouseleave).on("click"+I,C.item,w.event.item.click)},intent:function(){w.verbose("Binding hide intent event to document"),l&&s.on("touchstart"+g,w.event.test.touch).on("touchmove"+g,w.event.test.touch),s.on("click"+g,w.event.test.hide)}},unbind:{intent:function(){w.verbose("Removing hide intent event from document"),l&&s.off("touchstart"+g).off("touchmove"+g),s.off("click"+g)}},filter:function(t){var n=e(),i=w.escape.regExp(t),o=new RegExp("^"+i,"igm"),a=new RegExp(i,"ig");w.verbose("Searching for matching values"),V.each(function(){var t=e(this),i=String(w.get.choiceText(t,!1)),r=String(w.get.choiceValue(t,i));i.match(o)||r.match(o)?n=n.add(t):y.fullTextSearch&&(i.match(a)||r.match(a))&&(n=n.add(t))}),w.debug("Setting filter",t),w.remove.filteredItem(),V.not(n).addClass(x.filtered),w.verbose("Selecting first non-filtered element"),w.remove.selectedItem(),V.not("."+x.filtered).eq(0).addClass(x.selected),w.is.allFiltered()&&(w.debug("All items filtered, hiding dropdown",t),w.is.searchSelection()&&w.hide(),y.onNoResults.call(R,t))},focusSearch:function(){w.is.search()&&F.focus()},forceSelection:function(){var e=V.not(x.filtered).filter("."+x.selected).eq(0),t=V.filter("."+x.active).eq(0),n=e.length>0?e:t,i=n.size()>0;i&&(w.event.item.click.call(n),w.remove.filteredItem())},event:{mousedown:function(){z=!0},mouseup:function(){z=!1},focus:function(){!z&&w.is.hidden()&&w.show()},blur:function(){var e=n.activeElement===this;z||e||w.hide()},searchFocus:function(){z=!0,w.show()},searchBlur:function(){var e=n.activeElement===this;Q||e||(y.forceSelection?w.forceSelection():w.hide())},searchTextFocus:function(){z=!0,F.focus()},input:function(){w.is.searchSelection()&&w.set.filtered(),clearTimeout(w.timer),w.timer=setTimeout(w.search,y.delay.search)},keydown:function(e){{var t,n=V.not(x.filtered).filter("."+x.selected).eq(0),i=q.children("."+x.active).eq(0),o=n.length>0?n:i,a=o.length>0?o.siblings(":not(."+x.filtered+")").andSelf():q.children(":not(."+x.filtered+")"),r=o.children(C.menu),s=o.closest(C.menu),c=s[0]!==q[0],l=s.is(":visible"),u=e.which,d={enter:13,escape:27,leftArrow:37,upArrow:38,rightArrow:39,downArrow:40},f=r.length>0,v=o.length>0;a.size()-1}if(w.is.visible()){if(u==d.enter&&v&&(f&&!y.allowCategorySelection?(w.verbose("Pressed enter on unselectable category, opening sub menu"),u=d.rightArrow):(w.verbose("Enter key pressed, choosing selected item"),w.event.item.click.call(o,e))),u==d.leftArrow&&(c&&(w.verbose("Left key pressed, closing sub-menu"),w.animate.hide(!1,s),o.removeClass(x.selected),s.closest(C.item).addClass(x.selected)),e.preventDefault()),u==d.rightArrow&&(f&&(w.verbose("Right key pressed, opening sub-menu"),w.animate.show(!1,r),o.removeClass(x.selected),r.find(C.item).eq(0).addClass(x.selected)),e.preventDefault()),u==d.upArrow){if(t=v&&l?o.prevAll(C.item+":not(."+x.filtered+")").eq(0):V.eq(0),a.index(t)<0)return void w.verbose("Up key pressed but reached top of current menu");w.verbose("Up key pressed, changing active item"),o.removeClass(x.selected),t.addClass(x.selected),w.set.scrollPosition(t),e.preventDefault()}if(u==d.downArrow){if(t=v&&l?t=o.nextAll(C.item+":not(."+x.filtered+")").eq(0):V.eq(0),0===t.length)return void w.verbose("Down key pressed but reached bottom of current menu");w.verbose("Down key pressed, changing active item"),V.removeClass(x.selected),t.addClass(x.selected),w.set.scrollPosition(t),e.preventDefault()}}else u==d.enter&&(w.verbose("Enter key pressed, showing dropdown"),w.show()),u==d.escape&&(w.verbose("Escape key pressed, closing dropdown"),w.hide()),u==d.downArrow&&(w.verbose("Down key pressed, showing dropdown"),w.show())},test:{toggle:function(e){w.determine.eventInMenu(e,w.toggle)&&e.preventDefault()},touch:function(e){w.determine.eventInMenu(e,function(){"touchstart"==e.type?w.timer=setTimeout(w.hide,y.delay.touch):"touchmove"==e.type&&clearTimeout(w.timer)}),e.stopPropagation()},hide:function(e){w.determine.eventInModule(e,w.hide)}},menu:{activate:function(){Q=!0},deactivate:function(){Q=!1}},item:{mouseenter:function(t){var n=e(this).children(C.menu),i=e(this).siblings(C.item).children(C.menu);n.length>0&&(clearTimeout(w.itemTimer),w.itemTimer=setTimeout(function(){w.verbose("Showing sub-menu",n),e.each(i,function(){w.animate.hide(!1,e(this))}),w.animate.show(!1,n)},y.delay.show),t.preventDefault())},mouseleave:function(){var t=e(this).children(C.menu);t.length>0&&(clearTimeout(w.itemTimer),w.itemTimer=setTimeout(function(){w.verbose("Hiding sub-menu",t),w.animate.hide(!1,t)},y.delay.hide))},click:function(t){var n=e(this),i=e(t?t.target:""),o=n.find(C.menu),a=w.get.choiceText(n),r=w.get.choiceValue(n,a),s=function(){w.remove.searchTerm(),w.determine.selectAction(a,r)},c=o.length>0,l=o.find(i).length>0;l||c&&!y.allowCategorySelection||s()}},resetStyle:function(){e(this).removeAttr("style")}},determine:{selectAction:function(t,n){w.verbose("Determining action",y.action),e.isFunction(w.action[y.action])?(w.verbose("Triggering preset action",y.action,t,n),w.action[y.action](t,n)):e.isFunction(y.action)?(w.verbose("Triggering user action",y.action,t,n),y.action(t,n)):w.error(k.action,y.action)},eventInModule:function(t,n){return n=e.isFunction(n)?n:function(){},0===e(t.target).closest(A).length?(w.verbose("Triggering event",n),n(),!0):(w.verbose("Event occurred in dropdown, canceling callback"),!1)},eventInMenu:function(t,n){return n=e.isFunction(n)?n:function(){},0===e(t.target).closest(q).length?(w.verbose("Triggering event",n),n(),!0):(w.verbose("Event occurred in dropdown menu, canceling callback"),!1)}},action:{nothing:function(){},activate:function(e,t){t=t!==i?t:e,w.set.selected(t),w.hide(function(){w.remove.filteredItem()})},select:function(e,t){t=t!==i?t:e,w.set.selected(t),w.hide(function(){w.remove.filteredItem()})},combo:function(e,t){t=t!==i?t:e,w.set.selected(t),w.hide(function(){w.remove.filteredItem()})},hide:function(){w.hide(function(){w.remove.filteredItem()})}},get:{id:function(){return p},text:function(){return D.text()},value:function(){return M.length>0?M.val():A.data(T.value)},choiceText:function(e,t){return t=t!==i?t:y.preserveHTML,e!==i?(e.find(C.menu).length>0&&(w.verbose("Retreiving text of element with sub-menu"),e=e.clone(),e.find(C.menu).remove(),e.find(C.menuIcon).remove()),e.data(T.text)!==i?e.data(T.text):t?e.html().trim():e.text().trim()):void 0},choiceValue:function(e,t){return t=t||w.get.choiceText(e),e.data(T.value)!==i?e.data(T.value):"string"==typeof t?t.toLowerCase().trim():t.trim()},inputEvent:function(){var e=F[0];return e?e.oninput!==i?"input":e.onpropertychange!==i?"propertychange":"keyup":!1},selectValues:function(){var t={};return t.values=y.sortSelect?{}:[],A.find("option").each(function(){var n=e(this).html(),o=e(this).attr("value")!==i?e(this).attr("value"):n;""===o?t.placeholder=n:y.sortSelect?t.values[o]={name:n,value:o}:t.values.push({name:n,value:o})}),y.sortSelect?w.debug("Retrieved and sorted values from select",t):w.debug("Retreived values from select",t),t},activeItem:function(){return V.filter("."+x.active)},item:function(t,n){var o=!1;return t=t!==i?t:w.get.value()!==i?w.get.value():w.get.text(),n=""===t||0===t?!0:n||!1,t!==i?V.each(function(){var i=e(this),a=w.get.choiceText(i),r=w.get.choiceValue(i,a);n?(w.verbose("Ambiguous dropdown value using strict type check",i,t),r===t?o=e(this):o||a!==t||(o=e(this))):r==t?(w.verbose("Found select item by value",r,t),o=e(this)):o||a!=t||(w.verbose("Found select item by text",a,t),o=e(this))}):t=w.get.text(),o||!1}},restore:{defaults:function(){w.restore.defaultText(),w.restore.defaultValue()},defaultText:function(){var e=A.data(T.defaultText);w.debug("Restoring default text",e),w.set.text(e),D.addClass(x.placeholder)},defaultValue:function(){var e=A.data(T.defaultValue);e!==i&&(w.debug("Restoring default value",e),e.length?w.set.selected(e):(w.remove.activeItem(),w.remove.selectedItem()))}},save:{defaults:function(){w.save.defaultText(),w.save.placeholderText(),w.save.defaultValue()},defaultValue:function(){A.data(T.defaultValue,w.get.value())},defaultText:function(){A.data(T.defaultText,D.text())},placeholderText:function(){D.hasClass(x.placeholder)&&A.data(T.placeholderText,D.text())}},clear:function(){var e=A.data(T.placeholderText);w.set.text(e),w.set.value(""),w.remove.activeItem(),w.remove.selectedItem(),D.addClass(x.placeholder)},set:{filtered:function(){var e=F.val(),t="string"==typeof e&&e.length>0;t?D.addClass(x.filtered):D.removeClass(x.filtered)},tabbable:function(){w.is.searchable()?(w.debug("Searchable dropdown initialized"),F.val("").attr("tabindex",0),q.attr("tabindex","-1")):(w.debug("Simple selection dropdown initialized"),A.attr("tabindex")||(A.attr("tabindex",0),q.attr("tabindex","-1")))},scrollPosition:function(e,t){var n,o,a,r,s,c,l,u,d,f=5;e=e||w.get.activeItem(),n=e&&e.length>0,t=t!==i?t:!1,e&&n&&(q.hasClass(x.visible)||q.addClass(x.loading),l=q.height(),a=e.height(),c=q.scrollTop(),s=q.offset().top,r=e.offset().top,o=c-s+r,d=o+f>c+l,u=c>o-f,w.debug("Scrolling to active item",o),(u||d||t)&&q.scrollTop(o).removeClass(x.loading))},text:function(e){"combo"==y.action?(w.debug("Changing combo button text",e,O),y.preserveHTML?O.html(e):O.text(e)):"select"!==y.action&&(w.debug("Changing text",e,D),D.removeClass(x.filtered).removeClass(x.placeholder),y.preserveHTML?D.html(e):D.text(e))},value:function(e){w.debug("Adding selected value to hidden input",e,M),M.length>0?M.val(e).trigger("change"):A.data(T.value,e)},active:function(){A.addClass(x.active)},visible:function(){A.addClass(x.visible)},selected:function(e){var t,n,i=w.get.item(e);i&&(w.debug("Setting selected menu item to",i),w.remove.activeItem(),w.remove.selectedItem(),i.addClass(x.active).addClass(x.selected),t=w.get.choiceText(i),n=w.get.choiceValue(i,t),w.set.text(t),w.set.value(n),y.onChange.call(R,e,t,i))}},remove:{active:function(){A.removeClass(x.active)},visible:function(){A.removeClass(x.visible)},activeItem:function(){V.removeClass(x.active)},filteredItem:function(){V.removeClass(x.filtered)},searchTerm:function(){F.val("")},selectedItem:function(){V.removeClass(x.selected)},tabbable:function(){w.is.searchable()?(w.debug("Searchable dropdown initialized"),F.attr("tabindex","-1"),q.attr("tabindex","-1")):(w.debug("Simple selection dropdown initialized"),A.attr("tabindex","-1"),q.attr("tabindex","-1"))}},is:{active:function(){return A.hasClass(x.active)},alreadySetup:function(){return A.is("select")&&A.parent(C.dropdown).length>0},animating:function(e){return e?e.is(":animated")||e.transition&&e.transition("is animating"):q.is(":animated")||q.transition&&q.transition("is animating")},allFiltered:function(){return V.filter("."+x.filtered).length===V.length},hidden:function(e){return e?e.is(":hidden"):q.is(":hidden")},selectMutation:function(t){var n=!1;return e.each(t,function(t,i){return i.target&&e(i.target).is("select")?(n=!0,!0):void 0}),n},search:function(){return A.hasClass(x.search)},searchable:function(){return F.length>0},searchSelection:function(){return w.is.searchable()&&F.parent().is(A)},selection:function(){return A.hasClass(x.selection)},upward:function(){return A.hasClass(x.upward)},visible:function(e){return e?e.is(":visible"):q.is(":visible")}},can:{click:function(){return l||"click"==y.on},show:function(){return!A.hasClass(x.disabled)}},animate:{show:function(t,n){var o=n||q,a=n?function(){}:function(){w.hideSubMenus(),w.hideOthers(),w.set.active()};t=e.isFunction(t)?t:function(){},w.set.scrollPosition(w.get.activeItem(),!0),w.verbose("Doing menu show animation",o),(w.is.hidden(o)||w.is.animating(o))&&("auto"==y.transition&&(y.transition=w.is.upward()?"slide up":"slide down",w.verbose("Automatically determining animation based on animation direction",y.transition)),"none"==y.transition?t.call(R):e.fn.transition!==i&&A.transition("is supported")?o.transition({animation:y.transition+" in",debug:y.debug,verbose:y.verbose,duration:y.duration,queue:!0,onStart:a,onComplete:function(){t.call(R)}}):"slide down"==y.transition?(a(),o.hide().clearQueue().children().clearQueue().css("opacity",0).delay(50).animate({opacity:1},y.duration,"easeOutQuad",w.event.resetStyle).end().slideDown(100,"easeOutQuad",function(){w.event.resetStyle.call(this),t.call(R)})):"fade"==y.transition?(a(),o.hide().clearQueue().fadeIn(y.duration,function(){w.event.resetStyle.call(this),t.call(R)})):w.error(k.transition,y.transition))},hide:function(t,n){var o=n||q,a=(n?.9*y.duration:y.duration,n?function(){}:function(){w.can.click()&&w.unbind.intent(),w.focusSearch(),w.remove.active()});t=e.isFunction(t)?t:function(){},(w.is.visible(o)||w.is.animating(o))&&(w.verbose("Doing menu hide animation",o),"auto"==y.transition&&(y.transition=w.is.upward()?"slide up":"slide down"),M.trigger("blur"),"none"==y.transition?t.call(R):e.fn.transition!==i&&A.transition("is supported")?o.transition({animation:y.transition+" out",duration:y.duration,debug:y.debug,verbose:y.verbose,queue:!0,onStart:a,onComplete:function(){t.call(R)}}):"slide down"==y.transition?(a(),o.show().clearQueue().children().clearQueue().css("opacity",1).animate({opacity:0},100,"easeOutQuad",w.event.resetStyle).end().delay(50).slideUp(100,"easeOutQuad",function(){w.event.resetStyle.call(this),t.call(R)})):"fade"==y.transition?(a(),o.show().clearQueue().fadeOut(150,function(){w.event.resetStyle.call(this),t.call(R)})):w.error(k.transition))}},delay:{show:function(){w.verbose("Delaying show event to ensure user intent"),clearTimeout(w.timer),w.timer=setTimeout(w.show,y.delay.show)},hide:function(){w.verbose("Delaying hide event to ensure user intent"),clearTimeout(w.timer),w.timer=setTimeout(w.hide,y.delay.hide)}},escape:{regExp:function(e){return e=String(e),e.replace(/[-[\]{}()*+?.,\\^$|#\s]/g,"\\$&")}},setting:function(t,n){if(w.debug("Changing setting",t,n),e.isPlainObject(t))e.extend(!0,y,t);else{if(n===i)return y[t];y[t]=n}},internal:function(t,n){if(e.isPlainObject(t))e.extend(!0,w,t);else{if(n===i)return w[t];w[t]=n}},debug:function(){y.debug&&(y.performance?w.performance.log(arguments):(w.debug=Function.prototype.bind.call(console.info,console,y.name+":"),w.debug.apply(console,arguments)))},verbose:function(){y.verbose&&y.debug&&(y.performance?w.performance.log(arguments):(w.verbose=Function.prototype.bind.call(console.info,console,y.name+":"),w.verbose.apply(console,arguments)))},error:function(){w.error=Function.prototype.bind.call(console.error,console,y.name+":"),w.error.apply(console,arguments)},performance:{log:function(e){var t,n,i;y.performance&&(t=(new Date).getTime(),i=u||t,n=t-i,u=t,d.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:R,"Execution Time":n})),clearTimeout(w.performance.timer),w.performance.timer=setTimeout(w.performance.display,100)},display:function(){var t=y.name+":",n=0;u=!1,clearTimeout(w.performance.timer),e.each(d,function(e,t){n+=t["Execution Time"]}),t+=" "+n+"ms",c&&(t+=" '"+c+"'"),(console.group!==i||console.table!==i)&&d.length>0&&(console.groupCollapsed(t),console.table?console.table(d):e.each(d,function(e,t){console.log(t.Name+": "+t["Execution Time"]+"ms")}),console.groupEnd()),d=[]}},invoke:function(t,n,o){var r,s,c,l=P;return n=n||m,o=R||o,"string"==typeof t&&l!==i&&(t=t.split(/[\. ]/),r=t.length-1,e.each(t,function(n,o){var a=n!=r?o+t[n+1].charAt(0).toUpperCase()+t[n+1].slice(1):t;if(e.isPlainObject(l[a])&&n!=r)l=l[a];else{if(l[a]!==i)return s=l[a],!1;if(!e.isPlainObject(l[o])||n==r)return l[o]!==i?(s=l[o],!1):(w.error(k.method,t),!1);l=l[o]}})),e.isFunction(s)?c=s.apply(o,n):s!==i&&(c=s),e.isArray(a)?a.push(c):a!==i?a=[a,c]:c!==i&&(a=c),s}},v?(P===i&&w.initialize(),w.invoke(f)):(P!==i&&P.invoke("destroy"),w.initialize())}),a!==i?a:r},e.fn.dropdown.settings={debug:!1,verbose:!0,performance:!0,on:"click",action:"activate",allowTab:!0,fullTextSearch:!1,preserveHTML:!0,sortSelect:!1,allowCategorySelection:!1,delay:{hide:300,show:200,search:50,touch:50},forceSelection:!0,transition:"auto",duration:250,onNoResults:function(){},onChange:function(){},onShow:function(){},onHide:function(){},name:"Dropdown",namespace:"dropdown",error:{action:"You called a dropdown action that was not defined",alreadySetup:"Once a select has been initialized behaviors must be called on the created ui dropdown",method:"The method you called is not defined.",transition:"The requested transition was not found"},metadata:{defaultText:"defaultText",defaultValue:"defaultValue",placeholderText:"placeholderText",text:"text",value:"value"},selector:{dropdown:".ui.dropdown",input:'> input[type="hidden"], > select',item:".item",menu:".menu",menuIcon:".dropdown.icon",search:"> input.search, .menu > .search > input, .menu > input.search",text:"> .text:not(.icon)"},className:{active:"active",animating:"animating",disabled:"disabled",dropdown:"ui dropdown",filtered:"filtered",loading:"loading",menu:"menu",placeholder:"default",search:"search",selected:"selected",selection:"selection",upward:"upward",visible:"visible"}},e.fn.dropdown.settings.templates={menu:function(t){var n=(t.placeholder||!1,t.values||{},"");return e.each(t.values,function(e,t){n+='<div class="item" data-value="'+t.value+'">'+t.name+"</div>"}),n},dropdown:function(t){var n=t.placeholder||!1,i=(t.values||{},"");return i+='<i class="dropdown icon"></i>',i+=t.placeholder?'<div class="default text">'+n+"</div>":'<div class="text"></div>',i+='<div class="menu">',e.each(t.values,function(e,t){i+='<div class="item" data-value="'+t.value+'">'+t.name+"</div>"}),i+="</div>"}},e.extend(e.easing,{easeOutQuad:function(e,t,n,i,o){return-i*(t/=o)*(t-2)+n}})}(jQuery,window,document);