#!/usr/local/bin/perl

package Y;

use Carp;
use strict;

require Tie::Scalar ;

sub TIESCALAR 
  {
    my $type = shift;
    my %args = @_ ;
    my $self={} ;
    if (defined $args{enum})
      {
        # store all enum values in a hash. This way, checking
        # whether a value is present in the enum set is easier
        map {$self->{enum}{$_} =  1;} @{$args{enum}} ;
      }
    else
      {
        croak ref($self)," error: no enum values defined when calling init";
      }

    $self->{default} = $args{default};
    bless $self,$type;
  }

sub STORE
  {
    my ($self,$value) = @_ ;
    croak "cannot set ",ref($self)," item to $value. Expected ",
      join(' ',keys %{$self->{enum}}) 
        unless defined $self->{enum}{$value} ;
    # we may want to check other rules here ... TBD
    $self->{value} = $value ;
    return $value;
  }


sub FETCH
  {
    my $self = shift ;
    return defined $self->{value} ? $self->{value} : $self->{default}  ;
  }

package X ;
use ExtUtils::testlib;

use Class::MakeMethods::Emulator::MethodMaker
  tie_scalar => 
  [
   a => ['Y',  
         enum =>    [qw/A B C/], 
         default => 'B' ],
  ],
  new => 'new';

package main;
use ExtUtils::testlib;

use lib qw ( ./t );
use Test;

my $o = new X;

TEST { 1 };
TEST {$o->a eq 'B'} ;
TEST {$o->a('A') eq 'A'} ;
TEST {$o->a eq 'A'} ;

exit 0;

