#!/usr/bin/perl

package eBay::API::XML::Call::GetDispute;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetDispute.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetDispute

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetDispute inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::GetDispute::GetDisputeRequestType;
use eBay::API::XML::Call::GetDispute::GetDisputeResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'GetDispute';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetDispute::GetDisputeRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetDispute::GetDisputeResponseType';
}

#
# input properties
#

=head2 setDisputeID()

The unique identifier of the dispute, returned when the dispute is created.

  RequiredInput: Yes
#    Argument: 'ns:DisputeIDType'

=cut
       
sub setDisputeID {
   my $self   = shift;
   my $pDisputeID = shift;
   $self->getRequestDataType()->setDisputeID($pDisputeID);
}



#
# output properties
#

=head2 getDispute()

The dispute record, containing information about
the buyer, seller, dispute state, dispute status,
comments added to the dispute, or resolutions.

  Returned: Always
#    Returns: 'ns:DisputeType'

=cut
       
sub getDispute {
   my $self = shift;
   return $self->getResponseDataType()->getDispute();
}





1;   
