{$A+,B-,D-,E+,F+,G-,I+,L-,N+,O-,R-,S+,V+,X-}
{$M 16000,0,29000}

program pickFile;

uses Dos, Crt, Win;

const
  kUp   =-72;
  kDn   =-80;
  kLeft =-75;
  kRight=-77;
  kPgUp =-73;
  kPgDn =-81;
  kHome =-71;
  kEnd  =-79;
  kDel  =-83;
  kIns  =-82;
  kEsc  = 27;
  kEnter= 13;
  kBsp  =  8;

const
  maxItems=1000;

type
  str20 = string[25];
  tItemArray = array [1..maxItems] of string[12];

var
  Item : ^tItemArray;
  iniPath : pathStr;
  iniFile : nameStr;
  iniMode : string[4];
  Cmd     : string;
  finFile : pathStr;

  aTitAtr : byte;  {barevne atributy}
  aFrmAtr : byte;
  aLowAtr : byte;
  aHigAtr : byte;
  aEdiAtr : byte;
  aErrAtr : byte;

  Frame : frameChars;

  r0 : integer;  {nulty radek menu}
  c0 : integer;  {nulty sloupec menu}
  w0 : integer;  {delka polozky menu}
  Fr : integer;  {typ ramecku:  0=zadny, 1=jednoduchy, 2=dvojity}

  eR : integer;  {radek pro editaci jmena}
  eC : integer;  {sloupec pro editaci jmena}
  eW : integer;  {sirka pole peo editaci jmena}
  eP : string;   {prompt pro editaci}

  iP : integer;  {cislo aktualniho souboru}
  nP : integer;  {pocet vsech souboru}
  iR : integer;  {cislo aktualniho radku}
  nR : integer;  {pocet radek v menu}

{=========================================================}
procedure  Help;

const
  nTxT = 15;
  mTxt : array [1..nTxt] of string[59] =(

  'pickFile                               (c) Jiri Demel, 1992',
  '                                                           ',
  'Program  pickFile  umoznuje pomoci menu nebo primou editaci',
  'vybrat soubor. Vysledne jmeno souboru bude zapsano na      ',
  'standardni vystup (lze presmerovat do souboru). Urceno pro ',
  'pouziti v davkovych souborech (.bat).  Priklad pouziti:    ',
  '...                                                        ',
  'pickfile  *.tex  /c=set+MAIN=[]  /i=%MAIN%    > env.bat    ',
  'call env.bat                                               ',
  '...                                                        ',
  '(Do souboru  env.bat  se zapise prikaz  "set MAIN=jmSoub"  ',
  'a ten se potom vykona. Jako default se pouzije dosavadni   ',
  'hodnota environmentove promenne %MAIN%.)                   ',
  '                                                           ',
  'Podrobneji viz dokumentace v souboru  pickfile.doc .       ');

var
  i : integer;

begin
  for i:=1 to nTxt do writeln (mTxt[i]);
end;

{-----------------------------------------------------------}
procedure  IniParms;
begin
  Assign (output, '');
  ReWrite (output);

  aTitAtr := $70;
  aFrmAtr := $70;
  aLowAtr := $70;
  aHigAtr := $30;
  aErrAtr := $4e;
  aEdiAtr := $1e;

  r0 := 10;   {nulty radek menu}
  c0 := 40;   {nulty sloupec menu}
  w0 := 12;
  nR := 10;
  Fr := 1;

  eR := 0;
  eC := 0;
  eW := 12;
  eP := '';

  cmd:='';
  iniPath:='*.*';
  iniFile:='';
  iniMode:='NE';
  finFile:='';
end;

{-----------------------------------------------------------}
function  LwCase (c:char) : char;
begin
  if  (ord(c)>64) and (ord(c)<91)  then  LwCase:=chr(ord(c)+32)
                                   else  LwCase:=c;
end;

{------------------------------------------}
{------------------------------------------}
function  max (i,j:integer) : integer;
begin  if i<j then max:=j  else max:=i;  end;

{------------------------------------------}
function  min (i,j:integer) : integer;
begin  if i>j then min:=j  else min:=i;  end;

{------------------------------------------}
function  waitKey : word;
var  x : integer;
begin
  x:=ord(readKey);
  if  x=0  then  x:=-ord(readKey);
  waitKey:=x;
end;

{------------------------------------------}
function  space (n:integer) : string;
var s:string; i:integer;
begin
  s:='';
  for i:=1 to n  do  s:=s+' ';
  space:=s;
end;

{------------------------------------------}
function  padR (s:string; n:integer) : string;
begin
  if  length(s)<n  then  padr:=s + space (n-length(s))
                   else  padr:=copy (s, 1, n);
end;

{------------------------------------------}
{------------------------------------------}
function  getValue (var par:string) : integer;
  var
    i, v, code : integer;
    p : string;
begin
  i:=pos (';', par);
  if  i>0  then begin
    p:=copy (par, 1, i-1);
    par:=copy (par, i+1, 255);
    end
  else begin
    p:=par;
    par:=''
    end;
  Val (p, v, code);
  if  code<>0  then begin
    writeln ('Invalid number: ', p);
    Halt (3);
    end
  else  getValue:=v;
end;

{------------------------------------------}
procedure  getParam (par:string);
  var
    typ : char;  {typ parametru}

begin
  if  length(par)=0  then  exit;
  if  par[1] in ['/','-']  then  par:=copy (par, 2, 255);
  typ:=par[1];
  if  par[2]<>'='  then begin
    writeln('Missing =');
    Halt (3)
    end;
  par:=copy (par, 3, 255);
  typ:=LwCase (typ);
  if       typ='i'  then  iniFile:=par
  else if  typ='m'  then  iniMode:=par
  else if  typ='c'  then  cmd:=par
  else if  typ='p'  then begin
    if  par<>''  then  c0:=getValue (par);
    if  par<>''  then  r0:=getValue (par);
    if  par<>''  then  nR:=getValue (par);
    if  par<>''  then  Fr:=getVAlue (par);
    if  par<>''  then  aFrmAtr:=getValue (par);
    if  par<>''  then  aLowAtr:=getValue (par);
    if  par<>''  then  aHigAtr:=getValue (par);
    if  par<>''  then  aErrAtr:=getValue (par);
    end
  else if  typ='e'  then begin
    if  par<>''  then  eC:=getValue (par);
    if  par<>''  then  eR:=getValue (par);
    if  par<>''  then  eW:=getValue (par);
    if  par<>''  then  aEdiAtr:=getValue (par);
    if  par<>''  then  eP:=par;
    end
  else begin
    writeln('Unrecognized Parm ',typ);
    Halt (3)
    end;
end;

{------------------------------------------}
procedure  ParseParms;
  var
    i : integer;
begin
  if  ParamCount=0  then  begin Help; Halt (3) end;
  iniPath:=ParamStr(1);
  for  i:=2 to ParamCount  do  getParam (ParamStr(i));

  if       Fr=2  then Frame:=doubleFrame
  else if  Fr=1  then Frame:=singleFrame
  else    {Fr=0}      Frame:='        ';

  for  i:=1 to length(eP)  do  if eP[i]='+' then eP[i]:=' ';
end;

{------------------------------------------}
procedure  Sort;
  procedure qSort (l,r:integer);
    var i,j,k:integer;
        it, iit :string[12];
  begin
    k:=(l+r) div 2;
    i:=l; j:=r;
    iit:=item^[k];
    repeat
      while  (Item^[i]<iit)  do
        inc(i);
      while  (iit<Item^[j])  do
        dec(j);
      if  i<=j  then begin
        it:=Item^[i];
        Item^[i]:=Item^[j];
        Item^[j]:=it;
        inc(i); dec(j);
        end;
    until i>j;
    if  j-l < r-i  then begin
      if  l<j  then  qSort (l, j);
      if  i<r  then  qSort (i, r);
      end
    else begin
      if  i<r  then  qSort (i, r);
      if  l<j  then  qSort (l, j);
      end;
  end;
begin
  qSort (1,nP);
end;

{------------------------------------------}
procedure  ReadFiles (iniPath:pathStr);
  var
    Aux : SearchRec;
    n : string[12];
    i : byte;
    nasel : boolean;
begin
  nP:=0;
  iP:=1;
  New (item);
  for i:=1 to length(iniFile)  do  iniFile[i]:=LwCase(iniFile[i]);

  FindFirst (iniPath, AnyFile-VolumeID-Directory, Aux);
  while  DosError=0  do begin
    inc(nP);
    n:=Aux.Name;
    for i:=1 to length(n)  do  n[i]:=LwCase(n[i]);
    i:=pos('.', n);
    if i>0  then  insert(space(9-i), n, i);
    Item^[nP]:=PadR (n, 12);
    FindNext (Aux);
    end;  {of while}

  if  (pos('s',iniMode)=0) and (pos('S',iniMode)=0)  then  Sort;

  { pokus o nalezeni souboru iniFile }
  i:=pos('.', iniFile);
  if i>0  then  insert(space(9-i), iniFile, i);
  for  i:=1 to length(iniFile)  do  iniFile[i]:=LwCase(iniFile[i]);
  i:=0;
  nasel:=false;
  while  not nasel and (i<nP)  do begin
    inc(i);
    if iniFile=copy(item^[i],1,length(iniFile))  then  nasel:=true;
    end;
  if  nasel  then  iP:=i  else  iP:=1
end;

{------------------------------------------}
procedure  runMenu (var endKey:integer);
var
  ky : integer;
  buffer : pointer;
  winSt : winState;
  konec : boolean;
  find  : string[12];

  procedure  hideCursor;
  begin asm
    mov ah,0fh
    int 10h
    mov ah,02h
    mov dx,8000h
    int 10h
    end
  end;

  procedure  Zobraz (iR, iP: integer; Atr:byte);
  begin
    { do radky iR zobrazime polozku iP }
    writeStr (1, iR, ' '+padR(item^[iP],w0)+' ', Atr);
  end;

  procedure  SkokNa (ii:integer);
    var  i, c : integer;
  begin
    c:=(nR+1) div 2;
    if       nP <= nR    then  iR:=ii
    else if  ii <= c     then  iR:=ii
    else if  ii >  nP-c  then  iR:=nR-nP+ii
    else                   iR:=c;
    ClrScr;
    for  i:=1 to min(nR,nP)  do
      if i=iR then  zobraz (i, ii-iR+i, aHigAtr)
              else  zobraz (i, ii-iR+i, aLowAtr);
    if  find=''   then  hideCursor
                  else  gotoXY (length(find)+1, iR);
    iP:=ii;
  end;

  procedure  Roluj (up:integer);
  begin
    if  up>0  then  while  (up>0) and (iP>1)  do begin
      zobraz (iR, iP, aLowAtr);
      dec (iP);
      if  iR=1  then begin
        GotoXY (1,1);
        InsLine;
        end
      else  dec (iR);
      zobraz (iR, iP, aHigAtr);
      dec (up);
      end
    else  {up<0}  while  (up<0) and (iP<nP)  do begin
      zobraz (iR, iP, aLowAtr);
      inc (iP);
      if  iR>=nR  then begin
        GotoXY (1,1);
        DelLine;
        end
      else  inc (iR);
      zobraz (iR, iP, aHigAtr);
      inc (up);
      end;
    find:='';
    hideCursor;
  end;

  procedure  FindFile (ky:integer);
    var
      f : string;
      i, ii : integer;
      konec : boolean;
  begin
    if  ky=kBsp  then begin
      if  find<>''  then  find:=copy (find, 1, length(find)-1);
      f:=find;
      end
    else begin
      f:=find+LwCase(char(ky));
      end;
    ii:=0;
    i:=0;
    konec:=false;
    repeat
      inc (i);
      if  f=copy(item^[i],1,length(f))  then begin ii:=i; konec:=true end;
    until  konec or (i>=nP);
    if  ii>0  then begin
      iP:=ii;
      find:=f;
      SkokNa (iP);
      end;
  end;

  procedure noFiles;
    var
      s1, s2 : string;
      k : integer;
  begin
    s1:=' Nen dn soubor  '+iniPath+'  ';
    saveWin (winSt);
    window (c0, r0, c0+length(s1)+1, r0+2);
    getmem (buffer, winSize);
    readWin (buffer^);
    frameWin ('', doubleFrame, aErrAtr, aErrAtr);
    writeStr (1,1,s1,aErrAtr);
    k:=waitkey;
    unFrameWin;
    writeWin (buffer^);
    freeMem (buffer, winSize);
    restoreWin (winSt);
  end;

begin
  if  nP=0  then  noFiles
  else begin

    nR:=min (nP, nR);
    if  (pos('e',iniMode)>0) or (pos('e',iniMode)>0)  then  w0:=8;

    saveWin (winSt);
    window (c0, r0, c0+w0+3, r0+nR+1);
    getmem (buffer, winSize);
    readWin (buffer^);
    frameWin ('', Frame, aTitAtr, aFrmAtr);

    find:='';
    SkokNa (iP);
    konec:=false;
    while  not konec  do begin
      ky:=waitKey;
      if       (ky=kUp   )   then  Roluj (1)
      else if  (ky=kDn   )   then  Roluj (-1)
      else if  (ky=kPgUp ) and (iR>1 )  then  Roluj (iR-1)
      else if  (ky=kPgUp )              then  Roluj (nR-1)
      else if  (ky=kPgDn ) and (iR<nR)  then  Roluj (iR-nR)
      else if  (ky=kPgDn )              then  Roluj (1-nR)
      else if  (ky=kHome )   then  begin  find:=''; SkokNa (1)  end
      else if  (ky=kEnd  )   then  begin  find:=''; SkokNa (nP) end
      else if  (ky=kEsc  )   then  konec:=true
      else if  (ky=kEnter)   then  konec:=true
      else if  (ky=kBsp  )   then  FindFile (ky)
      else if  (ky>32    )   then  FindFile (ky)
      end;
    endKey:=ky;
    unFrameWin;
    writeWin (buffer^);
    freeMem (buffer, winSize);
    restoreWin (winSt);
    end;

end;

{------------------------------------------}
procedure  editName (x, y, len : integer; var S:string; var endKey:integer);
  var
    winSt : winState;
    sp, str : string;
    i, ky, last, p : integer;
    konec : boolean;
    buffer : pointer;

  procedure  Mnu;
    var
      k:integer;
  begin
    RunMenu (k);
    if  k=kEnter  then begin
      ky:=kEnter;
      str:=item^[iP];
      konec:=true;
      end;
  end;

begin
  str:=S;
  sp:=space(len);
  saveWin (winSt);
  if  eP=''  then  window (x, y, x+len-1, y)
             else  window (x, y, x+len+4+length(eP), y+2);
  getmem (buffer, winSize);
  readWin (buffer^);
  if  eP<>''  then begin
    frameWin ('', Frame, aTitAtr, aFrmAtr);
    writeStr (1,1, ' '+eP+' '+sp+' ', aLowAtr);
    p:=length(eP)+2;
    end
  else  p:=0;
  i:=1;
  last:=kEsc;
  writeStr (1+p, 1, str+space (len-length(str)), aEdiAtr);
  gotoXY (i+p,1);
  ky:=waitKey;
  if  ky>=32  then  str:='';
  konec:=false;
  while  not konec  do begin

    if       (ky>31) and (length(str)<len)  then begin

                 if  i>length(str)  then str:=str+space(i-length(str)-1);
                 insert (chr(ky), str, i);
                 i:=min (i+1, len);
                 end
    else if  (ky=kUp)              then  Mnu
    else if  (ky=kDn)              then  Mnu
    else if  (ky=kPgUp)            then  Mnu
    else if  (ky=kPgDn)            then  Mnu
    else if  (ky=kLeft) and (i=1)  then  Mnu
    else if  (ky=kLeft)    then  i:=max (i-1, 1)
    else if  (ky=kRight)   then  i:=min (i+1, len)
    else if  (ky=kHome)    then  i:=1
    else if  (ky=kEnd)     then  i:=min (len, length (str)+1)
    else if  (ky=kDel)     then  delete (str, i, 1)
    else if  (ky=kBsp)     then begin
                             delete(str,i-1,1);
                             i:=max (i-1, 1);
                             end
    else if  (ky=kEnter)   then  konec:=true
    else if  (ky=kEsc)     then begin
                             if last=kEsc then konec:=true
                             else begin
                               str:=S;
                               i:=min (len, length(str));
                               end;
                             end;

    writeStr (1+p, 1, str+space (len-length(str)), aEdiAtr);
    gotoXY (i+p,1);

    last:=ky;
    if  not konec  then  ky:=waitKey;
    end;

  if  eP<>''  then  unFrameWin;
  writeWin (buffer^);
  freeMem (buffer, winSize);
  restoreWin (winSt);
  endKey:=ky;
  if  ky=kEnter  then  S:=str;
end;

{------------------------------------------}
procedure  GetName;
  var
    ky : integer;
    str : string;
begin
  if  eR=0  then begin
    RunMenu (ky);
    if  ky=kEnter  then  finFile:=item^[iP];
    end
  else begin
    str:=iniFile;
    editName (eC, eR, eW, str, ky);
    if  ky=kEnter  then  finFile:=str;
    end;
end;

{------------------------------------------}
procedure  Fin;
  var
    d : string[2];   {drive:}
    p : dirStr;      {path}
    n : nameStr;     {name}
    e : extStr;      {extension}
    typ : string[4]; {type of replacement}
    r : string;      {replacement text}
    c : string;      {command}
    i, j : integer;

begin
  fSplit (finFile, p, n, e);
  if  p=''  then begin
    getDir (0, p);
    p:=p+'\';
    end;
  d:=copy (p, 1, 2);
  p:=copy (p, 3, 255);
  while  pos(' ',n)>0  do  delete(n, pos(' ',n), 1);

  while  cmd<>''  do begin
    i:=pos (';', cmd);
    if  i>0  then begin
      c:=copy (cmd, 1, i-1);
      cmd:=copy (cmd, i+1, 255);
      end
    else begin
      c:=cmd;
      cmd:=''
      end;
    for i:=1 to length(c)  do  if c[i]='+' then c[i]:=' ';
    i:=pos ('[', c);
    j:=pos (']', c);
    if  (i<j) and (i*j>0)  then begin
      typ:=copy (c, i+1, j-i-1);
      if  typ=''  then  typ:='NE';
      r:='';
      if  (pos('d',typ)>0) or (pos('D',typ)>0)  then  r:=r+d;
      if  (pos('p',typ)>0) or (pos('P',typ)>0)  then  r:=r+p;
      if  (pos('n',typ)>0) or (pos('N',typ)>0)  then  r:=r+n;
      if  (pos('e',typ)>0) or (pos('E',typ)>0)  then  r:=r+e;
      delete (c, i, j-i+1);
      insert (r, c, i);
      end
    else if  i+j>0  then begin
      writeln ('Error in command: ', c);
      halt (3);
      end;
    if  c<>''  then  writeln (c);
    end;

end;

{=============================}
begin
  IniParms;
  ParseParms;
  ReadFiles (iniPath);
  GetName;
  if  finFile<>''  then  begin Fin; Halt(0) end
                   else  Halt(1);
end.
